/*
 * Decompiled with CFR 0.152.
 */
package com.neusoft.education.tp.sso.client.validator.http;

import com.neusoft.education.tp.sso.util.SecureURL;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTicketValidator {
    private String casValidateUrl;
    private String proxyCallbackUrl;
    private String st;
    private String service;
    private String pgtIou;
    private String user;
    private String errorCode;
    private String errorMessage;
    private String entireResponse;
    private Map<String, String> userMap = new HashMap<String, String>();
    private boolean renew = false;
    private boolean successfulAuthentication;

    public void setCasValidateUrl(String x) {
        this.casValidateUrl = String.valueOf(x) + "/serviceValidate";
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setProxyCallbackUrl(String x) {
        this.proxyCallbackUrl = x;
    }

    public void setRenew(boolean b) {
        this.renew = b;
    }

    public String getProxyCallbackUrl() {
        return this.proxyCallbackUrl;
    }

    public void setServiceTicket(String x) {
        this.st = x;
    }

    public void setService(String x) {
        try {
            x = URLEncoder.encode(x, System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.service = x;
    }

    public String getUser() {
        return this.user;
    }

    public Map<String, String> getUserMap() {
        return this.userMap;
    }

    public String getPgtIou() {
        return this.pgtIou;
    }

    public boolean isAuthenticationSuccesful() {
        return this.successfulAuthentication;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getResponse() {
        return this.entireResponse;
    }

    public void validate() {
        try {
            String response;
            if (this.casValidateUrl == null || this.st == null) {
                throw new IllegalStateException("must set validation URL and ticket");
            }
            this.clear();
            String url = this.getRemoteUrl();
            this.entireResponse = response = SecureURL.retrieve(url);
            if (response != null) {
                XMLReader r = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                r.setFeature("http://xml.org/sax/features/namespaces", false);
                r.setContentHandler(this.newHandler());
                r.parse(new InputSource(new StringReader(response)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getRemoteUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.casValidateUrl);
        if (this.casValidateUrl.indexOf(63) == -1) {
            sb.append('?');
        } else {
            sb.append('&');
        }
        sb.append("service=" + this.service + "&ticket=" + this.st);
        if (this.proxyCallbackUrl != null) {
            sb.append("&pgtUrl=" + this.proxyCallbackUrl);
        }
        if (this.renew) {
            sb.append("&renew=true");
        }
        return sb.toString();
    }

    protected DefaultHandler newHandler() {
        return new Handler();
    }

    protected void clear() {
        this.errorMessage = null;
        this.pgtIou = null;
        this.user = null;
        this.successfulAuthentication = false;
    }

    public boolean isRenew() {
        return this.renew;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(ServiceTicketValidator.class.getName());
        if (this.casValidateUrl != null) {
            sb.append(" casValidateUrl=[");
            sb.append(this.casValidateUrl);
            sb.append("]");
        }
        if (this.proxyCallbackUrl != null) {
            sb.append(" proxyCallbackUrl=[");
            sb.append(this.proxyCallbackUrl);
            sb.append("]");
        }
        if (this.st != null) {
            sb.append(" ticket=[");
            sb.append(this.st);
            sb.append("]");
        }
        if (this.service != null) {
            sb.append(" service=[");
            sb.append(this.service);
            sb.append("]");
        }
        if (this.pgtIou != null) {
            sb.append(" pgtIou=[");
            sb.append(this.pgtIou);
            sb.append("]");
        }
        if (this.user != null) {
            sb.append(" user=[");
            sb.append(this.user);
            sb.append("]");
        }
        if (this.errorCode != null) {
            sb.append(" errorCode=[");
            sb.append(this.errorCode);
            sb.append("]");
        }
        if (this.errorMessage != null) {
            sb.append(" errorMessage=[");
            sb.append(this.errorMessage);
            sb.append("]");
        }
        sb.append(" renew=");
        sb.append(this.renew);
        if (this.entireResponse != null) {
            sb.append(" entireResponse=[");
            sb.append(this.entireResponse);
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    protected class Handler
    extends DefaultHandler {
        protected static final String AUTHENTICATION_SUCCESS = "sso:authenticationSuccess";
        protected static final String AUTHENTICATION_FAILURE = "sso:authenticationFailure";
        protected static final String PROXY_GRANTING_TICKET = "sso:proxyGrantingTicket";
        protected static final String USER = "sso:user";
        protected static final String ATTRIBUTES = "sso:attributes";
        protected static final String ATTRIBUTE = "sso:attribute";
        protected StringBuffer currentText = new StringBuffer();
        protected boolean authenticationSuccess = false;
        protected boolean authenticationFailure = false;
        protected String netid;
        protected String pgtIou;
        protected String errorCode;
        protected String errorMessage;

        protected Handler() {
        }

        public void startElement(String ns, String ln, String qn, Attributes a) {
            this.currentText = new StringBuffer();
            if (qn.equals(AUTHENTICATION_SUCCESS)) {
                this.authenticationSuccess = true;
            } else if (qn.equals(AUTHENTICATION_FAILURE)) {
                this.authenticationFailure = true;
                this.errorCode = a.getValue("code");
                if (this.errorCode != null) {
                    this.errorCode = this.errorCode.trim();
                }
            } else if (qn.equals(ATTRIBUTE)) {
                String name = a.getValue("name");
                String val = a.getValue("value");
                ServiceTicketValidator.this.userMap.put(name, val);
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.currentText.append(ch, start, length);
        }

        public void endElement(String ns, String ln, String qn) throws SAXException {
            if (this.authenticationSuccess) {
                if (qn.equals(USER)) {
                    ServiceTicketValidator.this.user = this.currentText.toString().trim();
                }
                if (qn.equals(PROXY_GRANTING_TICKET)) {
                    this.pgtIou = this.currentText.toString().trim();
                }
            } else if (this.authenticationFailure && qn.equals(AUTHENTICATION_FAILURE)) {
                this.errorMessage = this.currentText.toString().trim();
            }
        }

        public void endDocument() throws SAXException {
            if (this.authenticationSuccess) {
                ServiceTicketValidator.this.user = ServiceTicketValidator.this.user;
                ServiceTicketValidator.this.pgtIou = this.pgtIou;
                ServiceTicketValidator.this.successfulAuthentication = true;
            } else if (this.authenticationFailure) {
                ServiceTicketValidator.this.errorMessage = this.errorMessage;
                ServiceTicketValidator.this.errorCode = this.errorCode;
                ServiceTicketValidator.this.successfulAuthentication = false;
            } else {
                throw new SAXException("no indication of success or failure from sso");
            }
        }
    }
}

