/*
 * Decompiled with CFR 0.152.
 */
package com.neusoft.education.tp.sso.proxy;

import com.neusoft.education.tp.sso.util.SecureURL;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ProxyGrantingTicket {
    private static Log log = LogFactory.getLog(ProxyGrantingTicket.class);
    private String pgtId;
    private String casProxyUrl;

    ProxyGrantingTicket(String pgtId, String casProxyUrl) {
        if (pgtId == null || casProxyUrl == null) {
            throw new IllegalArgumentException("Cannot instantiate ProxyGrantingTicket(" + pgtId + "," + casProxyUrl + ")");
        }
        this.pgtId = pgtId;
        this.casProxyUrl = casProxyUrl;
    }

    public String getProxyTicket(String target) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering getProxyTicket(target=[" + target + "]) of PGT " + this));
        }
        String proxyTicket = null;
        String url = String.valueOf(this.casProxyUrl) + "?pgt=" + this.pgtId + "&targetService=" + target;
        String response = SecureURL.retrieve(url);
        if (response.indexOf("<sso:proxySuccess>") != -1 && response.indexOf("<sso:proxyTicket>") != -1) {
            int startIndex = response.indexOf("<sso:proxyTicket>") + "<sso:proxyTicket>".length();
            int endIndex = response.indexOf("</sso:proxyTicket>");
            proxyTicket = response.substring(startIndex, endIndex);
        } else {
            log.error((Object)("sso server responded with error for request [" + url + "].  Full response was [" + response + "]"));
        }
        log.trace((Object)("returning from getProxyTicket() with proxy ticket [" + proxyTicket + "]"));
        return proxyTicket;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" pgtId=[").append(this.pgtId).append("] ");
        sb.append(" casProxyUrl=[").append(this.casProxyUrl).append("]");
        return sb.toString();
    }
}

