/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Arrays;
import java.util.Iterator;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeStepExecutionListener
implements StepExecutionListener {
    private OrderedComposite<StepExecutionListener> list = new OrderedComposite();

    public void setListeners(StepExecutionListener[] listeners) {
        this.list.setItems(Arrays.asList(listeners));
    }

    public void register(StepExecutionListener stepExecutionListener) {
        this.list.add(stepExecutionListener);
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus status = null;
        Iterator<StepExecutionListener> iterator = this.list.reverse();
        while (iterator.hasNext()) {
            StepExecutionListener listener = iterator.next();
            ExitStatus close = listener.afterStep(stepExecution);
            status = status != null ? status.and(close) : close;
        }
        return status;
    }

    public void beforeStep(StepExecution stepExecution) {
        Iterator<StepExecutionListener> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            StepExecutionListener listener = iterator.next();
            listener.beforeStep(stepExecution);
        }
    }
}

