/**
 * 序号：1
 * 功能：定义分页(EasyUI)
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：无需更改
 **/

var ls_width = $(window).width();
var ls_height = $(window).height();

$(window).resize(function(){
	ls_width = $(window).width();
	ls_height = $(window).height();
});

var local_page=1;
var rows=20;
var listPageSize = [10,20,50,100,500,1000];
var queryData = eval("({'page':'"+local_page+"','rows':'"+rows+"'})");
var tab_n = 0;

//重置分页参数
function resetQueryData(){
	queryData = "";
	queryData = eval("({'page':'"+local_page+"','rows':'"+rows+"'})");
}

//定义用户当前全局参数

/****/

/**
 * 序号：2
 * 功能：构建下拉框内容
 * 参数：
 * 说明：方便新增、修改页面里的下拉选项加载数据
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
//加载推送客户下拉框
var v_webservicesuser_data = jwAppCommonModel.jwAppsCommonDataAction.listSysUserAll({});

//加载是否在编下拉框
var v_yesnoquery = {};
v_yesnoquery.FIELD_tableName = "DM_ST_YES_NO";
var v_yesnoquery_data = standardModel.dataAction.listAllCache(v_yesnoquery);

//加载推送类型下拉框
var v_type_data = [{CODE_ID:'1',CODE_NAME:'人员数据'},{CODE_ID:'2',CODE_NAME:'单位数据'}];
/****/

/**
 * 序号：3
 * 功能：构建主页面列表
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
//定义grid列表
$('#list').datagrid({
		title:"推送信息",
	    iconCls:$.getJwWindowPic(),
	    url:'jwAppsPushDataData_listPushData',
	    queryParams : {FIELD_ISFINISH:'0'},//查询参数
		rownumbers : true,//显示索引号
		singleSelect : false,//是否多选
		fitColumns : false,//是否撑满
		autoRowHeight : 30,//设定高度
		pagination : true,//分页显示
		pageSize : rows,//显示行数
		pageList : listPageSize,//条数选择
		striped : true, //是否隔行显示
		remoteSort : false,//是否从服务器排序
		frozenColumns : [[
				{
					field : 'ck',
					checkbox : true
				},
				{
					field : 'option',
					title : '操作',
					width : 80,
					align : 'center',
					formatter : formatMenu
				}
				       ]],
		columns : [ [
				{
					field : 'CLIENT_CODE',
					title : '推送客户',
					width : 100,
					align : 'center',
					formatter : function(value) {
						return getSysUserName(v_webservicesuser_data.rowSet, value);
					}
				}, {
					field : 'TYPE',
					title : '推送类型',
					width : 100,
					align : 'center',
					formatter : function(value) {
						return getCodeName(v_type_data, value);
					}
				}, {
					field : 'PUSH_URL',
					title : '推送地址',
					width : 330,
					align : 'left'
				}, {
					field : 'UPDATE_TIME1',
					title : '推送时间',
					width : 120,
					align : 'center'
				}, {
					field : 'ISFINISH',
					title : '已完成',
					width : 80,
					align : 'center',
					formatter : function(value) {
						return getCodeName(v_yesnoquery_data.rowSet, value);
					}
				}, {
					field : 'PUSH_DATA_NAME',
					title : '推送数据ID描述',
					width : 100,
					align : 'center'
				}, {
					field : 'PUSH_ENCODE',
					title : '推送编码',
					width : 80,
					align : 'center'
				}, {
					field : 'SETCOUNT',
					title : '推送设定次数',
					width : 90,
					align : 'center'
				}, {
					field : 'ERRORCOUNT',
					title : '推送失败次数',
					width : 90,
					align : 'center'
				}
				] ],
		toolbar : '#tb',
		onLoadSuccess : function(data) {
			$('#ISFINISH').combobox({
				data : v_yesnoquery_data.rowSet,
				valueField : 'CODE_ID',
				textField : 'CODE_NAME',
				editable:false,  
				panelHeight:'auto'
			});
			createOptionMenuTooltip(60);
		}
});

/****/

/**
 * 序号：4
 * 功能：设置操作列浮动菜单
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
//操用列显示更多(一般情况下无需更改)
function formatMenu(value, data,index) {
	var returnData="";
	return  returnData
	      + "<span class=\"icon-ext-moremenu\" style=\"padding-left:20px;*width:20px;\"></span>"
	      + "<span data-p1="+index+" class=\"easyui-tooltip\" style=\"color:blue;cursor:pointer;\">更多</span>";
}

//上浮横向菜单集里的具体菜单项(需更改)
function getOptionMenu(data,index){
	var returnData= "<span class=\"icon-edit\" style=\"padding-left:20px;*width:20px;\"></span><a href=\"javascript:void(0);\" onclick=\"editRow('"
		+ index + "')\">编辑</a>  |  <span class=\"icon-clear\" style=\"padding-left:20px;*width:20px;\"></span><a href=\"javascript:void(0);\" onclick=\"deleteRow('"
		+ index + "')\">删除</a>";
	return returnData;
}

//返回菜单集的菜单个数(需更改)
function getOptionMenuCount(){
	var is_menu_count = 2;
	return is_menu_count;
}

/****/

/**
 * 序号：5
 * 功能：修改弹出
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
//加载修改子页面
function editRow(index){
	var is_row = {};
	$('#list').datagrid('selectRow',index);
	is_row = $('#list').datagrid('getSelections');
	$('#list').datagrid('clearSelections');
	is_row[0].OPETYPE = 'update';
	openEditRow("jwAppsPushDataView_PushDataDetail",is_row[0],"编辑",true,0.95,0.95,0,0);	
}
//加载修改子页面成功后的回调
function updateUrlOnloadCallback(is_row){
}
//保存
function updateData(is_entity){
	is_entity.FIELD_OPETYPE='';
	var v_result = jwAppPushDataModule.jwAppsPushDataActAction.updatePushData(is_entity);
	$('#list').datagrid('reload');
	return v_result;
}
/****/

/**
 * 序号：6
 * 功能：单个删除
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
function deleteRow(index){
	$('#list').datagrid('selectRow',index);	
	var is_row = $('#list').datagrid('getSelections');
	$('#list').datagrid('clearSelections');

	var code = is_row[0].UUID;
	$.messager.confirm('提示', '确定删除?', function(r) {
		if (r) {
			var v_query = {};
		    v_query.deletekey = code;
		    var v_result = jwAppPushDataModule.jwAppsPushDataActAction.deletePushData(v_query);
			$.messager.alert('提示',v_result.VALUE);
			$('#list').datagrid('reload');
		}
	});
}
/****/

/**
 * 序号：7
 * 功能：批量删除
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
function deleteBatchRow(){
	var code="";
	var is_row = $('#list').datagrid('getSelections');
	for(var i=0; i<is_row.length; i++){
		code = code + is_row[i].UUID+",";
	}
	if(is_row == null || is_row == ""){
		$.messager.alert('提示',"请选择需删除的行!",'info');
		return;
	}
	if(code.length>0){
		code = code.substring(0,code.length - 1);
	}
	$.messager.confirm('提示', '确定删除?', function(r) {
		if (r) {
			var v_query = {};
		    v_query.deletekey = code;
		    var v_result = jwAppPushDataModule.jwAppsPushDataActAction.deletePushData(v_query);
			$.messager.alert('提示',v_result.VALUE);
			$('#list').datagrid('reload');
		}
	});
}
/****/

/**
 * 序号：8
 * 功能：刷新
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
function refreshRow(){
	$('#list').datagrid('load',{FIELD_ISFINISH:'0'});
	$("#listPushDataTab_searchForm")[0].reset();
}
/****/

/**
 * 序号：9
 * 功能：查询
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
function searchRow(){
	var v_query = $("#listPushDataTab_searchForm").getFormVal();
	$('#list').datagrid('load',v_query);
}
/****/

/**
 * 序号：10
 * 功能：未完成设置
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
function setNoFinish(){
	var uuids="";
	var rows = $('#list').datagrid('getSelections');
	for(var i=0; i<rows.length; i++){
		uuids = uuids + rows[i].UUID+",";
		if(rows[i].ISFINISH == '0'){
			$.messager.alert('提示',"请选择已完成的行进行设置!",'info');
			return;
		}
	}
	if(rows == null || rows == ""){
		$.messager.alert('提示',"请选择需设置的行!",'info');
		return;
	}
	if(uuids.length>0){
		uuids = uuids.substring(0,uuids.length - 1);
	}
	$.messager.confirm('提示', '确定设成未完成?', function(r) {
		if (r) {
			var v_query = {};
		    v_query.FIELD_UUID =uuids;
		    v_query.FIELD_ISFINISH = '0';
		    var v_result = jwAppPushDataModule.jwAppsPushDataActAction.updatePushData(v_query);
			$.messager.alert('提示',v_result.VALUE);
			$('#list').datagrid('reload');
		}
	});
}
/****/

/**
 * 序号：11
 * 功能：错误次数置零
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
function setNoError(){
	var uuids="";
	var rows = $('#list').datagrid('getSelections');
	for(var i=0; i<rows.length; i++){
		uuids = uuids + rows[i].UUID+",";
		if(rows[i].ERRORCOUNT == '0'){
			$.messager.alert('提示',"请选择其它行设置!",'info');
			return;
		}
	}
	if(rows == null || rows == ""){
		$.messager.alert('提示',"请选择需设置的行!",'info');
		return;
	}
	if(uuids.length>0){
		uuids = uuids.substring(0,uuids.length - 1);
	}
	$.messager.confirm('提示', '确定置零?', function(r) {
		if (r) {
			var v_query = {};
		    v_query.FIELD_UUID = uuids;
		    v_query.FIELD_ERRORCOUNT = '0';
		    var v_result = jwAppPushDataModule.jwAppsPushDataActAction.updatePushData(v_query);
			$.messager.alert('提示',v_result.VALUE);
			$('#list').datagrid('reload');
		}
	});
}
/****/

/**
 * 序号：12
 * 功能：数据推送
 * 参数：
 * 说明：
 * 作者：高伟杰
 * 时间：2016-01-22
 * 单位：宁波金网
 * 备注：需更改
 **/
function start_push_data(){
	var uuids="";
	var rows = $('#list').datagrid('getSelections');
	for(var i=0; i<rows.length; i++){
		uuids = uuids + rows[i].UUID+",";
		if(rows[i].ISFINISH == '1'){
			$.messager.alert('提示',"请选择未完成的行进行推送!",'info');
			return;
		}
	}
	if(rows == null || rows == ""){
		$.messager.alert('提示',"请选择需推送的行!",'info');
		return;
	}
	if(uuids.length>0){
		uuids = uuids.substring(0,uuids.length - 1);
	}
	$.messager.confirm('提示', '确定数据推送?', function(r) {
		if (r) {
			var v_query = {};
		    v_query.FIELD_UUID = uuids;
		    v_query.FIELD_ISFINISH = '0';
		    var v_result = jwAppPushDataModule.jwAppsPushDataActAction.PushData(v_query);
			$.messager.alert('提示',v_result.VALUE);
			$('#list').datagrid('reload');
		}
	});
}
