package com.jw.app.apps.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.AppsBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class dataAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4630126275397330597L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
    private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}
	
	public String listAppAccount() throws BusinessException{
		AppsBusiness business = BusinessManager.getBusiness(AppsBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_app_account(pageNo,pageSize,query);
			for(Map<String,Object>m : pageRows.getItems()){
				if(m.get("PWD")!=null){
					m.put("PWD", Encipher.DecodePasswd((String)m.get("PWD")));
				}
			}
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAllAppAccount() throws BusinessException{
		AppsBusiness business = BusinessManager.getBusiness(AppsBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_app_account(query);
			for(Map<String,Object>m : listData){
				if(m.get("PWD")!=null){
					m.put("PWD", Encipher.DecodePasswd((String)m.get("PWD")));
				}
			}
			int listDataCount = business.listCount_app_account(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(listData));
		    data.put("pageNo", 1);
		    data.put("pageSize", listDataCount);
		    data.put("pageCount", listDataCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listApp() throws BusinessException{
		AppsBusiness business = BusinessManager.getBusiness(AppsBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_app(pageNo,pageSize,query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAllApp() throws BusinessException{
		AppsBusiness business = BusinessManager.getBusiness(AppsBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_apps_portal(query);
			int listDataCount = business.listCount_app(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(listData));
		    data.put("pageNo", 1);
		    data.put("pageSize", listDataCount);
		    data.put("pageCount", listDataCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAllCategory() throws BusinessException{
		AppsBusiness business = BusinessManager.getBusiness(AppsBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_category(query);
			int listDataCount = business.listCount_category(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(listData));
		    data.put("pageNo", 1);
		    data.put("pageSize", listDataCount);
		    data.put("pageCount", listDataCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listUserAllApp() throws BusinessException{
		AppsBusiness business = BusinessManager.getBusiness(AppsBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			query.put("USERID", SessionUtil.getCode());
			Page<Map<String, Object>> pageRows = business.list_userallapp(pageNo,pageSize,query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

}
