package com.jw.app.business.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.ContentBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class ContentBusinessImpl implements ContentBusiness {
	
	private ContentDAO contentDAO;

	public ContentDAO getContentDAO() {
		return contentDAO;
	}

	public void setContentDAO(ContentDAO contentDAO) {
		this.contentDAO = contentDAO;
	}

	public void insert_content(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值插入

		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里

          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          contentDAO.insert_content(entity);
        }
		//
		

	}

	@Override
	public void update_content(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改

		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里

		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));
			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    contentDAO.update_content(entity);
		}
		//

	}

	@Override
	public void delete_content(List<String> list)throws BusinessException {
		contentDAO.delete_content(list);	
	}
	
	@Override
	public Page<Map<String, Object>> list_content(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = contentDAO.list_content(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = contentDAO.listCount_content(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		try {
			page.setItems(QueryParamUtil.ClobToString(items));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_content(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> listData = null;
		try {
			listData = QueryParamUtil.ClobToString(contentDAO.list_content(query));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listData;
	}

	@Override
	public int listCount_content(Map<String, Object> query) throws BusinessException {
		return contentDAO.listCount_content(query);
	}

}
