package com.jw.app.business.mapping;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.MappingBusiness;

public class MappingBusinessImpl implements MappingBusiness {
	private MappingDAO MappingDAO;

	public MappingDAO getMappingDAO() {
		return MappingDAO;
	}

	public void setMappingDAO(MappingDAO mappingDAO) {
		MappingDAO = mappingDAO;
	}

	/**--------------单位---------------- **/
	@Override
	public void insert_table(Map<String, Object> entity)
			throws BusinessException {
		Map<String , Object> map=new HashMap<String , Object> ();
		map.putAll(entity);
		if(map.get("UUID")==null){
			map.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(map.get("CREATE_TIME")==null){
			map.put("CREATE_TIME", new Date());
		}
		if(map.get("CREATE_USER")==null){
			map.put("CREATE_USER", SessionUtil.getEmname());
		}
		if(map.get("UPDATE_USER")==null){
			map.put("UPDATE_USER", SessionUtil.getCode());
		}
		if(map.get("UPDATE_TIME")==null){
			map.put("UPDATE_TIME", new Date());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(map.keySet()!=null){
          Set<String> key  = map.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
        	  if (StringUtils.equalsIgnoreCase("tableName",str)) continue;
            infoList.add(map.get(str));
            infoListKey.add(str);
          }
          map.put("infoListKey", infoListKey);
          map.put("infoList", infoList);
          // 插入
          MappingDAO.insert_table(map);
        }
		//
	}

	@Override
	public void update_table(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		if(entity.get("UPDATE_USER")==null){
			entity.put("UPDATE_USER", SessionUtil.getCode());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   if (StringUtils.equalsIgnoreCase("tableName",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    MappingDAO.update_table(entity);
		}

	}

	@Override
	public void delete_table(Map<String, Object> query)
			throws BusinessException {
		MappingDAO.delete_table(query);
		
	}

	@Override
	public Page<Map<String, Object>> list_table(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = MappingDAO.list_table(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = MappingDAO.listCount_table(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_table(Map<String, Object> query)
			throws BusinessException {
		return MappingDAO.list_table(query);
	}

	@Override
	public int listCount_table(Map<String, Object> query)
			throws BusinessException {
		return MappingDAO.listCount_table(query);
	}
}
