package com.jw.app.business.move;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.MoveBusiness;

public class MoveBusinessImpl implements MoveBusiness {
	
	private MoveDAO moveDAO;

	public MoveDAO getMoveDAO() {
		return moveDAO;
	}

	public void setMoveDAO(MoveDAO moveDAO) {
		this.moveDAO = moveDAO;
	}

	@Override
	public void insert_move(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("APPLY_DATE")==null){
			entity.put("APPLY_DATE", new Date());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          moveDAO.insert_move(entity);
        }
		//
//		/**-----------同步到系统部门表-------------------------**/
//	    SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
//	    Map<String,Object> entity_back = new HashMap<String,Object>();
//	    entity_back.put("DPT_NO", entity.get("UUID"));
//	    entity_back.put("DPT_NAME", entity.get("NAME"));
//	    entity_back.put("SORT", entity.get("ORDER_ID"));
//	    entity_back.put("DELETE_FLAG", entity.get("DELETE_FLAG"));
//	    entity_back.put("CREATOR_ID", entity.get("CREATOR_ID"));
//	    entity_back.put("CREATE_TIME", entity.get("CREATE_TIME"));
//	    entity_back.put("UPDATE_TIME", entity.get("UPDATE_TIME"));
//	    systemOpeBusiness.insert_depart(entity_back);
	}

	@Override
	public void update_move(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    moveDAO.update_move(entity);
		}
//		/**-----------同步到系统部门表-------------------------**/
//	    SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
//	    Map<String,Object> entity_back = new HashMap<String,Object>();
//	    entity_back.put("DPT_NO", entity.get("UUID"));
//	    entity_back.put("DPT_NAME", entity.get("NAME"));
//	    entity_back.put("SORT", entity.get("ORDER_ID"));
//	    entity_back.put("DELETE_FLAG", entity.get("DELETE_FLAG"));
//	    entity_back.put("UPDATE_TIME", entity.get("UPDATE_TIME"));
//	    systemOpeBusiness.update_depart(entity_back);

	}

	@Override
	public void delete_move(List<String> list)
			throws BusinessException {
		moveDAO.delete_move(list);
		
//		for(String uuid:list){
//			/**-----------同步到系统部门表-------------------------**/
//		    SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
//		    Map<String,Object> entity_back = new HashMap<String,Object>();
//		    entity_back.put("DPT_NO", uuid);
//		    entity_back.put("DELETE_FLAG", "1");
//		    systemOpeBusiness.update_depart(entity_back);
//		}
		
	}

	@Override
	public Page<Map<String, Object>> list_move(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = moveDAO.list_move(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = moveDAO.listCount_move(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_move(Map<String, Object> query)
			throws BusinessException {
		return moveDAO.list_move(query);
	}

	@Override
	public int listCount_move(Map<String, Object> query)
			throws BusinessException {
		return moveDAO.listCount_move(query);
	}

}
