package com.jw.app.business.photo;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.Java_tool;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.PhotoBusiness;

public class PhotoBusinessImpl implements PhotoBusiness {
	
	private PhotoDAO photoDAO;

	public PhotoDAO getPhotoDAO() {
		return photoDAO;
	}

	public void setPhotoDAO(PhotoDAO photoDAO) {
		this.photoDAO = photoDAO;
	}

	/**--------------相册---------------- **/
	@Override
	public void insert_folder(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("RESOURCE_ID")==null){
			entity.put("RESOURCE_ID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("CREATOR_NAME")==null){
			entity.put("CREATOR_NAME", SessionUtil.getEmname());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("SHARE_TYPE")==null){
			entity.put("SHARE_TYPE", "1");
		}
		if(entity.get("ISPASSWORD")==null){
			entity.put("ISPASSWORD", "0");
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		photoDAO.insert_folder(entity);

	}

	@Override
	public void update_folder(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("PASSWORD")!=null){
			entity.put("PASSWORD", Encipher.EncodePasswd((String) entity.get("PASSWORD")));
		}
		photoDAO.update_folder(entity);

	}

	@Override
	public void delete_folder(List<String> list)
			throws BusinessException {
		List<Map<String, Object>> list_delete_folder = photoDAO.list_delete_album(list);
		List<String> list_delete_photo = new ArrayList<String>();
		for(Map<String, Object> m : list_delete_folder){
			String photo_id = (String) m.get("RESOURCE_ID");
			list_delete_photo.add(photo_id);
		}
		photoDAO.delete_folder(list);
		if(list_delete_photo.size()>0){
		  deleteFromAlbum_photo(list_delete_photo);
		}
	}

	@Override
	public Page<Map<String, Object>> list_folder(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = photoDAO.list_folder(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = photoDAO.listCount_folder(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_folder(Map<String, Object> query)
			throws BusinessException {
		return photoDAO.list_folder(query);
	}

	@Override
	public int listCount_folder(Map<String, Object> query)
			throws BusinessException {
		return photoDAO.listCount_folder(query);
	}
	
	/**--------------相片---------------- **/
	
	@Override
	public void insert_photo(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("RESOURCE_ID")==null){
			entity.put("RESOURCE_ID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("ISCOVER")==null){
			entity.put("ISCOVER", "0");
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("REMARK")==null){
			entity.put("REMARK", new Java_tool().time_sn());
		}
		if(entity.get("USER_ACCOUNT")==null){
			entity.put("USER_ACCOUNT", SessionUtil.getCode());
		}
		if(entity.get("CREATOR")==null){
			entity.put("CREATOR", SessionUtil.getEmname());
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		photoDAO.insert_photo(entity);

	}

	@Override
	public void update_photo(Map<String, Object> entity)
			throws BusinessException {
		photoDAO.update_photo(entity);

	}

	@Override
	public void delete_photo(List<String> list)
			throws BusinessException {
		List<Map<String, Object>> list_delete_photo = photoDAO.list_delete_photo(list);
		photoDAO.delete_photo(list);
		for(Map<String, Object> mfile : list_delete_photo){
			if(mfile.get("STORE_NAME")!=null){
				String delFileName = (String) mfile.get("STORE_NAME");
				File delFile = new File(delFileName);
				if(delFile.exists()){
					System.out.println("文件:"+delFileName+" 存在!");
					if(delFile.delete()){
						System.out.println("文件:"+delFileName+" 删除成功!");
					}else{
						System.out.println("文件:"+delFileName+" 删除失败!");
					}
				}else{
					System.out.println("文件:"+delFileName+" 不存在!");
				}
			}
		}
	}
	
	@Override
	public void deleteFromAlbum_photo(List<String> list) throws BusinessException {
		List<Map<String, Object>> list_deleteFromAlbum_photo = photoDAO.list_deleteFromAlbum_photo(list);
		photoDAO.deleteFromAlbum_photo(list);
		for(Map<String, Object> mfile : list_deleteFromAlbum_photo){
			if(mfile.get("STORE_NAME")!=null){
				String delFileName = (String) mfile.get("STORE_NAME");
				File delFile = new File(delFileName);
				if(delFile.exists()){
					System.out.println("文件:"+delFileName+" 存在!");
					if(delFile.delete()){
						System.out.println("文件:"+delFileName+" 删除成功!");
					}else{
						System.out.println("文件:"+delFileName+" 删除失败!");
					}
				}else{
					System.out.println("文件:"+delFileName+" 不存在!");
				}
			}
		}
	}

	@Override
	public Page<Map<String, Object>> list_photo(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = photoDAO.list_photo(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = photoDAO.listCount_photo(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_photo(Map<String, Object> query)
			throws BusinessException {
		return photoDAO.list_photo(query);
	}

	@Override
	public int listCount_photo(Map<String, Object> query)
			throws BusinessException {
		return photoDAO.listCount_photo(query);
	}
	
	@Override
	public void setCover_photo(Map<String,Object> entity) throws BusinessException{
		String iscover = "0";
		String resource_id = "";
		if(entity.get("RESOURCE_ID")!=null){
			resource_id = (String) entity.get("RESOURCE_ID");
			entity.remove("RESOURCE_ID");
			entity.put("ISCOVER", iscover);
			photoDAO.setCover_photo(entity);
			iscover = "1";
			entity.put("RESOURCE_ID", resource_id);
			entity.put("ISCOVER", iscover);
			photoDAO.setCover_photo(entity);
		}
	}
	
	@Override
	public void update_batchPhoto(Map<String, Object> entity)
			throws BusinessException {
		photoDAO.update_batchPhoto(entity);

	}
	
	/**--------------相册评论---------------- **/
	@Override
	public void insert_folder_note(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("RESOURCE_ID")==null){
			entity.put("RESOURCE_ID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("NOTE_TIME")==null){
			entity.put("NOTE_TIME", new Date());
		}
		if(entity.get("NOTE_CREATOR_ID")==null){
			entity.put("NOTE_CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("NOTE_STATE")==null){
			entity.put("NOTE_STATE", "0");
		}
		if(entity.get("NOTE_MODIFYTIME")==null){
			entity.put("NOTE_MODIFYTIME", new Date());
		}
		photoDAO.insert_folder_note(entity);

	}

	@Override
	public void update_folder_note(Map<String, Object> entity)
			throws BusinessException {
		photoDAO.update_folder_note(entity);

	}

	@Override
	public void delete_folder_note(List<String> list)
			throws BusinessException {
		photoDAO.delete_folder_note(list);
	}
	
	@Override
	public void delete_folderAlbumID_note(Map<String, Object> entity)
			throws BusinessException {
		photoDAO.delete_folderAlbumID_note(entity);

	}

	@Override
	public Page<Map<String, Object>> list_folder_note(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = photoDAO.list_folder_note(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = photoDAO.listCount_folder_note(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_folder_note(Map<String, Object> query)
			throws BusinessException {
		return photoDAO.list_folder_note(query);
	}

	@Override
	public int listCount_folder_note(Map<String, Object> query)
			throws BusinessException {
		return photoDAO.listCount_folder_note(query);
	}
	
	/**--------------相片评论---------------- **/
	@Override
	public void insert_photo_note(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("RESOURCE_ID")==null){
			entity.put("RESOURCE_ID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("NOTE_TIME")==null){
			entity.put("NOTE_TIME", new Date());
		}
		if(entity.get("NOTE_CREATOR_ID")==null){
			entity.put("NOTE_CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("NOTE_STATE")==null){
			entity.put("NOTE_STATE", "0");
		}
		if(entity.get("NOTE_MODIFYTIME")==null){
			entity.put("NOTE_MODIFYTIME", new Date());
		}
		photoDAO.insert_photo_note(entity);

	}

	@Override
	public void update_photo_note(Map<String, Object> entity)
			throws BusinessException {
		photoDAO.update_photo_note(entity);

	}

	@Override
	public void delete_photo_note(List<String> list)
			throws BusinessException {
		photoDAO.delete_photo_note(list);
	}
	
	@Override
	public void delete_folderPhotoID_note(Map<String, Object> entity)
			throws BusinessException {
		photoDAO.delete_folderPhotoID_note(entity);

	}

	@Override
	public Page<Map<String, Object>> list_photo_note(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = photoDAO.list_photo_note(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = photoDAO.listCount_photo_note(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_photo_note(Map<String, Object> query)
			throws BusinessException {
		return photoDAO.list_photo_note(query);
	}

	@Override
	public int listCount_photo_note(Map<String, Object> query)
			throws BusinessException {
		return photoDAO.listCount_photo_note(query);
	}

}
