package com.jw.app.business.pushData;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.PushDataBusiness;

public class PushDataBusinessImpl implements PushDataBusiness {
	
	private PushDataDAO pushDataDAO;
	private PushAppDAO pushAppDAO;

	public PushDataDAO getPushDataDAO() {
		return pushDataDAO;
	}

	public void setPushDataDAO(PushDataDAO pushDataDAO) {
		this.pushDataDAO = pushDataDAO;
	}

	public PushAppDAO getPushAppDAO() {
		return pushAppDAO;
	}

	public void setPushAppDAO(PushAppDAO pushAppDAO) {
		this.pushAppDAO = pushAppDAO;
	}

	/**--------------需推送数据---------------- **/
	@Override
	public void insert_pushData(Map<String, Object> entity)throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("ISFINISH")==null){
			entity.put("ISFINISH", "0");
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
        	if(entity.get(str)==null)continue;
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          pushDataDAO.insert_pushData(entity);
        }
	}

	@Override
	public void update_pushData(Map<String, Object> entity)throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if(StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   if(entity.get(str)==null)continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    pushDataDAO.update_pushData(entity);
		}

	}

	@Override
	public void delete_pushData(List<String> list)throws BusinessException {
		pushDataDAO.delete_pushData(list);
		
	}

	@Override
	public Page<Map<String, Object>> list_pushData(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = pushDataDAO.list_pushData(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = pushDataDAO.listCount_pushData(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_pushData(Map<String, Object> query)throws BusinessException {
		return pushDataDAO.list_pushData(query);
	}

	@Override
	public int listCount_pushData(Map<String, Object> query)throws BusinessException {
		return pushDataDAO.listCount_pushData(query);
	}
	
	/**--------------需推送数据所对应的应用---------------- **/
	
	@Override
	public void insert_pushApp(Map<String, Object> entity)throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
        	if(entity.get(str)==null)continue;
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          pushAppDAO.insert_pushApp(entity);
        }
	}

	@Override
	public void update_pushApp(Map<String, Object> entity)throws BusinessException {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if(StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   if(entity.get(str)==null)continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    pushAppDAO.update_pushApp(entity);
		}

	}

	@Override
	public void delete_pushApp(List<String> list)throws BusinessException {
		pushAppDAO.delete_pushApp(list);
		
	}
	
	@Override
	public void delete_pushApp_map(Map<String, Object> entity)throws BusinessException {
		pushAppDAO.delete_pushApp_map(entity);
		
	}

	@Override
	public Page<Map<String, Object>> list_pushApp(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = pushAppDAO.list_pushApp(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = pushAppDAO.listCount_pushApp(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_pushApp(Map<String, Object> query)throws BusinessException {
		return pushAppDAO.list_pushApp(query);
	}

	@Override
	public int listCount_pushApp(Map<String, Object> query)throws BusinessException {
		return pushAppDAO.listCount_pushApp(query);
	}
	
	@Override
	public List<Map<String,Object>> list_pushApp_all(Map<String,Object> query)throws BusinessException{
		return pushAppDAO.list_pushApp_all(query);
	}
	
	@Override
	public List<Map<String,Object>> list_pushData_one(String query) throws BusinessException{
		return pushDataDAO.list_pushData_one(query);
	}
	
	@Override
	public List<Map<String, Object>> list_pushData_user(String query) throws BusinessException{
		return pushDataDAO.list_pushData_user(query);
	}
	
	@Override
	public Page<Map<String, Object>> list_pushData_user(int pageNo, int pageSize, String query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = pushDataDAO.list_pushData_user(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = pushDataDAO.list_pushData_user_count(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}
	
	@Override
	public int list_pushData_user_count (String query) throws BusinessException{
		return pushDataDAO.list_pushData_user_count(query);
	}
	
	@Override
    public List<Map<String, Object>> list_pushData_unit(String query) throws BusinessException{
    	return pushDataDAO.list_pushData_unit(query);
    }
    
	@Override
	public Page<Map<String, Object>> list_pushData_unit(int pageNo, int pageSize, String query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = pushDataDAO.list_pushData_unit(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = pushDataDAO.list_pushData_unit_count(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}
	
	@Override
    public int list_pushData_unit_count (String query) throws BusinessException{
    	return pushDataDAO.list_pushData_unit_count(query);
    }
	
	@Override
	public Page<Map<String, Object>> list_pushApp_unit(int pageNo, int pageSize, Map<String,Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = pushAppDAO.list_pushApp_unit(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = pushAppDAO.listCount_pushApp_unit(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}
	
	@Override
    public List<Map<String,Object>> list_pushApp_unit(Map<String,Object> query)throws BusinessException{
		return pushAppDAO.list_pushApp_unit(query);
	}
    
	@Override
	public Page<Map<String, Object>> list_pushApp_user(int pageNo, int pageSize, Map<String,Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = pushAppDAO.list_pushApp_user(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = pushAppDAO.listCount_pushApp_user(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}
	
	@Override
    public List<Map<String,Object>> list_pushApp_user(Map<String,Object> query)throws BusinessException{
		return pushAppDAO.list_pushApp_user(query);
	}
	
	@Override
    public int listCount_pushApp_unit(Map<String, Object> query) throws BusinessException{
		return pushAppDAO.listCount_pushApp_unit(query);
	}
    
	@Override
    public int listCount_pushApp_user(Map<String, Object> query) throws BusinessException{
		return pushAppDAO.listCount_pushApp_user(query);
	}
}
