package com.jw.app.business.unit;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.standard.utils.CacheKit;
import com.jw.app.business.UnitBusiness;

public class UnitBusinessImpl implements UnitBusiness {
	
	private UnitDAO unitDAO;

	public UnitDAO getUnitDAO() {
		return unitDAO;
	}

	public void setUnitDAO(UnitDAO unitDAO) {
		this.unitDAO = unitDAO;
	}

	/**--------------单位---------------- **/
	@Override
	public void insert_unit(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("CREATOR_NAME")==null){
			entity.put("CREATOR_NAME", SessionUtil.getEmname());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("IS_ENTITY")==null){
			entity.put("IS_ENTITY", "1");
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          unitDAO.insert_unit(entity);
        }
		//
//		/**-----------同步到系统部门表-------------------------**/
//	    SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
//	    Map<String,Object> entity_back = new HashMap<String,Object>();
//	    entity_back.put("DPT_NO", entity.get("UUID"));
//	    entity_back.put("DPT_NAME", entity.get("NAME"));
//	    entity_back.put("SORT", entity.get("ORDER_ID"));
//	    entity_back.put("DELETE_FLAG", entity.get("DELETE_FLAG"));
//	    entity_back.put("CREATOR_ID", entity.get("CREATOR_ID"));
//	    entity_back.put("CREATE_TIME", entity.get("CREATE_TIME"));
//	    entity_back.put("UPDATE_TIME", entity.get("UPDATE_TIME"));
//	    systemOpeBusiness.insert_depart(entity_back);
	}

	@Override
	public void update_unit(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    unitDAO.update_unit(entity);
		}
//		/**-----------同步到系统部门表-------------------------**/
//	    SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
//	    Map<String,Object> entity_back = new HashMap<String,Object>();
//	    entity_back.put("DPT_NO", entity.get("UUID"));
//	    entity_back.put("DPT_NAME", entity.get("NAME"));
//	    entity_back.put("SORT", entity.get("ORDER_ID"));
//	    entity_back.put("DELETE_FLAG", entity.get("DELETE_FLAG"));
//	    entity_back.put("UPDATE_TIME", entity.get("UPDATE_TIME"));
//	    systemOpeBusiness.update_depart(entity_back);

	}

	@Override
	public void delete_unit(List<String> list)
			throws BusinessException {
		List<Map<String, Object>> list_delete_unit = unitDAO.list_delete_unit(list);
		unitDAO.delete_unit(list);
		for(Map<String, Object> mfile : list_delete_unit){
			if(mfile.get("UNIT_LOGO")!=null){
				String delFileName = (String) mfile.get("UNIT_LOGO");
				File delFile = new File(delFileName);
				if(delFile.exists()){
					System.out.println("单位LOGO文件:"+delFileName+" 存在!");
					if(delFile.delete()){
						System.out.println("单位LOGO文件:"+delFileName+" 删除成功!");
					}else{
						System.out.println("单位LOGO文件:"+delFileName+" 删除失败!");
					}
				}else{
					System.out.println("单位LOGO文件:"+delFileName+" 不存在!");
				}
			}
		}
		
//		for(String uuid:list){
//			/**-----------同步到系统部门表-------------------------**/
//		    SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
//		    Map<String,Object> entity_back = new HashMap<String,Object>();
//		    entity_back.put("DPT_NO", uuid);
//		    entity_back.put("DELETE_FLAG", "1");
//		    systemOpeBusiness.update_depart(entity_back);
//		}
		
	}

	@Override
	public Page<Map<String, Object>> list_unit(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = unitDAO.list_unit(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = unitDAO.listCount_unit(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_unit(Map<String, Object> query)
			throws BusinessException {
		return unitDAO.list_unit(query);
	}

	@Override
	public int listCount_unit(Map<String, Object> query)
			throws BusinessException {
		return unitDAO.listCount_unit(query);
	}
	
	@Override
	public List<Map<String, Object>> list_name_unit(List<String> list)
			throws BusinessException {
		return unitDAO.list_name_unit(list);
	}
	
	@Override
	public int list_max_order(Map<String, Object> query)
			throws BusinessException {
		return unitDAO.list_max_order(query);
	}
	
	@Override
	public List<Map<String, Object>> list_uuid_order(Map<String, Object> query)
			throws BusinessException {
		return unitDAO.list_uuid_order(query);
	}
	@Override
	public List<Map<String,Object>> list_unit_ldap() throws BusinessException{
		return unitDAO.list_unit_ldap();
    }
	
	@Override
	public Map<String, Object> list_unit_ldap_ou(String query) throws BusinessException{
		return unitDAO.list_unit_ldap_ou(query);
	}
	
	@Override
	public Map<String, Object> list_unit_ldap_uuid(String query) throws BusinessException{
		return unitDAO.list_unit_ldap_uuid(query);
	}
	
	@Override
	public List<Map<String,Object>> list_unit_ldap_deletekey() throws BusinessException {
		return unitDAO.list_unit_ldap_deletekey();
	}
	
	@Override
	public List<Map<String,Object>> listAllUnit() throws BusinessException{
		return unitDAO.listAllUnit();
	}
	
	@Override
	public List<Map<String,Object>> listUnitReceive(String query) throws BusinessException{
		return unitDAO.listUnitReceive(query);
	}
	
	@Override
	public List<Map<String, Object>> listUnitPush(Map<String, Object> query) throws BusinessException{
		return unitDAO.listUnitPush(query);
	}
	
	/*@Override
    public List<Map<String, Object>> list_tables_unit_cache(Map<String, Object> query)throws BusinessException {
        // 获取列表
    	String keyName = (String) query.get("tableName");
    	List<Map<String, Object>> list = CacheKit.get("ehcache11", "unit_"+keyName.toUpperCase());
    	if(list == null){
    		list  = unitDAO.list_unit(query);
    		CacheKit.put("ehcache11", "unit_"+keyName.toUpperCase(),list);
    	}
        return list;
    }
	
	@Override
	public void updateCache(Map<String, Object> query)throws BusinessException {
			     	String keyName = (String) query.get("tableName");
			     	List<Map<String, Object>> list = CacheKit.get("ehcache11", "unit_"+keyName.toUpperCase());
			     	if(list == null){
			     		list  = unitDAO.list_unit(query);
			     		CacheKit.put("ehcache11", "unit_"+keyName.toUpperCase(),list);
			     	}else{
			     		list  = unitDAO.list_unit(query);
			     		CacheKit.update("ehcache11", "unit_"+keyName.toUpperCase(),list);
			     	}
	 }*/
	
	/**
     * 用户是否在某些权限group中  user_id   groupList
     */
	@Override
	public int userGroup(Map<String, Object> query) throws BusinessException {
		// TODO Auto-generated method stub
		return unitDAO.userGroup(query);
	}
}