package com.jw.app.business.uploadfile;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.UploadfileBusiness;

public class UploadfileBusinessImpl implements UploadfileBusiness {
	
	private uploadfileDAO uploadfileDAO;

	public uploadfileDAO getUploadfileDAO() {
		return uploadfileDAO;
	}

	public void setUploadfileDAO(uploadfileDAO uploadfileDAO) {
		this.uploadfileDAO = uploadfileDAO;
	}

	@Override
	public void insert_uploadfile(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          uploadfileDAO.insert_uploadfile(entity);
        }
	}

	@Override
	public void update_uploadfile(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UPDATE_ID")==null){
			entity.put("UPDATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    uploadfileDAO.update_uploadfile(entity);
		}

	}

	@Override
	public void setnull_binary_data(List<String> list) throws BusinessException {
		uploadfileDAO.setnull_binary_data(list);
		
	}
	
	@Override
	public void delete_uploadfile(List<String> list) throws BusinessException {
		uploadfileDAO.delete_uploadfile(list);
		
	}
	
	@Override
	public void resume_uploadfile(List<String> list) throws BusinessException {
		uploadfileDAO.resume_uploadfile(list);
		
	}
	
	@Override
	public void delete_true_uploadfile(List<String> list) throws BusinessException {
		uploadfileDAO.delete_true_uploadfile(list);
		
	}
	
	@Override
	public Page<Map<String, Object>> list_uploadnofile(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = uploadfileDAO.list_uploadnofile(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_uploadfile(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_uploadnofile(Map<String, Object> query) throws BusinessException {
		return uploadfileDAO.list_uploadnofile(query);
	}

	@Override
	public Page<Map<String, Object>> list_uploadfile(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = uploadfileDAO.list_uploadfile(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_uploadfile(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_uploadfile(Map<String, Object> query) throws BusinessException {
		return uploadfileDAO.list_uploadfile(query);
	}

	@Override
	public int listCount_uploadfile(Map<String, Object> query) throws BusinessException {
		return uploadfileDAO.listCount_uploadfile(query);
	}
	
	 /**---------------供其它模块接口使用-------------------**/
	
	
	@Override
	public Page<Map<String, Object>> list_uploadnofile_webservices(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = uploadfileDAO.list_uploadnofile_webservices(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_uploadfile(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_uploadnofile_webservices(Map<String, Object> query) throws BusinessException {
		return uploadfileDAO.list_uploadnofile_webservices(query);
	}

	@Override
	public void delete_uploadfile_common(Map<String, Object> query) throws BusinessException {
		uploadfileDAO.delete_uploadfile_common(query);
		
	}
	
	@Override
	public void resume_uploadfile_common(Map<String, Object> query) throws BusinessException {
		uploadfileDAO.resume_uploadfile_common(query);
		
	}
	
	@Override
	public void delete_true_uploadfile_common(Map<String, Object> query) throws BusinessException {
		uploadfileDAO.delete_true_uploadfile_common(query);
		
	}
}
