package com.jw.app.business.user;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Java_tool;
import com.gaowj.business.util.Page;
import com.gaowj.standard.utils.CacheKit;
import com.jw.app.business.UserBusiness;

public class UserBusinessImpl implements UserBusiness {
	
	private UserDAO userDAO;

	public UserDAO getUserDAO() {
		return userDAO;
	}

	public void setUserDAO(UserDAO userDAO) {
		this.userDAO = userDAO;
	}

	@Override
	public void insert_user_ext(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("USER_ID")==null){
			entity.put("USER_ID", java.util.UUID.randomUUID().toString());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          userDAO.insert_user_ext(entity);
        }
		//
		

	}

	@Override
	public void update_user_ext(Map<String, Object> entity)
			throws BusinessException {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("USER_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    userDAO.update_user_ext(entity);
		}
		//

	}

	@Override
	public void delete_user_ext(List<String> list)
			throws BusinessException {
		List<Map<String, Object>> list_delete_user_ext = userDAO.list_delete_user_ext(list);
		userDAO.delete_user_ext(list);
		for(Map<String, Object> mfile : list_delete_user_ext){
			if(mfile.get("FORUM_AVATAR")!=null){
				String delFileName = (String) mfile.get("FORUM_AVATAR");
				File delFile = new File(delFileName);
				if(delFile.exists()){
					System.out.println("头像文件:"+delFileName+" 存在!");
					if(delFile.delete()){
						System.out.println("头像文件:"+delFileName+" 删除成功!");
					}else{
						System.out.println("头像文件:"+delFileName+" 删除失败!");
					}
				}else{
					System.out.println("头像文件:"+delFileName+" 不存在!");
				}
			}
		}
		
	}
	
	@Override
	public void insert_user_account(Map<String, Object> entity)
			throws BusinessException {
		Java_tool jt = new Java_tool();
		if(entity.get("USER_ID")==null){
			entity.put("USER_ID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		if(entity.get("BEGIN_TIME")==null){
			entity.put("BEGIN_TIME", new Date());
		}
		if(entity.get("END_TIME")==null){
			entity.put("END_TIME", jt.String3date("2115-12-31 23:59:59"));
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          userDAO.insert_user_account(entity);
        }
		//
		

	}

	@Override
	public void update_user_account(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("USER_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    userDAO.update_user_account(entity);
		}
		//

	}
	
	@Override
	public void update_batch_user_unit(Map<String, Object> entity)
			throws BusinessException {
		userDAO.update_batch_user_unit(entity);
	}

	@Override
	public void delete_user_account(List<String> list)
			throws BusinessException {
		userDAO.delete_user_account(list);
	}
	
	@Override
	public void insert_user(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("USER_ID")==null){
			entity.put("USER_ID", java.util.UUID.randomUUID().toString());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          userDAO.insert_user(entity);
        }
		//
		

	}

	@Override
	public void update_user(Map<String, Object> entity)
			throws BusinessException {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("USER_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    userDAO.update_user(entity);
		}
		//

	}

	@Override
	public void delete_user(List<String> list)
			throws BusinessException {
		userDAO.delete_user(list);
	}
	
	@Override
	public List<Map<String, Object>> list_name_user(List<String> list)
			throws BusinessException {
		return userDAO.list_name_user(list);
	}

	@Override
	public Page<Map<String, Object>> list_user(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = userDAO.list_user(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = userDAO.listCount_user(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_user(Map<String, Object> query)
			throws BusinessException {
		return userDAO.list_user(query);
	}

	@Override
	public int listCount_user(Map<String, Object> query)
			throws BusinessException {
		return userDAO.listCount_user(query);
	}
	@Override
	public List<Map<String, Object>> listUserInfo(Map<String, Object> query)
			throws BusinessException {
		// TODO Auto-generated method stub
		return userDAO.listUserInfo(query);
	}
	@Override
	public int list_max_order(Map<String, Object> query)
			throws BusinessException {
		return userDAO.list_max_order(query);
	}
	
	@Override
	public List<Map<String, Object>> list_uuid_order(Map<String, Object> query)
			throws BusinessException {
		return userDAO.list_uuid_order(query);
	}
	
	@Override
	public List<Map<String, Object>> list_usertree(Map<String, Object> query)
			throws BusinessException {
		return userDAO.list_usertree(query);
	}

	@Override
	public int listCount_usertree(Map<String, Object> query)
			throws BusinessException {
		return userDAO.listCount_usertree(query);
	}
	
	@Override
	public List<Map<String,Object>> list_user_ldap() throws BusinessException{
		return userDAO.list_user_ldap();
	}

	@Override
	public String list_user_uuid(String query) throws BusinessException {
		// TODO Auto-generated method stub
		return userDAO.list_user_uuid(query);
	}
	
	@Override
	public Map<String, Object> list_user_ldap_single(String query) throws BusinessException{
		return userDAO.list_user_ldap_single(query);
	}
	
	@Override
	public int listSsoUser(Map<String, Object> query)throws BusinessException{
		return userDAO.listSsoUser(query);	
	}
	
	@Override
	public List<Map<String, Object>> listUserInfo_userId(Map<String, Object> query)throws BusinessException{
		return userDAO.listUserInfo_userId(query);
	}
	
	@Override
	public List<Map<String, Object>> listAllUser(Map<String, Object> query) throws BusinessException{
		return userDAO.listAllUser(query);
	}
	
	@Override
	public List<Map<String, Object>> listGroupUser(Map<String, Object> query) throws BusinessException{
		return userDAO.listGroupUser(query);
	}
	
	@Override
	public int listMoblieCount(Map<String, Object> query) throws BusinessException{
		return userDAO.listMoblieCount(query);
	}
	
	@Override
	public Map<String, Object> listMobileUser (Map<String, Object> query) throws BusinessException{
		return userDAO.listMobileUser(query);
	}
	
	@Override
	public List<Map<String, Object>> listUserReceive(String query) throws BusinessException{
		return userDAO.listUserReceive(query);
	}
	
	@Override
	public Map<String, Object> listIdNumberUser (Map<String, Object> query) throws BusinessException{
		return userDAO.listIdNumberUser(query);
	}
	
	@Override
	public List<Map<String, Object>> listUserPush(Map<String, Object> query) throws BusinessException{
		return userDAO.listUserPush(query);
	}
	/*@Override
	public List<Map<String, Object>> listIdPassWord() throws BusinessException{
		return userDAO.listIdPassWord();
	}
	
	@Override
    public List<Map<String, Object>> list_tables_user_cache(Map<String, Object> query)throws BusinessException {
        // 获取列表
    	String keyName = (String) query.get("tableName");
    	List<Map<String, Object>> list = CacheKit.get("ehcache11", "user_"+keyName.toUpperCase());
    	if(list == null){
    		list  = userDAO.list_user(query);
    		CacheKit.put("ehcache11", "user_"+keyName.toUpperCase(),list);
    	}
        return list;
    }
	
	@Override
	public void updateCache(Map<String, Object> query)throws BusinessException {
			     	String keyName = (String) query.get("tableName");
			     	List<Map<String, Object>> list = CacheKit.get("ehcache11", "user_"+keyName.toUpperCase());
			     	if(list == null){
			     		list  = userDAO.listIdPassWord();
			     		CacheKit.put("ehcache11", "user_"+keyName.toUpperCase(), list);
			     	}else{
			     		list  = userDAO.listIdPassWord();
			     		CacheKit.update("ehcache11", "user_"+keyName.toUpperCase(),list);
			     	}
	 }*/
}
