package com.jw.app.business.user2user;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gaowj.business.exception.BusinessException;
import com.jw.app.business.User2UserBusiness;

public class User2UserBusinessImpl implements User2UserBusiness {
	
	private User2UserDAO user2UserDAO;

	public User2UserDAO getUser2UserDAO() {
		return user2UserDAO;
	}
	public void setUser2UserDAO(User2UserDAO user2UserDAO){
		this.user2UserDAO = user2UserDAO;
	}
    
    /**
	 * 分级管理-查询
	 */
	
    public List<Map<String,Object>> listUser2User(Map<String, Object> query)throws BusinessException{
    	return user2UserDAO.listUser2User(query);
    }
    
    @Override
	public int listUser2UserCount(Map<String, Object> query)
			throws BusinessException {
		return user2UserDAO.listUser2UserCount(query);
	}
    /**
     * 分级管理-增加
     */
    public void insertUser2User(Map<String,Object> entity)throws BusinessException{
    	if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("SETTING")==null){
			entity.put("SETTING", "0");
		}
		if(entity.get("TYPE")==null){
			entity.put("TYPE", "1");
		}
		if(entity.get("PARENT_ID")==null){
			entity.put("PARENT_ID", "0");
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
    	user2UserDAO.insertUser2User(entity);
    }
    
    @Override
	public void updateUser2User(Map<String, Object> entity)
			throws BusinessException {
    	if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
    	  user2UserDAO.updateUser2User(entity);
	}

    /**
     * 分级管理-删除
     */
    @Override
	public void delete_User2User(List<String> list) throws BusinessException {
    	user2UserDAO.delete_User2User(list);
    	for(String uuid:list){//删除相应下级管理人员
    		Map<String,Object> user = new HashMap<String,Object>();
    		user.put("PARENT_ID", uuid);
    		user2UserDAO.deleteUser2User(user);
    	}
    }
    
    public void deleteUser2User(Map<String,Object> entity)throws BusinessException {
    	user2UserDAO.deleteUser2User(entity);
    }
}
