package com.jw.app.business.usertest;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Java_tool;
import com.gaowj.business.util.Page;
import com.jw.app.business.UserTestBusiness;
import com.jw.app.business.user.UserDAO;

public class UserTestBusinessImpl implements UserTestBusiness{
	private UserTestDAO userTestDAO;
	
	public UserTestDAO getUserTestDAO() {
		return userTestDAO;
	}

	public void setUserTestDAO(UserTestDAO userTestDAO) {
		this.userTestDAO = userTestDAO;
	}
	
		//测试查询实现
	
	@Override
	public Page<Map<String, Object>> list_usertest(int pageNo, int pageSize,
			Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = userTestDAO.list_usertest(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = userTestDAO.listCount_usertest(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}
	
	@Override
	public int listCount_usertest(Map<String, Object> query)
			throws BusinessException {
		return (userTestDAO).listCount_usertest(query);
	}
    
	@Override
	public List<Map<String, Object>> list_usertest(Map<String, Object> query)
			throws BusinessException {
		return userTestDAO.list_usertest(query);
	}
	
	@Override
	public String list_test_unit(String uuid)
			throws BusinessException {
		return userTestDAO.list_test_unit(uuid);
	}
	
	@Override
	public void insert_user(Map<String, Object> entity)
			throws BusinessException {
		if(entity.get("USER_ID")==null){
			entity.put("USER_ID", java.util.UUID.randomUUID().toString());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          userTestDAO.insert_user(entity);
        }
		//
		

	}

	@Override
	public void delete_user(List<String> list)
			throws BusinessException {
		userTestDAO.delete_user(list);
	}

	@Override
	public void update_user(Map<String, Object> entity)
			throws BusinessException {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("USER_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    userTestDAO.update_user(entity);
		}
		//

	}
	
	@Override
	public List<Map<String, Object>> selectAllUser ()
			throws BusinessException {
		return userTestDAO.selectAllUser();
	}
	
	/*@Override
	public List<Map<String, Object>> selectUnitTest ()
			throws BusinessException {
		return userTestDAO.selectUnitTest();
	}*/
}
