package com.jw.app.column.action;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import net.sf.jasperreports.engine.util.Java14BigDecimalHandler;
import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.UnitBusiness;
import com.jw.app.business.ColumnBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;

public class actAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = 303797180576461148L;
	
	private JSONObject jsonObject = new JSONObject();
	
	private File leftFile;
	
	private File appFile;	
	
	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public File getLeftFile() {
		return leftFile;
	}

	public void setLeftFile(File leftFile) {
		this.leftFile = leftFile;
	}

	public File getAppFile() {
		return appFile;
	}

	public void setAppFile(File appFile) {
		this.appFile = appFile;
	}

	public String insertColumn() throws BusinessException{
		ColumnBusiness business = BusinessManager.getBusiness(ColumnBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		entity.remove("OPETYPE");
		jsonObject = new JSONObject();
		try{
			business.insert_column(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateColumn() throws BusinessException{
    	ColumnBusiness business = BusinessManager.getBusiness(ColumnBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		System.out.println("------entity"+entity);
		entity.remove("OPETYPE");
		try{
			business.update_column(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
   public String deleteColumn() throws BusinessException{
	    ColumnBusiness business = BusinessManager.getBusiness(ColumnBusiness.class);
		try{
			String deletekey  = RequestUtils.getString(request, "deletekey");
			List<String> ListKey = QueryParamUtil.StringToList(deletekey);
			Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
			business.delete_column(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

}
