package com.jw.app.column.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.ColumnBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.common.EasyuiJsonUtils;

public class dataAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = -7897314852467856687L;

	
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
    private int page = 1;// 当前第几页


	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}

	public String list() throws BusinessException{
		ColumnBusiness business = BusinessManager.getBusiness(ColumnBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
		query = QueryParamUtil.StringToDate(query);
		Page<Map<String, Object>> pageRows = business.list_column(pageNo, pageSize, query);
		setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		data.put("pageNo", pageNo);
		data.put("pageSize",pageSize );
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", pageRows.getCount());
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAll() throws BusinessException{
		ColumnBusiness business = BusinessManager.getBusiness(ColumnBusiness.class);
		try {
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		query = QueryParamUtil.StringToDate(query);
		List<Map<String, Object>> listData = business.list_column(query);
		int listDataCount = business.listCount_column(query);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(listData));
		data.put("pageNo", 1);
		data.put("pageSize",listDataCount );
		data.put("pageCount", listDataCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", listDataCount);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listColumnTree() throws BusinessException{
		ColumnBusiness business = BusinessManager.getBusiness(ColumnBusiness.class);
		try {
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		query = QueryParamUtil.StringToDate(query);
//		System.out.println("-------query"+query);
		List<Map<String, Object>> listData = business.list_column(query);
		int listDataCount = business.listCount_column(query);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(listData));
		data.put("pageNo", 1);
		data.put("pageSize",listDataCount );
		data.put("pageCount", listDataCount);
		data.put("rows", EasyuiJsonUtils.getTreeJsonData(QueryParamUtil.DateToString(listData)));
		data.put("total", listDataCount);
//		System.out.println("------data"+data);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

}
