package com.jw.app.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.User2UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class EasyuiJsonUtils {
	/**
	 * 将数据列表转化为easyui树的Json格式  buildJSON
	 * 
	 */
	
	private static List<Map<String,Object>> treelist;
	
	public static List<Map<String, Object>> getTreelist() {
		return treelist;
	}

	public static void setTreelist(List<Map<String, Object>> treelist) {
		EasyuiJsonUtils.treelist = treelist;
	}
	
	public static String getTreeGridJsonData(List<Map<String, Object>> listSelect) {

		StringBuffer buffer = new StringBuffer();

		treelist = listSelect;

		// 获取没有父级的类别
		List<Map<String, Object>> parents = findByCondition(null);

		buildJSONGrid(parents, buffer);

		String tmp = buffer.toString();

		return tmp;
	}
	
	private static void buildJSONGrid(List<Map<String,Object>> list,StringBuffer json) {

		json.append("[");
		if (list != null && list.size() > 0) {

			for (int i = 0; i < list.size(); i++) {

				Map<String,Object> m = list.get(i);

				json.append("{");
				
				for(Iterator<?> it = m.keySet().iterator(); it.hasNext();){
					String key = it.next().toString();
					json.append("\""+key+"\"");
					json.append(":");
					json.append("\"");
					json.append(m.get(key));
					json.append("\"");

					json.append(",");
				}

				List<Map<String,Object>> children = findByCondition((String)m.get("UUID"));

				if (children != null && children.size() > 0) {

//					json.append(",");

					json.append("\"children\"");
					json.append(":");

					buildJSONGrid(children, json);

				}

				json.append("}");

				if (i != list.size() - 1) {
					json.append(",");
				}

			}

		}
		json.append("]");

	}
	
	public static String getMyTreeJsonData(List<Map<String, Object>> listSelect) {

		StringBuffer buffer = new StringBuffer();

		treelist = listSelect;

		// 获取没有父级的类别
		List<Map<String, Object>> parents = findByCondition(null);
		
		buildMyHeadJSON(parents, buffer);
		
		String tmp = buffer.toString();

		return tmp;
	}
	
	private static void buildMyHeadJSON(List<Map<String,Object>> list,StringBuffer json) {
		json.append("[");
		if (list != null && list.size() > 0) {

			for (int i = 0; i < list.size(); i++) {

				Map<String,Object> m = list.get(i);

				json.append("{");

				json.append("\"id\"");
				json.append(":");
				json.append("\"");
				json.append(m.get("UUID"));
				json.append("\"");

				json.append(",");

				json.append("\"text\"");
				json.append(":");
				json.append("\"");
				json.append(m.get("NAME"));
				json.append("\"");

				List<Map<String,Object>> children = findByCondition((String)m.get("UUID"));

				if (children != null && children.size() > 0) {

					json.append(",");

					json.append("\"children\"");
					json.append(":");

					// 判断当前登陆人员为单位管理员并获取管到的单位
					List<Map<String, Object>> myparents = findByCondition();

					buildMyJSON(myparents, json);

				}
				json.append("}");

				if (i != list.size() - 1) {
					json.append(",");
				}

			}

		}

		json.append("]");
	}
	
	private static void buildMyJSON(List<Map<String,Object>> list,StringBuffer json) {
		json.append("[");
		if (list != null && list.size() > 0) {

			for (int i = 0; i < list.size(); i++) {

				Map<String,Object> m = list.get(i);

				json.append("{");

				json.append("\"id\"");
				json.append(":");
				json.append("\"");
				json.append(m.get("UUID"));
				json.append("\"");

				json.append(",");

				json.append("\"text\"");
				json.append(":");
				json.append("\"");
				json.append(m.get("NAME"));
				json.append("\"");

				List<Map<String,Object>> children = findByCondition((String)m.get("UUID"));

				if (children != null && children.size() > 0) {

					json.append(",");

					json.append("\"children\"");
					json.append(":");

					buildJSON(children, json);

				}

				json.append("}");

				if (i != list.size() - 1) {
					json.append(",");
				}

			}

		}
		json.append("]");

	}

	public static String getTreeJsonData(List<Map<String, Object>> listSelect) {

		StringBuffer buffer = new StringBuffer();

		treelist = listSelect;

		// 获取没有父级的类别
		List<Map<String, Object>> parents = findByCondition(null);

		buildJSON(parents, buffer);

		String tmp = buffer.toString();

		return tmp;
	}
	
	private static void buildJSON(List<Map<String,Object>> list,StringBuffer json) {
		json.append("[");
		if (list != null && list.size() > 0) {

			for (int i = 0; i < list.size(); i++) {

				Map<String,Object> m = list.get(i);

				json.append("{");

				json.append("\"id\"");
				json.append(":");
				json.append("\"");
				json.append(m.get("UUID"));
				json.append("\"");

				json.append(",");

				json.append("\"text\"");
				json.append(":");
				json.append("\"");
				json.append(m.get("NAME"));
				json.append("\"");

				List<Map<String,Object>> children = findByCondition((String)m.get("UUID"));

				if (children != null && children.size() > 0) {

					json.append(",");

					json.append("\"children\"");
					json.append(":");

					buildJSON(children, json);

				}

				json.append("}");

				if (i != list.size() - 1) {
					json.append(",");
				}

			}

		}
		json.append("]");

	}

	/**
	 * 通过条件筛选
	 * 
	 * @param parent
	 *            父类别主键
	 * @return
	 */
	private static List<Map<String,Object>> findByCondition(String parent) {
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();

		for (Map<String,Object> treeMap : treelist) {
			if(StringUtils.isEmpty(parent)){
				if(StringUtils.isEmpty((String)treeMap.get("PARENT_ID")) || ((String)treeMap.get("PARENT_ID")).equals("0")){
					result.add(treeMap);
				}
			}else if (parent.equals((String)treeMap.get("PARENT_ID")) ) {
				result.add(treeMap);
			}
		}
		return result;
	}
	
	private static List<Map<String,Object>> findByCondition() {
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		Map<String,Object> query = new HashMap<String,Object>();
		query.put("USERID", SessionUtil.getCode());
		User2UserBusiness business = BusinessManager.getBusiness(User2UserBusiness.class);
		List<Map<String,Object>> myresult = business.listUser2User(query);
		for (Map<String,Object> mytreeMap : myresult) {
		   for (Map<String,Object> treeMap : treelist) {
			  if(mytreeMap.get("UNIT_UUID")!=null && treeMap.get("UUID")!=null && 
					  StringUtils.equals((String)mytreeMap.get("UNIT_UUID"), (String)treeMap.get("UUID"))){
				  result.add(treeMap);
				  break;
			  }
		   }
		}
		return result;
	}
	
	/**
	 * 获取当前节点下所有的子节点
	 * 
	 */
	public static List<String> getParentsData(List<Map<String, Object>> listSelect,String cuurParent) {

		StringBuffer buffer = new StringBuffer();

		treelist = listSelect;

		// 获取没有父级的类别
		List<Map<String, Object>> parents = findByCondition(cuurParent);

		buildString(parents, buffer);

		String tmp = buffer.toString();

		tmp = tmp + cuurParent;
		
		List<String> list = QueryParamUtil.StringToList(tmp);
		
		return list;
	}
	
	private static void buildString(List<Map<String,Object>> list,StringBuffer json) {

		if (list != null && list.size() > 0) {

			for (int i = 0; i < list.size(); i++) {

				Map<String,Object> m = list.get(i);
				json.append(m.get("UUID"));
				json.append(",");

				List<Map<String,Object>> children = findByCondition((String)m.get("UUID"));

				if (children != null && children.size() > 0) {
					buildString(children, json);
				}

//				if (i != list.size() - 1) {
//					json.append(",");
//				}

			}

		}

	}

}
