package com.jw.app.common;

import java.util.HashMap;
import java.util.Map;

public class QueryFilter {
	private String filter;
	private Map<String, Parameter> params = new HashMap<String, Parameter>();

	public void setFilter(String filter) {
		this.filter = filter;
	}

	public String getFilString() {
		return this.filter;
	}

	public Parameter getParameter(String name) {
		return this.params.get(name);
	}

	public Map<String, Parameter> getAllParameter() {
		return this.params;
	}

	public void addParameter(String name, Parameter p) {
		this.params.put(name, p);
	}

	/**
	 * 
	 * <p>
	 * Discription:
	 * </p>
	 * 
	 * @param name
	 * @param type
	 * @param value
	 * @throws Exception
	 * @author: 
	 * @update:
	 */
	public void addParameter(String name, String type, Object value) {
		addParameter(name, type, value, null, null);
	}

	public void setParameters(Map<String, Parameter> params) {
		this.params = params;
	}

	/**
	 * 
	 * <p>
	 * Discription: 增加带有condition的查询条件设置
	 * </p>
	 * 
	 * @param name
	 * @param type
	 * @param value
	 * @param condition
	 * @throws Exception
	 * @author: 
	 * @update: 
	 */
	public void addParameter(String name, String type, Object value, String condition, String property) {
		Parameter p = new Parameter();
		p.setType(type);
		p.setValue(value);
		p.setCondition(condition);
		p.setProperty(property);
		addParameter(name, p);
	}
}
