package com.jw.app.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.User2UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class ZtreeJsonUtils {
	/**
	 * 查找分级管理员的树
	 * 
	 */
	
	private static List<Map<String,Object>> treelist;
	
	public static List<Map<String, Object>> getTreelist() {
		return treelist;
	}

	public static void setTreelist(List<Map<String, Object>> treelist) {
		ZtreeJsonUtils.treelist = treelist;
	}
	
	public static List<Map<String, Object>> getUserGridJsonData(List<Map<String, Object>> listSelect) {

		List<Map<String, Object>> myTreeList = new ArrayList<Map<String,Object>>();
		treelist = listSelect;
		// 获取没有父级的类别
		List<Map<String, Object>> parents = findByCondition(null);
		// 判断当前登陆人员为单位管理员并获取管到的单位
		List<Map<String, Object>> myparents = findByCondition();
		buildJSONGrid(myparents,myTreeList);
		return myTreeList;
	}
	
	public static List<Map<String, Object>> getTreeGridJsonData(List<Map<String, Object>> listSelect) {

		List<Map<String, Object>> myTreeList = new ArrayList<Map<String,Object>>();
		treelist = listSelect;
		// 获取没有父级的类别
		List<Map<String, Object>> parents = findByCondition(null);
		// 判断当前登陆人员为单位管理员并获取管到的单位
		List<Map<String, Object>> myparents = findByCondition();
		buildJSONGrid(myparents,myTreeList);
		if(myTreeList.size()>=0 && (parents.size()>0 && parents.get(0).get("UUID").toString().equals("A")==false)){
			myTreeList.addAll(parents);
		}
		return myTreeList;
	}
	
	private static void buildJSONGrid(List<Map<String,Object>> list,List<Map<String,Object>> myTreeList) {
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				Map<String,Object> m = list.get(i);
				myTreeList.add(m);
				List<Map<String,Object>> children = findByCondition((String)m.get("UUID"));
				if (children != null && children.size() > 0) {
					buildJSONGrid(children,myTreeList);
				}
			}
		}
	}

	/**
	 * 通过条件筛选
	 * 
	 * @param parent
	 *            父类别主键
	 * @return
	 */
	private static List<Map<String,Object>> findByCondition(String parent) {
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();

		for (Map<String,Object> treeMap : treelist) {
			if(StringUtils.isEmpty(parent)){
				if(StringUtils.isEmpty((String)treeMap.get("PARENT_ID")) || ((String)treeMap.get("PARENT_ID")).equals("0")){
					result.add(treeMap);
				}
			}else if (parent.equals((String)treeMap.get("PARENT_ID")) ) {
				result.add(treeMap);
			}
		}
		return result;
	}
	
	private static List<Map<String,Object>> findByCondition() {
		List<Map<String,Object>> result = new ArrayList<Map<String,Object>>();
		Map<String,Object> query = new HashMap<String,Object>();
		query.put("USERID", SessionUtil.getCode());
		User2UserBusiness business = BusinessManager.getBusiness(User2UserBusiness.class);
		List<Map<String,Object>> myresult = business.listUser2User(query);
		for (Map<String,Object> mytreeMap : myresult) {
		   for (Map<String,Object> treeMap : treelist) {
			  if(mytreeMap.get("UNIT_UUID")!=null && treeMap.get("UUID")!=null && 
					  StringUtils.equals((String)mytreeMap.get("UNIT_UUID"), (String)treeMap.get("UUID"))){
				  result.add(treeMap);
				  break;
			  }
		   }
		}
		return result;
	}

}
