package com.jw.app.common.action;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.SystemOpeBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;

public class actAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6517074422672442333L;
	
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
    public String insertSysRole() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		String flag = "";
		try{
			entity = QueryParamUtil.StringToDate(entity);
			// 恢复删除的数据
			if (entity.get("FLAG") != null
					&& entity.get("FLAG").toString().equals("1")) {
				entity.put("DELETE_FLAG", "0");
				flag = entity.get("FLAG").toString();
				entity.remove("FLAG");
				business.update_depart(entity);
			}else {
				Map<String, Object> query = new HashMap<String, Object>();
				query.put("DPT_NO", entity.get("DPT_NO").toString());
				int count = business.listDepartmentServiceInfoCount(query);
				// 编号存在
				if (count > 0) {
					query.put("DELETE_FLAG", "1");
					count=0;
					count = business.listDepartmentServiceInfoCount(query);
					// 该编号已被删除
					if (count > 0) {
						jsonObject.putAll(Status
								.getStatus(Status.INSERT_ERR_DELETE));
						return "json";
					}
					else {
						jsonObject.putAll(Status.getStatus(Status.INSERT_ERR_DEPID));
						return "json";
					}
				}else {
					business.insert_depart(entity);
				}
			}
			
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateSysRole() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_depart(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteSysRole() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String []deptno=entity.get("DPT_NO").toString().split("\\,");
			for (String string : deptno) {
				Map<String , Object>map=new HashMap<String, Object>();
				map.put("DPT_NO", string);
				business.delete_depart(map);
			}
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String resetUserPass() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
    	Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			if(entity.get("USER_PWD") != null){
				entity.put("EMPASS", Encipher.EncodePasswd((String)entity.get("USER_PWD")));
				entity.remove("USER_PWD");
			}
			if(entity.get("USER_PWD_RESET") != null && entity.get("USER_PWD_RESET").toString().equals("1")){
				entity.put("EMPASS", Encipher.EncodePasswd("0000"));
				entity.remove("USER_PWD_RESET");
			}
			business.update_user(entity);
		    jsonObject.putAll(Status.getStatus(Status.PASS_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.PASS_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    private void setUser(Map<String,Object> entity)throws BusinessException{
    	if(entity.get("CODE")==null){
    		entity.put("CODE", java.util.UUID.randomUUID().toString());
    	}
    	if(entity.get("EMPASS")==null){
    		entity.put("EMPASS", Encipher.EncodePasswd("0000"));
    	}
    	if(entity.get("EMSEX")==null){
    		entity.put("EMSEX", "M");
    	}
    	if(entity.get("EMAIL")==null){
    		entity.put("EMAIL", "test@test.com");
    	}
    	if(entity.get("REGDATE")==null){
    		entity.put("REGDATE",new Date());
    	}
    	if(entity.get("STATE")==null){
    		entity.put("STATE","0");
    	}
    	if(entity.get("TYPE")==null){
    		entity.put("TYPE","O");
    	}
    	if(entity.get("O_ENABLE")==null){
    		entity.put("O_ENABLE","N");
    	}
    	if(entity.get("W_ENABLE")==null){
    		entity.put("W_ENABLE","N");
    	}
    }
    
    public String insertSysUser() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			setUser(entity);
		    business.insert_user(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateSysUser() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_user(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteSysUser() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String []deptno=entity.get("CODE").toString().split("\\,");
			for (String string : deptno) {
				Map<String , Object>map=new HashMap<String, Object>();
				map.put("CODE", string);
				business.delete_user(map);
			}
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String insertSysGroup() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			
		    business.insert_group(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateSysGroup() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_group(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteSysGroup() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_group((String)entity.get("G_ID"));
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
}
