package com.jw.app.common.action;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.SystemOpeBusiness;
import com.jw.app.business.UnitBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class dataAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = -7897314852467856687L;

	
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
    private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}

	public String listSysRole() throws BusinessException{
		SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
		query = QueryParamUtil.StringToDate(query);
		Page<Map<String, Object>> pageRows = business.listDepartmentSericeInfo(pageNo,pageSize,query);
		setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		data.put("pageNo", pageNo);
		data.put("pageSize",pageSize );
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", pageRows.getCount());
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listSysRoleAll() throws BusinessException{
		SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		try {
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		query = QueryParamUtil.StringToDate(query);
		List<Map<String, Object>> listData = business.listDepartmentSericeInfo(query);
		int listDataCount = business.listDepartmentServiceInfoCount(query);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(listData));
		data.put("pageNo", 1);
		data.put("pageSize",listDataCount );
		data.put("pageCount", listDataCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", listDataCount);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listSysUser() throws BusinessException{
		SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
		query = QueryParamUtil.StringToDate(query);
		Page<Map<String, Object>> pageRows = business.listLoginServiceUserInfo(pageNo,pageSize,query);
		setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		data.put("pageNo", pageNo);
		data.put("pageSize",pageSize );
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", pageRows.getCount());
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listSysUserAll() throws BusinessException{
		SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		try {
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		query = QueryParamUtil.StringToDate(query);
		List<Map<String, Object>> listData = business.listLoginServiceUserInfo(query);
		int listDataCount = business.listLoginServiceUserInfoCount(query);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(listData));
		data.put("pageNo", 1);
		data.put("pageSize",listDataCount );
		data.put("pageCount", listDataCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", listDataCount);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listSysGroup() throws BusinessException{
		SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
		query = QueryParamUtil.StringToDate(query);
		Page<Map<String, Object>> pageRows = business.listGroupAll(pageNo,pageSize,query);
		setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		data.put("pageNo", pageNo);
		data.put("pageSize",pageSize );
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", pageRows.getCount());
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listSysGroupAll() throws BusinessException{
		SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		try {
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		query = QueryParamUtil.StringToDate(query);
		List<Map<String, Object>> listData = business.listGroupAll(query);
		int listDataCount = listData.size();
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(listData));
		data.put("pageNo", 1);
		data.put("pageSize",listDataCount );
		data.put("pageCount", listDataCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", listDataCount);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listSysLogInfo() throws BusinessException{
		SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
		query = QueryParamUtil.StringToDate(query);
		Page<Map<String, Object>> pageRows = business.listLogInfo(pageNo,pageSize,query);
		setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		data.put("pageNo", pageNo);
		data.put("pageSize",pageSize );
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", pageRows.getCount());
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listSysLog4jInfo() throws BusinessException{
		SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
		query = QueryParamUtil.StringToDate(query);
		Page<Map<String, Object>> pageRows = business.listLog4jInfo(pageNo,pageSize,query);
		for(Map<String, Object> m:pageRows.getItems()){
			m.remove("LOGTHROWABLE");
			m.remove("LOGNDC");
		}
		setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		data.put("pageNo", pageNo);
		data.put("pageSize",pageSize );
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", pageRows.getCount());
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listSysLogBusiness() throws BusinessException{
		SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
		query = QueryParamUtil.StringToDate(query);
		Page<Map<String, Object>> pageRows = business.listLogBusiness(pageNo,pageSize,query);
//		for(Map<String, Object> m:pageRows.getItems()){
//			m.remove("OPE");
//		}
		QueryParamUtil.ClobToString(pageRows.getItems());
		setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		data.put("pageNo", pageNo);
		data.put("pageSize",pageSize );
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", pageRows.getCount());
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	public String logBusinessDetail() throws BusinessException {
		try {
			Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
			if(query.get("UUID")!=	null){
				// 找出相应单位的详情
				SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
				List<Map<String, Object>> listData = business.listLogBusiness(query);
				listData=QueryParamUtil.DateToString(listData);
				jsonObject = new JSONObject();
				if(listData!=null&&listData.size()>0)
					jsonObject.putAll(listData.get(0));
			}
			else{
				jsonObject = new JSONObject();
				jsonObject.put("errCode", 1);
			}
		} catch (Exception e) {
			// TODO: handle exception
		}
		return "success";
	}
}
