package com.jw.app.ldap.action;

import java.io.File;
import java.security.DigestException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.util.Factory;
import com.gaowj.util.Ldap;
import com.gaowj.util.Sha1;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;


import net.sf.json.JSONObject;

public class actAction extends BasicAction {

	/**
	 * ldap管理页面弃用
	 */
	private static final long serialVersionUID = -7183235184620464581L;
	private JSONObject jsonObject = new JSONObject();

	private File leftFile;

	private File appFile;

	private String loginuserCode = SessionUtil.getCode();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public File getLeftFile() {
		return leftFile;
	}

	public void setLeftFile(File leftFile) {
		this.leftFile = leftFile;
	}

	public File getAppFile() {
		return appFile;
	}

	public void setAppFile(File appFile) {
		this.appFile = appFile;
	}
	//删除
	public String deleteUser() throws BusinessException {
		Ldap ldap = Factory.createInstance();
		try {
			ldap.connect();
			jsonObject = new JSONObject();
			String deletekey = RequestUtils.getString(request, "deletekey");
			System.out.println("rdn--------"+deletekey);
			String searchFilter = "objectClass=*";
			String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
			if(!deletekey.matches("^uid.*")){
				searchBase = deletekey + "," + searchBase;
				List<Map<String, Object>> list = ldap.searchAll(searchFilter, searchBase, null);
				if(list.size() == 1){
					String rdn = deletekey + "," + PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
					ldap.delete(rdn);
					jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
				}else{
					jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
				}
			}else{
				String rdn = deletekey + "," + PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				ldap.delete(rdn);
				jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
			}
		} catch (NamingException e) {
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		return "json";
	}
	
	//添加
	public String insertUser() throws BusinessException {
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request, "USER0_");
		//Map<String, Object> query_unit = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		String rdnunit = (String) entity_user.get("rdn");
		System.out.println("---------------rdnunit" + entity_user);
		//System.out.println("---------------user" + entity_user);
		Ldap ldap = Factory.createInstance();
		try {
			ldap.connect();
			jsonObject = new JSONObject();
			if(rdnunit == null){
				jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			}else{
				String[] split = rdnunit.split(",");
				String st = split[0].substring(split[0].indexOf('=') + 1);
			    System.out.println("-------------st"+st);
				String objectClass = "inetOrgPerson";
	            Attribute attr = new BasicAttribute("objectClass");
	            attr.add(objectClass);
				Attributes attrs = new BasicAttributes();
				String searchFilter = "ou=" + st;
				String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				String uuid = UUID.randomUUID().toString();
				List<Map<String, Object>> list = ldap.searchAll(searchFilter, searchBase, null);
				if(list.size() == 1){
					String rdn = "uid=" + uuid + "," + list.get(0).get("rdn") + "," + searchBase;
					attrs.put("uid", uuid);
					attrs.put("sn", uuid);
					attrs.put("cn", uuid);
					attrs.put("employeeNumber", entity_user.get("employeeNumber"));
					String pass = Sha1.SHA1((String) entity_user.get("userPassword"));
					attrs.put("userPassword", pass);
					attrs.put("ou", list.get(0).get("description"));
					attrs.put("description", entity_user.get("description"));
					attrs.put("idcard", entity_user.get("idcard"));
					attrs.put("st", st);
					attrs.put("mobile", entity_user.get("mobile"));
					attrs.put("mail", entity_user.get("mail"));
					attrs.put("telephoneNumber", entity_user.get("telephoneNumber"));
					if(entity_user.get("usersex").equals("1")){
						attrs.put("usersex", "男");
					}else if(entity_user.get("usersex").equals("2")){
						attrs.put("usersex", "女");
					}
					//attrs.put("usersex", entity_user.get("usersex"));
					attrs.put(attr);
					ldap.add(rdn, attrs);
					jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
				}else{
					jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
				}

			}
			
		} catch (NamingException e) {
			e.printStackTrace();
		} catch (DigestException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		return "json";
	}
	
	//添加部门
	public String insertUnit() throws BusinessException {
		//Map<String, Object> query_unit = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		Map<String, Object> entity_unit = RequestUtils.getUpdateFieldMap(request, "USER0_");
		String rdnunit = (String) entity_unit.get("rdn");
		//System.out.println("---------rdn" + query_unit);
		System.out.println("---------unit" + rdnunit);
		String uuid = UUID.randomUUID().toString();
		Ldap ldap = Factory.createInstance();
		try {
			ldap.connect();
			jsonObject = new JSONObject();
			if(rdnunit != null){
				String[] split = rdnunit.split(",");
				String st = split[0].substring(split[0].indexOf('=') + 1);
				String rdn = "ou=" + uuid +"," + rdnunit + "," + PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				//String rdn = "ou=" + entity_unit.get("UNIT_NAME") +"("+ entity_unit.get("UNIT_ID") +")"+"," + rdnunit + "," + "o=宁海县(0),dc=sky,dc=org";
				String objectClass = "organizationalUnit";
	            Attribute attr = new BasicAttribute("objectClass");
	            attr.add(objectClass);
				Attributes attrs = new BasicAttributes();
				//attrs.put("ou", entity_unit.get("UNIT_ID"));
				attrs.put("description", entity_unit.get("description"));
				attrs.put("street", entity_unit.get("street"));
				attrs.put("st", st);
				attrs.put(attr);
				ldap.add(rdn, attrs);
				System.out.println(attrs);
				jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
			}else{
				String rdn = "ou=" + uuid + "," + PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				String objectClass = "organizationalUnit";
	            Attribute attr = new BasicAttribute("objectClass");
	            attr.add(objectClass);
				Attributes attrs = new BasicAttributes();
				attrs.put("street", entity_unit.get("street"));
				attrs.put("description", entity_unit.get("description"));
				attrs.put("st", "A");
				attrs.put(attr);
				ldap.add(rdn, attrs);
				jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
			}
		} catch (NamingException e) {
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		return "json";
	}
	
	//修改人员
	public String updateUser() throws BusinessException {
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request, "USER0_");
		System.out.println("--------------uid" + entity_user.get("rdn"));
		Ldap ldap = Factory.createInstance();
		try {
			ldap.connect();
			jsonObject = new JSONObject();
			String rdnuser = (String) entity_user.get("rdn");
			String split[] = rdnuser.split(",");
			String searchFilter = split[0];
			String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
			List<Map<String, Object>> list = ldap.searchAll(searchFilter, searchBase, null);
			if(list.size() == 1){
				String rdn = list.get(0).get("rdn") + "," + searchBase;
				Map<String, Object> map = new HashMap<String, Object>();
				map.put("employeeNumber", entity_user.get("employeeNumber"));
				String pass = Sha1.SHA1((String) entity_user.get("userPassword"));
				map.put("userPassword", pass);
				map.put("description", entity_user.get("description"));
				map.put("idcard", entity_user.get("idcard"));
				//String searchFilterunit = "description=" + entity_user.get("UNIT_NAME");
				//String searchBaseunit = "o=宁海县(0),dc=sky,dc=org";
				//List<Map<String, Object>> listunit = ldap.searchAll(searchFilterunit, searchBase, null);
				map.put("mobile", entity_user.get("mobile"));
				map.put("mail", entity_user.get("mail"));
				map.put("telephoneNumber", entity_user.get("telephoneNumber"));
				if(entity_user.get("usersex").equals("1")){
					map.put("usersex", "男");
				}else if(entity_user.get("usersex").equals("2")){
					map.put("usersex", "女");
				}
				//map.put("usersex", entity_user.get("usersex"));
				for(Map.Entry<String, Object> entry : map.entrySet()){
					ldap.update(rdn, entry.getKey(), entry.getValue());
				}
				jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
			}else{
				jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			}
		} catch (NamingException e) {
			e.printStackTrace();
		} catch (DigestException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		return "json";
	}
	
	//修改部门
	public String updateUnit() throws BusinessException{
		Map<String, Object> entity_unit = RequestUtils.getUpdateFieldMap(request, "USER0_");
		Ldap ldap = Factory.createInstance();
		try {
			ldap.connect();
			jsonObject = new JSONObject();
			String rdn = (String) entity_unit.get("rdn");
			if(rdn != null){
				String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				String rdnfinal = rdn + "," + searchBase;
				Map<String, Object> map = new HashMap<String, Object>();
				map.put("description", entity_unit.get("description"));
				map.put("street", entity_unit.get("street"));
				for(Map.Entry<String, Object> entry : map.entrySet()){
					ldap.update(rdnfinal, entry.getKey(), entry.getValue());
				}
				String[] starr = entity_unit.get("rdn").toString().split(",");
				String st = starr[0].substring(3);
				String searchFilter = "st=" + st;
				List<Map<String, Object>> list = ldap.searchAll(searchFilter, searchBase, null);
				for(Map<String, Object> map1 : list){
					if(map1.get("rdn").toString().startsWith("uid")){
						
						String rdnupdate = map1.get("rdn") + "," + searchBase;
						ldap.update(rdnupdate, "ou", entity_unit.get("description"));
					}	
				}
				jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
			}else{
				String rdnfinal = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				Map<String, Object> map = new HashMap<String, Object>();
				map.put("description", entity_unit.get("description"));
				map.put("street", entity_unit.get("street"));
				for(Map.Entry<String, Object> entry : map.entrySet()){
					ldap.update(rdnfinal, entry.getKey(), entry.getValue());
				}
				jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
			}
		} catch (NamingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		return "json";
	}
}
