package com.jw.app.ldap.action;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.naming.NamingException;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.util.Factory;
import com.gaowj.util.Ldap;

import net.sf.json.JSONObject;


public class dataAction extends BasicAction {

	/**
	 * ldap查询相关
	 */
	private static final long serialVersionUID = 739418266795833218L;
	private JSONObject jsonObject = new JSONObject();
	SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}
	/**
	 * 目录树全部显示
	 */
	public String listAll() throws BusinessException {
		Ldap ldap = Factory.createInstance();
		try {
			ldap.connect();
			String searchFilter = "objectClass=*";
			String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
			List<Map<String, Object>> listData1 = ldap.searchAll(searchFilter, searchBase, null);
			List<Map<String, Object>> listData = new ArrayList<Map<String,Object>>();
			for(Map<String, Object> map : listData1){
				if(map.get("uid") == null && map.get("ou") == null){
					map.put("UUID", "1_"+map.get("o"));
					map.put("PARENT_ID", "1_0");
					map.put("NAME", map.get("description"));
					//map.put("AUTH", map.get("1"));
				}else if(map.get("uid") == null){
					map.put("UUID", "1_"+map.get("ou"));
					map.put("PARENT_ID", "1_"+map.get("st"));
					map.put("NAME", map.get("description"));
					//map.put("NAME", map.get("ou"));
				}else{
					map.put("UUID", "2_"+map.get("uid"));
					map.put("PARENT_ID", "1_"+map.get("st"));
					map.put("NAME", map.get("description"));
					//map.put("NAME", map.get("uid"));
				}
				listData.add(map);
			}
			int listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", listData);
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (NamingException e) {
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		
		return "json";
	}
	
	/**
	 * 右侧信息显示
	 */
	public String listMy() throws BusinessException {
		Ldap ldap = Factory.createInstance();
		try {
			ldap.connect();
			jsonObject = new JSONObject();
			String searchFilter = "objectClass=inetOrgPerson";
			String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
			List<Map<String, Object>> listData = ldap.searchAll(searchFilter, searchBase, null);
			int listDataCount = listData.size();
			int pageCount = (listDataCount - 1) / pageSize + 1 ;
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", listData);
			data.put("pageNo", 1);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			System.out.println(data);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (NamingException e) {
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		return "json";
	}
	
	//点击目录树节点，查询节点信息
	public String listInfo() throws BusinessException{
		Ldap ldap = Factory.createInstance();
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		String rdn = (String) query.get("rdn");
		System.out.println("--------tree" + rdn);
		try {
			ldap.connect();
			jsonObject = new JSONObject();
			String[] split = null;
			if(rdn != null){
				split = rdn.split(",");
				String searchFilter = "";
				searchFilter = split[0];
				String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				String returnedAtts[] = { "street", "ou" };
				List<Map<String, Object>> listData = ldap.searchAll(searchFilter, searchBase, returnedAtts);
				int listDataCount = listData.size();
				int pageCount = (listDataCount - 1) / pageSize + 1 ;
				Map<String, Object> data = new HashMap<String, Object>();
				data.put("rowSet", listData);
				data.put("pageNo", 1);
				data.put("pageSize", pageSize);
				data.put("pageCount", pageCount);
				data.put("rows", data.get("rowSet"));
				data.put("total", listDataCount);
				data.put("rdn", rdn);
				jsonObject = new JSONObject();
				jsonObject.putAll(data);
			}else{
				String searchFilter = "objectClass=organization";
				String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				String returnedAtts[] = { "street", "o" };
				List<Map<String, Object>> listData = ldap.searchAll(searchFilter, searchBase, returnedAtts);
				int listDataCount = listData.size();
				int pageCount = (listDataCount - 1) / pageSize + 1 ;
				Map<String, Object> data = new HashMap<String, Object>();
				data.put("rowSet", listData);
				data.put("pageNo", 1);
				data.put("pageSize", pageSize);
				data.put("pageCount", pageCount);
				data.put("rows", data.get("rowSet"));
				data.put("total", listDataCount);
				data.put("rdn", rdn);
				jsonObject = new JSONObject();
				jsonObject.putAll(data);
			}
		} catch (NamingException e) {
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		return "json";
	}
	
	//查询
	public String listUser() throws BusinessException {
		Ldap ldap = Factory.createInstance();
		try {
			ldap.connect();
			jsonObject = new JSONObject();
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request, "FIELD_");
			String searchFilter = "employeeNumber=" + query.get("EMP");
			System.out.println("-------employeeNumber"+query.get("EMP"));
			String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
			String returnedAtts[] = { "description", "o" };
			List<Map<String, Object>> listData = ldap.searchAll(searchFilter, searchBase, returnedAtts);
			int listDataCount = listData.size();
			int pageCount = (listDataCount - 1) / pageSize + 1 ;
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", listData);
			data.put("pageNo", 1);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (NamingException e) {
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		return "json";
	}
	
	/*//查询要修改的部门信息
	public String listUnit() throws BusinessException{
		Ldap ldap = Factory.createInstance();
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request, "USER0_");
		String rdnunit = (String) entity_user.get("rdn");
		try {
			ldap.connect();
			jsonObject = new JSONObject();
			String[] split = rdnunit.split(",");
			//String uuid = split[0].substring(split[0].indexOf('=') + 1);
			String searchFilter = split[0];
			String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
			String[] returnedAtts = {"description", "street"};
			List<Map<String, Object>> list = ldap.searchAll(searchFilter, searchBase, returnedAtts);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", list);
			data.put("pageNo", 1);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", list);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (NamingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			try {
				ldap.close();
			} catch (NamingException e) {
				e.printStackTrace();
			}
		}
		return "json";
	}*/
}
