package com.jw.app.mapping.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.MappingBusiness;
import com.jw.app.business.UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.common.ZtreeJsonUtils;

public class dataAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8669134434805886000L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}

	public String listMyAll() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
					RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			query.put("DELETE_FLAG", "0");
			List<Map<String, Object>> listData = business.list_usertree(query);
			int listDataCount = business.listCount_usertree(query);
			listData = ZtreeJsonUtils.getTreeGridJsonData(listData);
			listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// Date()为获取当前系统时间
		return "json";
	}

	public String listTable() throws BusinessException {
		MappingBusiness business = BusinessManager
				.getBusiness(MappingBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);

		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_table(pageNo,
					pageSize, query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
			Map<String, Object> data = new HashMap<String, Object>();
			data
					.put("rowSet", QueryParamUtil.DateToString(pageRows
							.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	public String listMappingUserTree() throws BusinessException {
		MappingBusiness business = BusinessManager
				.getBusiness(MappingBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
					RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_table(query);
			int listDataCount = business.listCount_table(query);
			//listData = ZtreeJsonUtils.getTreeGridJsonData(listData);
			listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	public String mappinginsertLoad() throws BusinessException {
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
					RequestUtils.UPDATEDATAFIELDPREFIX);
			jsonObject = new JSONObject();
			jsonObject.putAll(query);
		} catch (Exception e) {
			// TODO: handle exception
		}
		return "success";
	}

	public String mappingdetailLoad() throws BusinessException {
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
					RequestUtils.UPDATEDATAFIELDPREFIX);
			if (query.get("UUID") != null) {
				MappingBusiness business = BusinessManager
						.getBusiness(MappingBusiness.class);
				// 找出相应单位的详情
				query.put("tableName", "C_V_SYS_OTHERLOGIN");
				List<Map<String, Object>> listData = business.list_table(query);
				jsonObject = new JSONObject();
				listData = QueryParamUtil.DateToString(listData);
				if (listData != null && listData.size() > 0)
					jsonObject.putAll(listData.get(0));
			} else {
				jsonObject = new JSONObject();
				jsonObject.put("errCode", 1);
			}
		} catch (Exception e) {
			// TODO: handle exception
		}
		return "success";
	}


}
