package com.jw.app.move.action;

import java.io.File;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.MoveBusiness;
import com.gaowj.business.SystemOpeBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;

public class actAction extends BasicAction{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5560714628178697924L;

	private JSONObject jsonObject = new JSONObject();
	
	private File leftFile;
	
	private File appFile;	
	
	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public File getLeftFile() {
		return leftFile;
	}

	public void setLeftFile(File leftFile) {
		this.leftFile = leftFile;
	}

	public File getAppFile() {
		return appFile;
	}

	public void setAppFile(File appFile) {
		this.appFile = appFile;
	}

	public String insertMove() throws BusinessException{
		
		MoveBusiness business = BusinessManager.getBusiness(MoveBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_move(entity);
		    //操作日志
//		    SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
//		    sysbusiness.insert_logBusiness("insertUnit", "插入单位信息："+entity);
		    //
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateUnit() throws BusinessException{
		
    	MoveBusiness business = BusinessManager.getBusiness(MoveBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_move(entity);
		    //操作日志
//		    SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
//		    sysbusiness.insert_logBusiness("updateUnit", "修改单位信息："+entity);
		    //
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
   public String deleteUnit() throws BusinessException{
		
	    MoveBusiness business = BusinessManager.getBusiness(MoveBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_move(ListKey);
		    //操作日志
//		    SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
//		    sysbusiness.insert_logBusiness("deleteUnit", "删除单位信息："+ListKey);
		    //
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

}
