package com.jw.app.photo.action;

import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.PhotoBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;

public class actAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1825971951944267655L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	public String insert() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_folder(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String update() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_folder(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
   public String delete() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_folder(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
   public String insertPhoto() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_photo(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
   public String updatePhoto() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.update_photo(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
  public String deletePhoto() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_photo(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
  
  public String setCoverPhoto() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.setCover_photo(entity);
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
  
  public String batchUpdatePhoto() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		if(entity.get("RESOURCE_ID")!=null){
			String batch_resource_id  = (String) entity.get("RESOURCE_ID");
		    List<String> List_resource_id = QueryParamUtil.StringToList(batch_resource_id);
		    entity.put("RESOURCE_ID_LIST", List_resource_id);
		    try{
		       business.update_batchPhoto(entity);
		       jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		    }catch(Exception e){
			   jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			   e.printStackTrace();
		    }
		}else{
			jsonObject.putAll(Status.getStatus(0));
		}
		return "json";
	}
  
   public String insertAlbumNote() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_folder_note(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
   public String deleteAlbumNote() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_folderAlbumID_note(entity);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
   public String insertPhotoNote() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_photo_note(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
   public String deletePhotoNote() throws BusinessException{
		
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_folderPhotoID_note(entity);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
	public String upload() throws BusinessException{
		String upPath = request.getSession().getServletContext().getRealPath("/uploadFile/apps/photo");
	   super.setUserUploadFilePath(upPath);
	   return super.upload();
   }

}
