package com.jw.app.photo.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.PhotoBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class dataAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = 83634298782401345L;
	
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
    private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}
	
	public String list() throws BusinessException{
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_folder(pageNo,pageSize,query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAll() throws BusinessException{
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_folder(query);
			int listDataCount = business.listCount_folder(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(listData));
		    data.put("pageNo", 1);
		    data.put("pageSize",listDataCount );
		    data.put("pageCount", listDataCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String checkAlbumPassword() throws BusinessException{
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		String password = "";
		if(query.get("PASSWORD")!=null){
			password = (String) query.get("PASSWORD");
		}
		List<Map<String, Object>> listData = business.list_folder(query);
        String t_password = Encipher.DecodePasswd((String) listData.get(0).get("PASSWORD"));
        String ret = "";
        if(StringUtils.equals(password, t_password)){
        	ret = "true";
        }else{
        	ret = "false";
        }
        Map<String,Object> mdata = new HashMap<String,Object>();
		mdata.put("CHECK", ret);
		
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", mdata);
		data.put("pageNo", 1);
		data.put("pageSize",1 );
		data.put("pageCount", 1);
		data.put("rows", data.get("rowSet"));
		data.put("total", 1);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);

		return "json";
	}
	
	public String listPhoto() throws BusinessException{
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_photo(pageNo,pageSize,query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAllPhoto() throws BusinessException{
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_photo(query);
			int listDataCount = business.listCount_photo(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(listData));
		    data.put("pageNo", 1);
		    data.put("pageSize", listDataCount);
		    data.put("pageCount", listDataCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAllAlbumNote() throws BusinessException{
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_folder_note(query);
			int listDataCount = business.listCount_folder_note(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(listData));
		    data.put("pageNo", 1);
		    data.put("pageSize", listDataCount);
		    data.put("pageCount", listDataCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAllPhotoNote() throws BusinessException{
		PhotoBusiness business = BusinessManager.getBusiness(PhotoBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_photo_note(query);
			int listDataCount = business.listCount_photo_note(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(listData));
		    data.put("pageNo", 1);
		    data.put("pageSize", listDataCount);
		    data.put("pageCount", listDataCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

}
