package com.jw.app.portlet.action;

import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.PortletBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;
import com.jw.app.util.RssUrlData;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;

import net.sf.json.JSONObject;

public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 303797180576461148L;

	private JSONObject jsonObject = new JSONObject();

	private File leftFile;

	private File appFile;

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public File getLeftFile() {
		return leftFile;
	}

	public void setLeftFile(File leftFile) {
		this.leftFile = leftFile;
	}

	public File getAppFile() {
		return appFile;
	}

	public void setAppFile(File appFile) {
		this.appFile = appFile;
	}

	public String insertPTemplate() throws BusinessException {

		PortletBusiness business = BusinessManager
				.getBusiness(PortletBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		entity.remove("OPETYPE");
		try {
			entity = QueryParamUtil.StringToDate(entity);
			if(entity.get("PORTLET_ID")==null)
				entity.put("PORTLET_ID", java.util.UUID.randomUUID().toString());
			//下述代码用于对RSS的后台解析
			/*if (entity.get("P_TYPE") != null
					&& StringUtils.equals((String) entity.get("P_TYPE"), "3")) {
				String url = (String) entity.get("URL");
				String is_pop = (String) entity.get("IS_POP");
				String portletId=(String)entity.get("PORTLET_ID");
				URL Url = new URL(url);
				SyndFeedInput input = new SyndFeedInput();
				SyndFeed feed = null;
				URLConnection conn;
				conn = Url.openConnection();
				String content_encoding = conn
						.getHeaderField("Content-Encoding");

				if (content_encoding != null
						&& content_encoding.contains("gzip")) {
					System.out.println("conent encoding is gzip");
					GZIPInputStream gzin = new GZIPInputStream(conn
							.getInputStream());
					feed = input.build(new XmlReader(gzin));
				} else {
					feed = input.build(new XmlReader(conn.getInputStream()));
				}

				List entries = feed.getEntries();// 得到所有的标题<title></title>
				String content_html = "";
				content_html = content_html + "<table width=\"100%\">";
				int count =0;
				for (int i = 0; i < entries.size(); i++) {
					SyndEntry entry = (SyndEntry) entries.get(i);
					String title = entry.getTitle();
					if (title.length() > 18)
						title = title.substring(0, 18) + "...";
					if (is_pop != null && StringUtils.equals(is_pop, "1")) {// 转到新页面
						content_html = content_html
								+ "<tr><td width=\"65%\" height=\"25\" style=\"border-bottom:dashed 1px #ccc;\"><a href='"
								+ entry.getLink()
								+ "' target=\"_blank\" style=\"color:#000;\"><image src=\"image/image/s_left.gif\"/><span style=\"padding-left:3px;\">"
								+ title + "</span></a></td>"
								+ "<td style=\"border-bottom:dashed 1px #ccc;\"><span style=\"padding-left:10px;\">"
								+ entry.getAuthor() + "</span></td></tr>";

					} else {// 默认弹出
						content_html = content_html
								+ "<tr><td height=\"25\" width=\"65%\" style=\"border-bottom:dashed 1px #ccc;\"><a href=\"javascript:window.parent.openNewNoLock('"
								+ entry.getLink()
								+ "','','"
								+ entry.getTitle()
								+ "',1024,500);\" style=\"color:#000;\"><image src=\"image/image/s_left.gif\"/><span style=\"padding-left:3px;\">"
								+ title + "</span></a></td>"
								+ "<td style=\"border-bottom:dashed 1px #ccc;\"><span style=\"padding-left:10px;\">"
								+ entry.getAuthor() + "</span></td></tr>";
					}
					if(count==9){
						content_html = content_html
			             + "<tr><td colspan=\"4\" align=\"right\"><a href=\"javascript:alertRSSGrid('"+portletId+"','"+is_pop+"');\" style=\"color:#000;\">>>更多</a></td></tr>";
						break;
					}
					count++;
				}
				content_html = content_html + "</table>";
				entity.put("TAKE_CONTENT", content_html);
			}*/
			business.insert_portlet_template(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager
					.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("insertPTemplate", "" + entity,
					"增加PORTLET记录", (String) entity.get("PORTLET_ID"),
					(String) entity.get("NAME"), "JW_APPS_PORTLET_TEMPLATE");
			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String updatePTemplate() throws BusinessException {

		PortletBusiness business = BusinessManager.getBusiness(PortletBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		entity.remove("OPETYPE");
		try {
			entity = QueryParamUtil.StringToDate(entity);
			//目前版本不对RSS进行后台解析存储,所以将下述代码注释，如要开启，需要注意防止存储到日志表中的数据过大而产生data too long错误
			//entity = RssUrlData.rssContent(entity);
			business.update_portlet_template(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			//将存储RSS的大文本内容删除，否则日志表数据量过大
			/*entity.remove("TAKE_CONTENT");
			entity.remove("RSS_CONTENT");*/
			sysbusiness.insert_logBusiness("updatePTemplate", "" + entity,
					"修改PORTLET记录", (String) entity.get("PORTLET_ID"),
					(String) entity.get("NAME"), "JW_APPS_PORTLET_TEMPLATE");
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String deletePTemplate() throws BusinessException {

		PortletBusiness business = BusinessManager
				.getBusiness(PortletBusiness.class);
		String deletekey = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			Map<String, Object> query = new HashMap<String, Object>();
			deletekey = "";
			for (String string : ListKey) {
				deletekey += "\'" + string + "\',";
			}
			deletekey = deletekey.substring(0, deletekey.length() - 1);
			query.put("list", deletekey);
			List<Map<String, Object>> list = business
					.list_portlet_template(query);
			query = new HashMap<String, Object>();
			// 名称
			String userName = "";
			for (Map<String, Object> map : list) {
				userName += map.get("NAME") + ",";
			}
			query.put("NAME", userName);
			business.delete_portlet_template(ListKey);
			// List<Map<String,Object>>list=new ArrayList<Map<String,Object>>();
			// for (String string : ListKey) {
			// Map<String,Object>query=new HashMap<String, Object>();
			// query.put("PORTLET_ID", string);
			// list.add(query);
			// }
			// Map<String,Object>query=new HashMap<String, Object>();
			// query.put("list", list);

			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager
					.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deletePTemplate", ""
					+ ListKey.toString(), "删除PORTLET记录", ListKey.toString(),
					query.toString(), "JW_APPS_PORTLET_TEMPLATE");
			jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String insertPSetup() throws BusinessException {

		PortletBusiness business = BusinessManager
				.getBusiness(PortletBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			entity = QueryParamUtil.StringToDate(entity);
			Map<String, Object> query = new HashMap<String, Object>();
			List<Map<String, Object>> listData = business
					.list_portlet_setup(query);
			for (Map<String, Object> map : listData) {
				entity.put("PSTYLE", map.get("PSTYLE"));
				break;
			}
			business.insert_portlet_setup(entity);
			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String updatePSetup() throws BusinessException {

		PortletBusiness business = BusinessManager
				.getBusiness(PortletBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			entity = QueryParamUtil.StringToDate(entity);
			business.update_portlet_setup(entity);
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String deletePSetup() throws BusinessException {

		PortletBusiness business = BusinessManager
				.getBusiness(PortletBusiness.class);
		String deletekey = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			business.delete_portlet_setup(ListKey);
			jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String uploadUser() throws BusinessException {
		String upPath = request.getSession().getServletContext().getRealPath(
				"/uploadFile/apps/user");
		super.setUserUploadFilePath(upPath);
		return super.upload();
	}

}
