package com.jw.app.pushData.action;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import net.sf.json.JSONObject;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.service.client.utils.httpClientPostData;
import com.gaowj.service.client.utils.jsonFormatMap;
import com.jw.app.business.PushDataBusiness;
import com.jw.app.business.UnitBusiness;
import com.jw.app.business.UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;
import com.jw.app.pushData.util.PushDataUtils;

public class actAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8798450773321749181L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	public String insertPushData() throws BusinessException{
		
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_pushData(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
   public String updatePushData() throws BusinessException{
		
	   PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			String []uuids=entity.get("UUID").toString().split("\\,");
			for (String string : uuids) {
				Map<String , Object> map=new HashMap<String, Object>();
				map.putAll(entity);
				map.put("UUID", string);
				business.update_pushData(map);
			}
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    
   public String deletePushData() throws BusinessException{
		
	   PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_pushData(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
   public String PushData() throws BusinessException{
		
	   PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String []uuids=entity.get("UUID").toString().split("\\,");
			for (String string : uuids) {
				Map<String , Object> map=new HashMap<String, Object>();
				map.putAll(entity);
				map.put("UUID", string);
				List<Map<String,Object>> p_data = business.list_pushData(map);
				if(p_data.size()>0){
					Map<String,Object> data = p_data.get(0);
					String type = (String) data.get("TYPE");
					String push_data_id = (String) data.get("PUSH_DATA_ID");
					String jsondata = getJsonData(type,push_data_id);
					httpClientPostData myhttp = new httpClientPostData();
					String ret = myhttp.requestSystem((String)data.get("PUSH_LOGIN_URL"),(String)data.get("PUSH_NAME"), (String)data.get("PUSH_PASS"), jsondata, (String)data.get("PUSH_URL"), (String)data.get("PUSH_ENCODE"));
					System.out.println(ret);
					Map<String,Object> m = null;
					if(ret!=null && ret.trim().length()>0){
						m = jsonFormatMap.getMap(ret);
					}
					SystemOpeBusiness sysbusiness = BusinessManager
					.getBusiness(SystemOpeBusiness.class);
					Map<String	, Object>parrams=new HashMap<String, Object>();
					parrams.put("MODULES", "pushDate");
					parrams.put("OPE", "" + data);
					parrams.put("DESCRIPTION", "推送管理推送记录");
					parrams.put("RECORDID", data.get("UUID"));
					parrams.put("TYPE", "JW_APPS_UICM_PUSH");
					parrams.put("RECORDNAME", data.get("PUSH_DATA_NAME"));
					sysbusiness.insert_logBusiness(parrams);
					
					if(m!=null && m.get("NAME")!=null && Integer.parseInt((String)m.get("NAME"))>0){
						System.out.println("推送成功!");
						Map<String,Object> finishData = new HashMap<String,Object>();
						finishData.put("UUID", data.get("UUID"));
						finishData.put("ISFINISH", "1");
						business.update_pushData(finishData);
						jsonObject.putAll(Status.getStatusSuccessMessage("推送数据完成"));
					}else{
						System.out.println("推送失败!");
						Map<String, Object> finishData = new HashMap<String, Object>();
						finishData.put("UUID", data.get("UUID"));
						finishData.put("ERRORCOUNT", ((java.math.BigDecimal)data.get("ERRORCOUNT")).intValue()+1);
						business.update_pushData(finishData);
						jsonObject.putAll(Status.getStatusErrorMessage("推送数据出错"));
					}
				}
			}
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("推送数据出错"));
			e.printStackTrace();
		}
		return "json";
	}
   
   
   private String getJsonData(String type,String push_data_id){
	   String ret = "";
	   if(StringUtils.equals(type, "1")){
		   UserBusiness user_business = BusinessManager.getBusiness(UserBusiness.class);
		   Map<String,Object> p_user_query = new HashMap<String,Object>();
		   p_user_query.put("USER_ID", push_data_id);
		   List<Map<String, Object>> p_user = user_business.list_user(p_user_query);
		   if(p_user.size()>0){
		     PushDataUtils pd  = new PushDataUtils();
		     try {
				ret = pd.getPushUserData(QueryParamUtil.DateToString(p_user.get(0)));
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		   }
	   }else if(StringUtils.equals(type, "2")){
		   UnitBusiness unit_business = BusinessManager.getBusiness(UnitBusiness.class);
		   Map<String,Object> p_unit_query = new HashMap<String,Object>();
		   p_unit_query.put("UUID", push_data_id);
		   List<Map<String, Object>> p_unit = unit_business.list_unit(p_unit_query);
		   if(p_unit.size()>0){
		     PushDataUtils pd  = new PushDataUtils();
		     try {
				ret = pd.getPushUnitData(QueryParamUtil.DateToString(p_unit.get(0)));
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		   }
	   }
	   return ret;
   }
   
   
   public String insertPushApp() throws BusinessException{
		
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
		    business.insert_pushApp(entity);
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
  public String updatePushApp() throws BusinessException{
		
	   PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			String []uuids=entity.get("UUID").toString().split("\\,");
			for (String string : uuids) {
				Map<String , Object> map=new HashMap<String, Object>();
				map.putAll(entity);
				map.put("UUID", string);
				business.update_pushApp(map);
			}
		    jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
   
  public String deletePushApp() throws BusinessException{
		
	   PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		try{
		    business.delete_pushApp(ListKey);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
  
  public String deletePushApp_map() throws BusinessException{ 
	   PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
	   Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
		    business.delete_pushApp_map(entity);
		    jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
  public String insertOrUpdatePushApp() throws BusinessException{
		
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			List<Map<String, Object>> list = business.list_pushApp(entity);
			if(list.size() > 0){
				entity.put("UUID", list.get(0).get("UUID"));
				business.update_pushApp(entity);
			}else{
				business.insert_pushApp(entity);
			}
		    jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}

}
