package com.jw.app.pushData.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.PushDataBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class dataAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = -6999246040882964859L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
    private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}
	
	public String listPushData() throws BusinessException{
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_pushData(pageNo,pageSize,query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAllPushData() throws BusinessException{
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_pushData(query);
			int listDataCount = business.listCount_pushData(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(listData));
		    data.put("pageNo", 1);
		    data.put("pageSize", listDataCount);
		    data.put("pageCount", listDataCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listPushApp() throws BusinessException{
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_pushApp(pageNo,pageSize,query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listPushAppAll() throws BusinessException{
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> pageRows = business.list_pushApp_all(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", pageRows);
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listAllPushApp() throws BusinessException{
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			List<Map<String, Object>> listData = business.list_pushApp(query);
			int listDataCount = business.listCount_pushApp(query);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(listData));
		    data.put("pageNo", 1);
		    data.put("pageSize", listDataCount);
		    data.put("pageCount", listDataCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	//根据推送client_code推送人员显示
	public String listPushDataUser() throws BusinessException{
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String query = (String) entity.get("CODE");
		System.out.println("------code" + query);
		//List<Map<String, Object>> list = business.list_pushData_user(query);
		Page<Map<String, Object>> pageRows = business.list_pushData_user(pageNo, pageSize, query);
		//int listDataCount = business.list_pushData_user_count(query);
		 Map<String,Object> data = new HashMap<String,Object>();
		 try {
				data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
				data.put("pageNo", pageNo);
			    data.put("pageSize", pageSize);
			    data.put("pageCount", pageCount);
			    data.put("rows", data.get("rowSet"));
				data.put("total", pageRows.getCount());
			    jsonObject = new JSONObject();
			    jsonObject.putAll(data);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return "json";
	}
    //根据推送的client_code显示推送过的部门
	public String listPushDataUnit() throws BusinessException{
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String query = (String) entity.get("CODE");
		System.out.println("------code" + query);
		//List<Map<String, Object>> list = business.list_pushData_unit(query);
		Page<Map<String, Object>> pageRows = business.list_pushData_unit(pageNo, pageSize, query);
		//int listDataCount = business.list_pushData_unit_count(query);
		 Map<String,Object> data = new HashMap<String,Object>();
		    try {
				data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
				data.put("pageNo", pageNo);
			    data.put("pageSize", pageSize);
			    data.put("pageCount", pageCount);
			    data.put("rows", data.get("rowSet"));
				data.put("total", pageRows.getCount());
			    jsonObject = new JSONObject();
			    jsonObject.putAll(data);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}    
		return "json";
	}
	
	//推送显示部门
	public String listPushAppUnit() throws BusinessException{
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_pushApp_unit(pageNo,pageSize,query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	//推送显示人员
	public String listPushAppUser() throws BusinessException{
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		
		try {
			query = QueryParamUtil.StringToDate(query);
			Page<Map<String, Object>> pageRows = business.list_pushApp_user(pageNo,pageSize,query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
		    Map<String,Object> data = new HashMap<String,Object>();
		    data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
		    data.put("pageNo", pageNo);
		    data.put("pageSize", pageSize);
		    data.put("pageCount", pageCount);
		    data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
		    jsonObject = new JSONObject();
		    jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
}
