package com.jw.app.pushData.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.service.client.utils.httpClientPostData;
import com.gaowj.service.client.utils.jsonFormatMap;
import com.jw.app.business.PushDataBusiness;
import com.jw.app.business.UnitBusiness;
import com.jw.app.business.UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;

import net.sf.json.JSONObject;

public class PushDataUtils {
	
	public String  getPushUserData(Map<String,Object> data){
		Map<String,Object> dataMap = new HashMap<String,Object>();
		dataMap.put("USER_ID", data.get("USER_ID")); 
		dataMap.put("ID_NUMBER", data.get("ID_NUMBER"));dataMap.put("USER_NAME", data.get("USER_NAME"));
		dataMap.put("UNIT_ID", data.get("UNIT_ID"));    dataMap.put("MOBILE", data.get("MOBILE"));
		dataMap.put("USER_SEX", data.get("USER_SEX"));  dataMap.put("ORDER_ID", data.get("ORDER_ID"));
		dataMap.put("EMAIL", data.get("EMAIL"));        dataMap.put("IP", data.get("IP"));
		dataMap.put("TELEPHONE", data.get("TELEPHONE"));dataMap.put("CARD_TYPE", data.get("CARD_TYPE"));
		dataMap.put("CARD_ID", data.get("CARD_ID"));    dataMap.put("TECHNIC", data.get("TECHNIC"));
		dataMap.put("IS_SFZB", data.get("IS_SFZB"));    dataMap.put("ZBLB", data.get("ZBLB"));
		dataMap.put("POST", data.get("POST"));          dataMap.put("BEGIN_TIME", "DATE_"+data.get("BEGIN_TIME"));
		dataMap.put("IS_ACTIVE", data.get("IS_ACTIVE"));dataMap.put("REMARK", data.get("REMARK"));
		dataMap.put("UPDATE_TIME", "DATE_"+data.get("UPDATE_TIME"));
		dataMap.put("DELETE_FLAG", data.get("DELETE_FLAG"));
		dataMap.put("UNITID", data.get("UNITID"));
		dataMap.put("UNIT_PATH", data.get("UNIT_PATH"));
//		List<Map<String,Object>> listData = new ArrayList<Map<String,Object>>();
//		listData.add(dataMap);
		JSONObject jsonObject = new JSONObject();
		jsonObject.putAll(dataMap);
		String jsondata = jsonObject.toString();
		return jsondata;
		
	}
	
	public String  getPushUserDataWithPass(Map<String,Object> data){
		Map<String,Object> dataMap = new HashMap<String,Object>();
		dataMap.put("USER_ID", data.get("USER_ID"));   dataMap.put("USER_PWD", data.get("USER_PWD"));
		dataMap.put("ID_NUMBER", data.get("ID_NUMBER"));dataMap.put("USER_NAME", data.get("USER_NAME"));
		dataMap.put("UNIT_ID", data.get("UNIT_ID"));    dataMap.put("MOBILE", data.get("MOBILE"));
		dataMap.put("USER_SEX", data.get("USER_SEX"));  dataMap.put("ORDER_ID", data.get("ORDER_ID"));
		dataMap.put("EMAIL", data.get("EMAIL"));        dataMap.put("IP", data.get("IP"));
		dataMap.put("TELEPHONE", data.get("TELEPHONE"));dataMap.put("CARD_TYPE", data.get("CARD_TYPE"));
		dataMap.put("CARD_ID", data.get("CARD_ID"));    dataMap.put("TECHNIC", data.get("TECHNIC"));
		dataMap.put("IS_SFZB", data.get("IS_SFZB"));    dataMap.put("ZBLB", data.get("ZBLB"));
		dataMap.put("POST", data.get("POST"));          dataMap.put("BEGIN_TIME", "DATE_"+data.get("BEGIN_TIME"));
		dataMap.put("IS_ACTIVE", data.get("IS_ACTIVE"));dataMap.put("REMARK", data.get("REMARK"));
		dataMap.put("UPDATE_TIME", "DATE_"+data.get("UPDATE_TIME"));
		dataMap.put("DELETE_FLAG", data.get("DELETE_FLAG"));
		dataMap.put("UNITID", data.get("UNITID"));
		dataMap.put("UNIT_PATH", data.get("UNIT_PATH"));
//		List<Map<String,Object>> listData = new ArrayList<Map<String,Object>>();
//		listData.add(dataMap);
		JSONObject jsonObject = new JSONObject();
		jsonObject.putAll(dataMap);
		String jsondata = jsonObject.toString();
		return jsondata;
		
	}
	
	public String  getPushUnitData(Map<String,Object> data){
		Map<String,Object> dataMap = new HashMap<String,Object>();
		dataMap.put("UUID", data.get("UUID"));dataMap.put("UNIT_ID", data.get("UNIT_ID"));
		dataMap.put("NAME", data.get("NAME"));dataMap.put("PARENT_ID", data.get("PARENT_ID"));
		dataMap.put("AREA_TYPE", data.get("AREA_TYPE"));dataMap.put("ORDER_ID", data.get("ORDER_ID"));
		dataMap.put("OFFICE_PHONE", data.get("OFFICE_PHONE"));dataMap.put("TYPE", data.get("TYPE"));
		dataMap.put("IS_ENTITY", data.get("IS_ENTITY"));dataMap.put("OFFICE_ADRESS", data.get("OFFICE_ADRESS"));
		dataMap.put("DESCP", data.get("DESCP"));dataMap.put("REMARK", data.get("REMARK"));
		dataMap.put("UPDATE_TIME", "DATE_"+data.get("UPDATE_TIME"));
		dataMap.put("DELETE_FLAG", data.get("DELETE_FLAG"));
		dataMap.put("PARENT_UNITID", data.get("PARENT_UNITID"));
		dataMap.put("UNIT_PATH", data.get("UNIT_PATH"));
//		List<Map<String,Object>> listData = new ArrayList<Map<String,Object>>();
//		listData.add(dataMap);
		JSONObject jsonObject = new JSONObject();
		jsonObject.putAll(dataMap);
		String jsondata = jsonObject.toString();
		return jsondata;
		
	}
	
	
	public String PushData() {
		String ret_data = "";
		PushDataBusiness business = BusinessManager.getBusiness(PushDataBusiness.class);
		Map<String, Object> query = new HashMap<String,Object>();
		query.put("ISFINISH", "0");
		query.put("PUSH_LIMIT", "Y");
		try {
			List<Map<String, Object>> p_data = business.list_pushData(query);
			if (p_data.size() > 0) {
			 for(Map<String, Object> data : p_data){
				String type = (String) data.get("TYPE");
				String push_data_id = (String) data.get("PUSH_DATA_ID");
				String jsondata = getJsonData(type, push_data_id);
				httpClientPostData myhttp = new httpClientPostData();
				String ret = myhttp.requestSystem(
						(String) data.get("PUSH_LOGIN_URL"),
						(String) data.get("PUSH_NAME"),
						(String) data.get("PUSH_PASS"), jsondata,
						(String) data.get("PUSH_URL"),
						(String) data.get("PUSH_ENCODE"));
				System.out.println(ret);
				ret_data = ret;
				Map<String, Object> m = null;
				if (ret != null && ret.trim().length() > 0) {
					m = jsonFormatMap.getMap(ret);
				}
				if (m != null && m.get("NAME") != null
						&& Integer.parseInt((String) m.get("NAME")) > 0) {
					System.out.println("推送成功!");
					Map<String, Object> finishData = new HashMap<String, Object>();
					finishData.put("UUID", data.get("UUID"));
					finishData.put("ISFINISH", "1");
					business.update_pushData(finishData);
				} else {
					System.out.println("推送失败!");
					Map<String, Object> finishData = new HashMap<String, Object>();
					finishData.put("UUID", data.get("UUID"));
					finishData.put("ERRORCOUNT", ((java.math.BigDecimal)data.get("ERRORCOUNT")).intValue()+1);
					business.update_pushData(finishData);
				}
			 }
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return ret_data;
	}

	private String getJsonData(String type, String push_data_id) {
		String ret = "";
		if (StringUtils.equals(type, "1")) {
			UserBusiness user_business = BusinessManager
					.getBusiness(UserBusiness.class);
			Map<String, Object> p_user_query = new HashMap<String, Object>();
			p_user_query.put("USER_ID", push_data_id);
			List<Map<String, Object>> p_user = user_business
					.list_user(p_user_query);
			if (p_user.size() > 0) {
				try {
					ret = getPushUserData(QueryParamUtil.DateToString(p_user
							.get(0)));
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		} else if (StringUtils.equals(type, "2")) {
			UnitBusiness unit_business = BusinessManager
					.getBusiness(UnitBusiness.class);
			Map<String, Object> p_unit_query = new HashMap<String, Object>();
			p_unit_query.put("UUID", push_data_id);
			List<Map<String, Object>> p_unit = unit_business
					.list_unit(p_unit_query);
			if (p_unit.size() > 0) {
				try {
					ret = getPushUnitData(QueryParamUtil.DateToString(p_unit
							.get(0)));
				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		return ret;
	}
	

}
