package com.jw.app.unit.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import org.apache.commons.lang.StringUtils;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.UnitBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.common.EasyuiJsonUtils;
import com.jw.app.common.ZtreeJsonUtils;

public class dataAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2007640740610775321L;
	private JSONObject jsonObject = new JSONObject();
	SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}

	public String list() throws BusinessException {
		UnitBusiness business = BusinessManager.getBusiness(UnitBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			query.put("DELETE_FLAG", "0");
			Page<Map<String, Object>> pageRows = business.list_unit(pageNo,
					pageSize, query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
			Map<String, Object> data = new HashMap<String, Object>();
			data
					.put("rowSet", QueryParamUtil.DateToString(pageRows
							.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	public String listAll() throws BusinessException {
		UnitBusiness business = BusinessManager.getBusiness(UnitBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
					RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			query.put("DELETE_FLAG", "0");
			List<Map<String, Object>> listData = business.list_unit(query);
			int listDataCount = business.listCount_unit(query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	public String listMy() throws BusinessException {
//		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");// 设置日期格式
		UnitBusiness business = BusinessManager.getBusiness(UnitBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		// 找出所有子级单位
		List<Map<String, Object>> listData = business.list_unit(null);
		if (query.get("TREE_CLICK") == null
				|| StringUtils.equals((String) query.get("UNIT_ID_IS_PARENT"),"A")) {
			listData = ZtreeJsonUtils.getUserGridJsonData(listData);
			List<String> list = new ArrayList<String>();
			for (Map<String, Object> m : listData) {
				list.add((String) m.get("UUID"));
			}
			query.put("UNIT_ID_IS_PARENT", list);
		} else {
			List<String> list = EasyuiJsonUtils.getParentsData(listData,(String) query.get("UNIT_ID_IS_PARENT"));
			query.put("UNIT_ID_IS_PARENT", list);
		}
		//
		try {
			query = QueryParamUtil.StringToDate(query);
			query.put("DELETE_FLAG", "0");
			Page<Map<String, Object>> pageRows = business.list_unit(pageNo,pageSize, query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
//		System.out.println(df.format(new Date()));// new Date()为获取当前系统时间
		return "json";
	}

	public String listMyAll() throws BusinessException {
		UnitBusiness business = BusinessManager.getBusiness(UnitBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			query.put("DELETE_FLAG", "0");
			List<Map<String, Object>> listData = business.list_unit(query);
			int listDataCount = business.listCount_unit(query);
			listData = ZtreeJsonUtils.getTreeGridJsonData(listData);
			listDataCount = listData.size();
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	public String listUnitTree() throws BusinessException {
		UnitBusiness business = BusinessManager.getBusiness(UnitBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			System.out.println("-----------query" + query);
			query.put("DELETE_FLAG", "0");
			List<Map<String, Object>> listData = business.list_unit(query);
			int listDataCount = business.listCount_unit(query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", EasyuiJsonUtils.getTreeJsonData(QueryParamUtil
					.DateToString(listData)));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	public String listMyUnitTree() throws BusinessException {
		UnitBusiness business = BusinessManager.getBusiness(UnitBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			//Map<String, Object> queryaccou = RequestUtils.getUpdateFieldMap(request,"accou");
			//Map<String, Object> queryuser0 = RequestUtils.getUpdateFieldMap(request,"user0");
			query = QueryParamUtil.StringToDate(query);
			query.put("DELETE_FLAG", "0");
			List<Map<String, Object>> listData = business.list_unit(query);
			int listDataCount = business.listCount_unit(query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", EasyuiJsonUtils.getMyTreeJsonData(QueryParamUtil
					.DateToString(listData)));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	
	public String listMaxOrder() throws BusinessException {
		UnitBusiness business = BusinessManager.getBusiness(UnitBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			int listDataCount = business.list_max_order(query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("maxorder", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
    
	//组织ZTREE查询
	public String listALLUnit() throws BusinessException {
		UnitBusiness unitBusiness = BusinessManager.getBusiness(UnitBusiness.class);
		List<Map<String, Object>> listunit = unitBusiness.listAllUnit();
		List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
		list.addAll(listunit);
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("rowSet", list);
		data.put("pageNo", pageNo);
		data.put("pageSize", pageSize);
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", 1);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		return "json";
	}
}
