package com.jw.app.user.action;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.DigestException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.poi.util.SystemOutLogger;

import net.sf.json.JSONObject;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.Java_tool;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.business.vfs.FileUtil;
import com.gaowj.service.client.remote.util.AuthenticateUtil;
import com.gaowj.service.client.utils.Native2AsciiUtils;
import com.gaowj.service.client.utils.PbeEncrypt;
import com.gaowj.service.client.utils.httpClientPostData;
import com.gaowj.service.client.utils.jsonFormatMap;
import com.gaowj.util.Factory;
import com.gaowj.util.Ldap;
import com.gaowj.util.Sha1;
import com.gaowj.util.TakeUnitsUtils;
import com.jw.app.business.MoveBusiness;
import com.jw.app.business.PushDataBusiness;
import com.jw.app.business.UnitBusiness;
import com.jw.app.business.UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;
import com.jw.app.common.EasyuiJsonUtils;
import com.jw.app.pushData.util.PushDataUtils;
import com.jw.app.user.utils.operateGroup;
import com.sun.xml.internal.messaging.saaj.util.Base64;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;


public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6496396449440750926L;

	private JSONObject jsonObject = new JSONObject();

	private File leftFile;

	private File appFile;

	private String loginuserCode = SessionUtil.getCode();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public File getLeftFile() {
		return leftFile;
	}

	public void setLeftFile(File leftFile) {
		this.leftFile = leftFile;
	}

	public File getAppFile() {
		return appFile;
	}

	public void setAppFile(File appFile) {
		this.appFile = appFile;
	}

	public String insertUser() throws BusinessException {

		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request, "USER0_");
		Map<String, Object> entity_account = RequestUtils.getUpdateFieldMap(request, "ACCOU_");
		Map<String, Object> entity_ext = RequestUtils.getUpdateFieldMap(request, "EXT00_");
		Map<String, Object> entity_field = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String flag = "";
		String pushflag = PropUtil.getValue("pushflag","quartz_service","0");
		String ldapflag = PropUtil.getValue("flag","quartz_service","0");
		try {
			entity_user = QueryParamUtil.StringToDate(entity_user);
			entity_account = QueryParamUtil.StringToDate(entity_account);
			entity_ext = QueryParamUtil.StringToDate(entity_ext);
			String uuid = java.util.UUID.randomUUID().toString();
			entity_user.put("USER_ID", uuid);
			entity_account.put("USER_ID", uuid);
			entity_ext.put("USER_ID", uuid);
			entity_field.put("USER_ID", uuid);
			if (entity_user.get("USER_PWD") == null) {
				entity_user.put("USER_PWD", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service","0000")));
			} else {
				entity_user.put("USER_PWD", Encipher.EncodePasswd((String) entity_user.get("USER_PWD")));
			}
			if (entity_user.get("USER_PWD_RESET") != null
					&& entity_user.get("USER_PWD_RESET").toString().equals("1")) {
				entity_user.put("USER_PWD", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service","0000")));
				entity_user.remove("USER_PWD_RESET");
			}
			// 恢复删除的数据
			if (entity_account.get("FLAG") != null
					&& entity_account.get("FLAG").toString().equals("1")) {
				Map<String, Object> query = new HashMap<String, Object>();
				query.put("ID_NUMBER", entity_account.get("ID_NUMBER")
						.toString());
				List<Map<String, Object>> deleteuser = new ArrayList<Map<String, Object>>();
				deleteuser = business.list_user(query);
				for (Map<String, Object> map : deleteuser) {
					entity_user.put("USER_ID", map.get("USER_ID").toString());
					entity_account
							.put("USER_ID", map.get("USER_ID").toString());
					entity_ext.put("USER_ID", map.get("USER_ID").toString());
				}
				entity_account.put("DELETE_FLAG", "0");
				business.update_user(entity_user);
				flag = entity_account.get("FLAG").toString();
				entity_account.remove("FLAG");
				business.update_user_account(entity_account);
				business.update_user_ext(entity_ext);
			} else {
				Map<String, Object> query = new HashMap<String, Object>();
				query.put("ID_NUMBER", entity_account.get("ID_NUMBER")
						.toString());
				int count = business.listCount_user(query);
				// 编号存在
				if (count > 0) {
					query.put("DELETE_FLAG", "1");
					count = 0;
					count = business.listCount_user(query);
					// 该编号已被删除
					if (count > 0) {
						jsonObject.putAll(Status
								.getStatus(Status.INSERT_ERR_DELETE));
						return "json";
					} else {
						jsonObject.putAll(Status
								.getStatus(Status.INSERT_ERR_USERID));
						return "json";
					}
				}
				//排序
				String is_orders = (String) entity_field.get("IS_ORDER");
				String is_order[] = is_orders.split("\\_");
				Integer a = Integer.parseInt(is_order[0]);
				Integer b = Integer.parseInt(is_order[2]);
				//新增(电话号码判断)
				Map<String, Object> mapmobile = new HashMap<String, Object>();
				mapmobile.put("MOBILE", entity_ext.get("MOBILE"));
				int rescount = business.listMoblieCount(mapmobile);
				if(rescount == 0){
					business.insert_user(entity_user);
					entity_account.remove("FLAG");
					business.insert_user_account(entity_account);
					business.insert_user_ext(entity_ext);
					//分配个人编辑权限
					operateGroup.insertGroup(uuid);
				}else{
					jsonObject.putAll(Status.getStatus(Status.INSERT_ERR_USERID));
					return "json";
				}
				//
				String is_swith = is_order[1];
				List<Map<String, Object>> update_user_data = UserSetOrder(a,b,is_swith);
				Map<String, Object> newdata = new HashMap<String,Object>();
				newdata.put("USER_ID", entity_field.get("USER_ID"));
				newdata.put("ORDER_ID", b);
				update_user_data.add(newdata);
				if(update_user_data.size()>0){
					for(Map<String, Object> udata : update_user_data){
						business.update_user_account(udata);
					}
				}
			}
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager
					.getBusiness(SystemOpeBusiness.class);
			Map<String, Object> entity = new HashMap<String, Object>();
			entity.putAll(entity_user);
			entity.putAll(entity_account);
			entity.putAll(entity_ext);
			if (flag.equals(""))
				sysbusiness.insert_logBusiness("insertUser", "" + entity,
						"增加人员记录", uuid, (String) entity.get("USER_NAME"),
						"JW_APPS_UICM_USER_INFO");
			else {
				sysbusiness.insert_logBusiness("updateUser", "" + entity,
						"恢复人员记录", uuid, (String) entity.get("USER_NAME"),
						"JW_APPS_UICM_USER_INFO");
			}
			//
			// 人员推送
			if(pushflag.equals("1")){
				Map<String, Object> p_user_query = new HashMap<String, Object>();
				p_user_query.put("USER_ID", entity_user.get("USER_ID"));
				List<Map<String, Object>> p_user = business.list_user(p_user_query);
				if (p_user.size() > 0) {
					if (flag.equals(""))
					sysbusiness.insert_logBusiness("pushInsertUser", "" + entity,
							"推送增加人员记录", uuid, (String) entity.get("USER_NAME"),
							"JW_APPS_UICM_PUSH");
					else {
						sysbusiness.insert_logBusiness("pushInsertUser", "" + entity,
								"推送恢复人员记录", uuid, (String) entity.get("USER_NAME"),
								"JW_APPS_UICM_PUSH");
					}
					ThreadUtil thread = new ThreadUtil(QueryParamUtil
							.DateToString(p_user.get(0)));
					thread.start();
				}
			}
			//ldap同步操作
			if(ldapflag.equals("1")){
				Ldap ldap = Factory.createInstance();
				ldap.connect();
				String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				Map<String, Object> list = business.list_user_ldap_single(entity_user.get("USER_ID").toString());
				System.out.println("------user_id"+entity_user.get("USER_ID"));
				System.out.println("------uuid"+uuid);
				System.out.println("-------list"+list);
				String searchFilter1 = "ou=" + list.get("UNIT_ID");
				List<Map<String, Object>> result1 = ldap.searchAll(searchFilter1, searchBase, null);
				String rdn = "uid=" + uuid + "," + result1.get(0).get("rdn") + "," + searchBase;
				System.out.println("-------rdn"+rdn);
				String objectClass = "inetOrgPerson";
    			Attribute attr = new BasicAttribute("objectClass");
    			attr.add(objectClass);
    			Attributes attrs = new BasicAttributes();
    			attrs.put(attr);
    			attrs.put("uid", list.get("USER_ID"));
				attrs.put("description", list.get("USER_NAME"));
				String pass = Sha1.SHA1(Encipher.DecodePasswd((String) list.get("USER_PWD")));
    			attrs.put("userPassword", pass);
    			if(list.get("USER_SEX").equals("1")){
    				attrs.put("usersex", "男");
    			}else if(list.get("USER_SEX").equals("2")){
    				attrs.put("usersex", "女");
    			}
    			//attrs.put("usersex", map.get("USER_SEX"));
    			attrs.put("employeeNumber", list.get("ID_NUMBER"));
    			attrs.put("ou", list.get("UNIT_NAME"));
    			attrs.put("cn", list.get("USER_ID"));
    			attrs.put("sn", list.get("USER_ID"));
    			System.out.println("------st"+list.get("UNIT_ID"));
    			String st = (String)list.get("UNIT_ID");
    			attrs.put("st", st);
    			if(!(list.get("MOBILE") == null)){
    				attrs.put("mobile", list.get("MOBILE"));
    			}
    			if(!(list.get("EMAIL") == null)){
    				attrs.put("mail", list.get("EMAIL"));
    			}
    			if(!(list.get("CARD_ID") == null)){
    				attrs.put("idcard", list.get("CARD_ID"));
    			}
                if(!(list.get("TELEPHONE") == null)){
                	attrs.put("telephoneNumber", list.get("TELEPHONE"));	
    			}      
    			attrs.put(attr);
    			ldap.add(rdn, attrs);
			}
			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    //重置密码
	public String resetUserPass() throws BusinessException {
		String ldapflag = PropUtil.getValue("flag","quartz_service","0");
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(
				request, "USER0_");
		try {
			entity_user = QueryParamUtil.StringToDate(entity_user);
			if (entity_user.get("USER_PWD") != null) {
				entity_user.put("USER_PWD", Encipher
						.EncodePasswd((String) entity_user.get("USER_PWD")));
			}
			if (entity_user.get("USER_PWD_RESET") != null
					&& entity_user.get("USER_PWD_RESET").toString().equals("1")) {
				entity_user.put("USER_PWD", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service","0000")));
				System.out.println("--------------"+PropUtil.getValue("userDefaultPass","quartz_service","0000"));
				entity_user.remove("USER_PWD_RESET");
			}

			String userids = (String) entity_user.get("USER_ID");
			String usernames = (String) entity_user.get("USER_NAME");
			String[] userid = userids.split("\\,");
			String[] username = usernames.split("\\,");
			int i = 0;
			for (String string : userid) {
				String name = username[i];
				Map<String, Object> userMap = new HashMap<String, Object>();
				userMap.put("USER_ID", string);
				userMap.put("USER_PWD", entity_user.get("USER_PWD").toString());
				System.out.println("---------pass"+ entity_user.get("USER_PWD").toString());
				userMap.put("USER_NAME", name);
				business.update_user(userMap);
				// 操作日志
				SystemOpeBusiness sysbusiness = BusinessManager
						.getBusiness(SystemOpeBusiness.class);
				Map<String, Object> entity = new HashMap<String, Object>();
				entity.putAll(userMap);
				sysbusiness.insert_logBusiness("resetUserPass", "" + entity,
						"重置人员密码", string, (String) entity.get("USER_NAME"),
						"JW_APPS_UICM_USER_INFO");
				i++;
				//ldap同步操作哦
				if(ldapflag.equals("1")){
					Ldap ldap = Factory.createInstance();
					ldap.connect();
					String searchFilter = "uid=" + string;
					System.out.println("-----uid"+string);
					String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
					List<Map<String, Object>> result = ldap.searchAll(searchFilter, searchBase, null);
					String rdn = result.get(0).get("rdn") + "," + searchBase;
					System.out.println("---------rdn"+rdn);
					String pass = Sha1.SHA1(PropUtil.getValue("userDefaultPass","quartz_service","2222"));
					ldap.update(rdn, "userPassword", pass);
				}
			}
			//
			jsonObject.putAll(Status.getStatus(Status.PASS_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.PASS_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String updateUser() throws BusinessException {

		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(
				request, "USER0_");
		Map<String, Object> entity_account = RequestUtils.getUpdateFieldMap(
				request, "ACCOU_");
		Map<String, Object> entity_ext = RequestUtils.getUpdateFieldMap(
				request, "EXT00_");
		Map<String, Object> entity_field = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String pushflag = PropUtil.getValue("pushflag","quartz_service","0");
		String ldapflag = PropUtil.getValue("flag","quartz_service","0");
		try {
			//排序
			String is_orders = (String) entity_field.get("IS_ORDER");
			String is_order[] = is_orders.split("\\_");
			Integer a = Integer.parseInt(is_order[0]);
			Integer b = Integer.parseInt(is_order[2]);
			int maxrderid =  business.list_max_order(null);
			if(b>maxrderid){
				b=maxrderid;
			}else if(b<=0){
				b=1;
			}
			String is_swith = is_order[1];
			List<Map<String, Object>> update_unit_data = UserSetOrder(a,b,is_swith);
			if(update_unit_data.size()>0){
				for(Map<String, Object> udata : update_unit_data){
					business.update_user_account(udata);
				}
			}
			//
			entity_user = QueryParamUtil.StringToDate(entity_user);
			entity_account = QueryParamUtil.StringToDate(entity_account);
			entity_ext = QueryParamUtil.StringToDate(entity_ext);
			String userid = (String) entity_user.get("USER_ID");
			entity_account.put("USER_ID", userid);
			entity_ext.put("USER_ID", userid);
			if (entity_user.get("USER_PWD") != null) {
				entity_user.put("USER_PWD", Encipher
						.EncodePasswd((String) entity_user.get("USER_PWD")));
			}
			if (entity_user.get("USER_PWD_RESET") != null
					&& entity_user.get("USER_PWD_RESET").toString().equals("1")) {
				entity_user.put("USER_PWD", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service","0000")));
				entity_user.remove("USER_PWD_RESET");
			}
			business.update_user(entity_user);
			business.update_user_account(entity_account);
			business.update_user_ext(entity_ext);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager
					.getBusiness(SystemOpeBusiness.class);
			Map<String, Object> entity = new HashMap<String, Object>();
			entity.putAll(entity_user);
			entity.putAll(entity_account);
			entity.putAll(entity_ext);
			sysbusiness.insert_logBusiness("updateUser", "" + entity, "修改人员记录",
					userid, (String) entity.get("USER_NAME"),
					"JW_APPS_UICM_USER_INFO");
			//
			// 人员推送
			if(pushflag.equals("1")){
				Map<String, Object> p_user_query = new HashMap<String, Object>();
				p_user_query.put("USER_ID", entity_user.get("USER_ID"));
				List<Map<String, Object>> p_user = business.list_user(p_user_query);
				if (p_user.size() > 0) {
					sysbusiness.insert_logBusiness("pushUpdateUser", "" + entity,
							"推送修改人员记录", userid, (String) entity.get("USER_NAME"),
							"JW_APPS_UICM_PUSH");
					ThreadUtil thread = new ThreadUtil(QueryParamUtil
							.DateToString(p_user.get(0)));
					thread.start();
				}
			}	
			//ldap同步操作
			if(ldapflag.equals("1")){
				//如果离职则删除
				Ldap ldap = Factory.createInstance();
				ldap.connect();
				if(entity_account.get("LEAVE_FLAG").equals("1")){
					//删除
					String searchFilter = "uid=" + userid;
					System.out.println("---uid"+userid);
					String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
					List<Map<String, Object>> result = ldap.searchAll(searchFilter, searchBase, null);
					System.out.println("-----rest"+result);
					String rdn = result.get(0).get("rdn") + "," + searchBase;
					ldap.delete(rdn);
				}else{
					String parentid = (String) entity_account.get("UNIT_ID");
					System.out.println("--------addUNIT_ID" + parentid);
					String searchFilter = "uid=" + userid;
					String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
					List<Map<String, Object>> result = ldap.searchAll(searchFilter, searchBase, null);
					System.out.println("-----------stststs"+result.get(0).get("st"));
					if(result.get(0).get("st").equals(parentid)){
						String rdn = result.get(0).get("rdn") + "," + searchBase;
						System.out.println("---------rdn"+rdn);
						Map<String, Object> list = business.list_user_ldap_single(userid);
						Map<String, Object> mapuser = new HashMap<String, Object>();
						mapuser.put("description", list.get("USER_NAME"));
						String pass = Sha1.SHA1(Encipher.DecodePasswd((String) list.get("USER_PWD")));
						mapuser.put("userPassword", pass);
						if(list.get("USER_SEX").equals("1")){
							mapuser.put("usersex", "男");
	        			}else if(list.get("USER_SEX").equals("2")){
	        				mapuser.put("usersex", "女");
	        			}
						mapuser.put("employeeNumber", list.get("ID_NUMBER"));
						mapuser.put("ou", list.get("UNIT_NAME"));
						String st = (String)list.get("UNIT_ID");
	        			mapuser.put("st", st);
						if(!(list.get("MOBILE") == null)){
							mapuser.put("mobile", list.get("MOBILE"));
	        			}
	        			if(!(list.get("EMAIL") == null)){
	        				mapuser.put("mail", list.get("EMAIL"));
	        			}
	        			if(!(list.get("CARD_ID") == null)){
	        				mapuser.put("idcard", list.get("CARD_ID"));
	        			}
	                    if(!(list.get("TELEPHONE") == null)){
	                    	mapuser.put("telephoneNumber", list.get("TELEPHONE"));	
	        			}  
	                    for(Map.Entry<String, Object> entry : mapuser.entrySet()){
							ldap.update(rdn, entry.getKey(), entry.getValue());
						}
					}else{		
						String s = "uid=" + userid;
						String searchBase1 = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
						List<Map<String, Object>> resultuser = ldap.searchAll(s, searchBase1, null);
						String rdn1 = resultuser.get(0).get("rdn") + "," + searchBase;
						System.out.println("------rdn1"+rdn1);
						ldap.delete(rdn1);
						Map<String, Object> list = business.list_user_ldap_single(userid);
						System.out.println("-------list"+list);
						String searchFilter1 = "ou=" + list.get("UNIT_ID");
						List<Map<String, Object>> result1 = ldap.searchAll(searchFilter1, searchBase1, null);
						String rdn = "uid=" + userid + "," + result1.get(0).get("rdn") + "," + searchBase;
						System.out.println("-------rdn"+rdn);
						String objectClass = "inetOrgPerson";
		    			Attribute attr = new BasicAttribute("objectClass");
		    			attr.add(objectClass);
		    			Attributes attrs = new BasicAttributes();
		    			attrs.put(attr);
		    			attrs.put("uid", list.get("USER_ID"));
						attrs.put("description", list.get("USER_NAME"));
						String pass = Sha1.SHA1(Encipher.DecodePasswd((String) list.get("USER_PWD")));
		    			attrs.put("userPassword", pass);
		    			if(list.get("USER_SEX").equals("1")){
		    				attrs.put("usersex", "男");
		    			}else if(list.get("USER_SEX").equals("2")){
		    				attrs.put("usersex", "女");
		    			}
		    			//attrs.put("usersex", map.get("USER_SEX"));
		    			attrs.put("employeeNumber", list.get("ID_NUMBER"));
		    			attrs.put("ou", list.get("UNIT_NAME"));
		    			attrs.put("cn", list.get("USER_ID"));
		    			attrs.put("sn", list.get("USER_ID"));
		    			System.out.println("------st"+list.get("UNIT_ID"));
		    			String st = (String)list.get("UNIT_ID");
		    			attrs.put("st", st);
		    			if(!(list.get("MOBILE") == null)){
		    				attrs.put("mobile", list.get("MOBILE"));
		    			}
		    			if(!(list.get("EMAIL") == null)){
		    				attrs.put("mail", list.get("EMAIL"));
		    			}
		    			if(!(list.get("CARD_ID") == null)){
		    				attrs.put("idcard", list.get("CARD_ID"));
		    			}
		                if(!(list.get("TELEPHONE") == null)){
		                	attrs.put("telephoneNumber", list.get("TELEPHONE"));	
		    			}      
		    			attrs.put(attr);
		    			ldap.add(rdn, attrs);
					}
				}
				
			}
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String deleteUser() throws BusinessException {

		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		String deletekey = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String pushflag = PropUtil.getValue("pushflag","quartz_service","0");
		String ldapflag = PropUtil.getValue("flag","quartz_service","0");
		try {
			List<Map<String, Object>> list_name_user = business.list_name_user(ListKey);
			// 人员推送
			List<Map<String, Object>> delete_user = new ArrayList<Map<String, Object>>();
			if (entity.get("USER_ID") != null&& !entity.get("USER_ID").toString().equals("")) {
				String[] userid = entity.get("USER_ID").toString().split("\\,");
				for (String string : userid) {
					entity = new HashMap<String, Object>();
					entity.put("USER_ID", string);
					entity.put("DELETE_FLAG", '1');
					business.update_user_account(entity);
					//权限删除
					operateGroup.deleteGroup(string);
					// 人员推送
					List<Map<String, Object>> delete_user1 = business.list_user(entity);
					for (Map<String, Object> map : delete_user1) {
						delete_user.add(map);
					}
				}
			}
			// business.delete_user(ListKey);
			// business.delete_user_account(ListKey);
			// business.delete_user_ext(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager
					.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteUser", "" + ListKey,
					"删除人员记录", ListKey.toString(), list_name_user.toString(),
					"JW_APPS_UICM_USER_INFO");
			//人员推送
            if(pushflag.equals("1")){
            	if (delete_user.size() > 0) {
    				for (Map<String, Object> map : delete_user) {
    					ThreadUtil thread = new ThreadUtil(QueryParamUtil
    							.DateToString(map));
    					thread.start();
    				}
    				// pushData(QueryParamUtil.DateToString(delete_user.get(0)));
    				sysbusiness.insert_logBusiness("pushDeleteUser", "" + ListKey,
    						"推送删除人员记录", ListKey.toString(), list_name_user
    								.toString(), "JW_APPS_UICM_PUSH");
    			}
            }	
			//ldap同步删除
			if(ldapflag.equals("1")){
				for(String useruuid : ListKey){
					Ldap ldap = Factory.createInstance();
					ldap.connect();
					String searchFilter = "uid=" + useruuid;
					String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
					List<Map<String, Object>> result = ldap.searchAll(searchFilter, searchBase, null);
					String rdn = result.get(0).get("rdn") + "," + searchBase;
					ldap.delete(rdn);
				}
			}
			jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String MoveOutUser() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		MoveBusiness business_move = BusinessManager
				.getBusiness(MoveBusiness.class);
		String deletekey = RequestUtils.getString(request, "deletekey");
		String ldapflag = PropUtil.getValue("flag","quartz_service","0");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			Map<String, Object> moveEntity = new HashMap<String, Object>();
			String[] userids = entity.get("USER_ID").toString().split("\\,");
			for (String string : userids) {
				moveEntity = new HashMap<String, Object>();
				moveEntity.put("USERID", string);
				moveEntity.put("OUT_UNIT_UUID", entity.get("UNIT_ID"));
				moveEntity.put("OUT_AUDIT_USER", SessionUtil.getCode());
				moveEntity.put("OUT_AUDIT_TIME", new Date());
				moveEntity.put("OUT_AUDIT_STATUS", '1');
				business_move.insert_move(moveEntity);
				Map<String, Object> entitymap = new HashMap<String, Object>();
				entitymap.put("USER_ID", string);
				entitymap.put("DELETE_FLAG", '1');
				entitymap.put("UNIT_ID", entity.get("UNIT_ID").toString());
				business.update_user_account(entitymap);
				// 操作日志
				String userid = (String) moveEntity.get("USERID");
				List<String> listkey = new ArrayList<String>();
				listkey.add(userid);
				List<Map<String, Object>> list_name_user = business
						.list_name_user(listkey);
				SystemOpeBusiness sysbusiness = BusinessManager
						.getBusiness(SystemOpeBusiness.class);
				sysbusiness.insert_logBusiness("MoveOutUser", "" + moveEntity,
						"调出人员记录", (String) moveEntity.get("UUID"),
						(String) list_name_user.get(0).get("USER_NAME"),
						"JW_APPS_UICM_USER_MOVE_INFO");
			}
			//LDAP同步删除
			if(ldapflag.equals("1")){
				for(String useruuid : userids){
					Ldap ldap = Factory.createInstance();
					ldap.connect();
					String searchFilter = "uid=" + useruuid;
					String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
					List<Map<String, Object>> result = ldap.searchAll(searchFilter, searchBase, null);
					String rdn = result.get(0).get("rdn") + "," + searchBase;
					ldap.delete(rdn);
				}
			}
			jsonObject.putAll(Status.getStatus(Status.MOVE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.MOVE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String MoveInUser() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		MoveBusiness business_move = BusinessManager
				.getBusiness(MoveBusiness.class);
		String deletekey = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			if (entity.get("USERID_1") != null) {
				String userid = (String) entity.get("USERID_1");
				String[] userids = userid.split(",");

				String uuids = (String) entity.get("UUIDS");
				String[] uuidss = uuids.split(",");
				Date d = new Date();

				for (String unituser : userids) {
					Map<String, Object> entityIn = new HashMap<String, Object>();
					entityIn.put("USER_ID", unituser);
					entityIn.put("UNIT_ID", entity.get("UNIT_ID"));
					entityIn.put("DELETE_FLAG", '0');
					business.update_user_account(entityIn);
					// 人员推送
					List<Map<String, Object>> move_user = business
							.list_user(entityIn);
					if (move_user.size() > 0) {
						// pushData(QueryParamUtil.DateToString(move_user.get(0)));
						ThreadUtil thread = new ThreadUtil(QueryParamUtil
								.DateToString(move_user.get(0)));
						thread.start();
					}
					//
				}
				for (String m_uuid : uuidss) {
					Map<String, Object> entityMove = new HashMap<String, Object>();
					entityMove.put("UUID", m_uuid);
					entityMove.put("IN_AUDIT_USER", SessionUtil.getCode());
					entityMove.put("IN_AUDIT_TIME", d);
					entityMove.put("IN_AUDIT_STATUS", '1');
					entityMove.put("MOVE_STATUS", '5');
					entityMove.put("MOVE_TIME", d);
					business_move.update_move(entityMove);

					// 操作日志
					Map<String, Object> query = new HashMap<String, Object>();
					query.put("UUID", m_uuid);
					List<Map<String, Object>> list_m = business_move
							.list_move(query);
					SystemOpeBusiness sysbusiness = BusinessManager
							.getBusiness(SystemOpeBusiness.class);
					sysbusiness.insert_logBusiness("MoveInUser", ""
							+ list_m.get(0), "调入人员记录", (String) entityMove
							.get("UUID"), (String) list_m.get(0).get(
							"APPLY_USER_NAME"), "JW_APPS_UICM_USER_MOVE_INFO");
					//
				}
			}
			jsonObject.putAll(Status.getStatus(Status.MOVE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.MOVE_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String BatchMoveInUser() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			if (entity.get("OLD_UNIT_ID") != null) {
				// 找出所有子级单位
				Map<String, Object> query = new HashMap<String, Object>();
				UnitBusiness businessUnit = BusinessManager.getBusiness(UnitBusiness.class);
				List<Map<String, Object>> listData = businessUnit.list_unit(null);
				List<String> list = EasyuiJsonUtils.getParentsData(listData,(String) entity.get("OLD_UNIT_ID"));
				query.put("UNIT_ID_IS_PARENT", list);
				//
				query = QueryParamUtil.StringToDate(query);
				List<Map<String, Object>> listUser = business.list_user(query);
				List<String> listUserKey = new ArrayList<String>();
				for (Map<String, Object> u : listUser) {
					listUserKey.add((String) u.get("USER_ID"));
				}
				entity.put("USER_LIST", listUserKey);
				if (listUserKey.size() > 0 && entity.get("NEW_UNIT_ID") != null) {
					business.update_batch_user_unit(entity);

					// 操作日志
					// Map<String,Object> query = new HashMap<String,Object>();
					// query.put("UUID", m_uuid);
					// List<Map<String, Object>> list_m =
					// business_move.list_move(query);
					// SystemOpeBusiness sysbusiness =
					// BusinessManager.getBusiness(SystemOpeBusiness.class);
					// sysbusiness.insert_logBusiness("MoveInUser",
					// ""+list_m.get(0),"调入人员记录",(String)entityMove.get("UUID"),(String)list_m.get(0).get("APPLY_USER_NAME"),"JW_APPS_UICM_USER_MOVE_INFO");
					//
				}

			}
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
    //密码修改
	public String modifyPass() throws BusinessException {
		String ldapflag = PropUtil.getValue("flag","quartz_service","0");
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(
				request, "USER0_");
		Map<String, Object> query = new HashMap<String, Object>();
		query.put("USER_ID", SessionUtil.getCode());
		List<Map<String, Object>> listData = business.list_user(query);
		String oldpass = (String) entity_user.get("OLDPASS");
		if (oldpass == null) {
			oldpass = "";
		}
		String newpass = (String) entity_user.get("NEWPASS");
		String againnewpass = (String) entity_user.get("AGAINNEWPASS");
		String datapass = (String) listData.get(0).get("USER_PWD");
		if (StringUtils.equals(oldpass, Encipher.DecodePasswd(datapass)) == false) {
			jsonObject.putAll(Status.getStatus(Status.PASS_OLD_ERR));
		} else {
			if (StringUtils.equals(newpass, againnewpass) == false) {
				jsonObject.putAll(Status.getStatus(Status.PASS_NEW_ERR));
			} else {
				if (newpass == null) {
					newpass = "";
				}
				query.put("USER_PWD", Encipher.EncodePasswd(newpass));
				try {
					business.update_user(query);

					// 操作日志

					SystemOpeBusiness sysbusiness = BusinessManager
							.getBusiness(SystemOpeBusiness.class);
					sysbusiness.insert_logBusiness("modifyPass", "" + query,
							"人员密码修改记录", (String) query.get("USER_ID"),
							(String) listData.get(0).get("USER_NAME"),
							"JW_APPS_UICM_USER_INFO");
					
					//ldap同步操作
					if(ldapflag.equals("1")){
						Ldap ldap = Factory.createInstance();
						ldap.connect();
						String searchFilter = "uid=" + query.get("USER_ID");
						System.out.println("-----uid"+query.get("USER_ID"));
						String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
						List<Map<String, Object>> result = ldap.searchAll(searchFilter, searchBase, null);
						String rdn = result.get(0).get("rdn") + "," + searchBase;
						System.out.println("---------rdn"+rdn);
						//String pass = Sha1.SHA1(Encipher.DecodePasswd(newpass));
						String pass = Sha1.SHA1(newpass);
						ldap.update(rdn, "userPassword", pass);
					}
					jsonObject.putAll(Status.getStatus(Status.PASS_OK));
				} catch (Exception e) {
					jsonObject.putAll(Status.getStatus(Status.PASS_ERR));
					e.printStackTrace();
				}
			}
		}

		return "json";
	}

	public String viewUserLog() throws BusinessException {

		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(
				request, "USER0_");
		try {
			entity_user = QueryParamUtil.StringToDate(entity_user);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager
					.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("viewUserLog", "" + entity_user,
					"查看人员记录", (String) entity_user.get("USER_ID"),
					(String) entity_user.get("USER_NAME"),
					"JW_APPS_UICM_USER_INFO");
			//
			jsonObject.putAll(Status.getStatus(Status.LOG_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.LOG_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String uploadUser() throws BusinessException {
		String upPath = request.getSession().getServletContext().getRealPath(
				"/uploadFile/apps/user");
		super.setUserUploadFilePath(upPath);
		return super.upload();
	}
	
	public String updateUserInitOrder() throws BusinessException {

		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			entity = QueryParamUtil.StringToDate(entity);
			List<Map<String, Object>> p_unit_data = business.list_uuid_order(entity);
			int i=0;
			for(Map<String, Object> map : p_unit_data){
				map.put("ORDER_ID", i++);
				business.update_user_account(map);
			}
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateUser", "" + entity, "初始化人员排序号",(String) entity.get("USER_ID"), (String) entity.get("USER_NAME"),"JW_APPS_UICM_USER_INFO");
			//
			jsonObject.putAll(Status.getStatusSuccessMessage("排序初始化完成"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("排序初始化失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	public String updateUserSetOrder() throws BusinessException {

		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			entity = QueryParamUtil.StringToDate(entity);
			String is_orders = (String) entity.get("IS_ORDER");
			String is_order[] = is_orders.split("\\_");
			Integer a = Integer.parseInt(is_order[0]);
			Integer b = Integer.parseInt(is_order[2]);
			String is_swith = is_order[1];
			List<Map<String, Object>> update_user_data = UserSetOrder(a,b,is_swith);
			if(update_user_data.size()>0){
				for(Map<String, Object> udata : update_user_data){
					business.update_user_account(udata);
				}
			}
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateUser", "" + entity, "更换人员排序号",(String) entity.get("USER_ID"), (String) entity.get("NAME"),"JW_APPS_UICM_USER_INFO");
			//
			jsonObject.putAll(Status.getStatusSuccessMessage("更换人员排序完成",String.valueOf(b)));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("更换人员排序失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	private List<Map<String, Object>> UserSetOrder(Integer a,Integer b,String is_swith){
		List<Map<String, Object>> update_user_data = new ArrayList<Map<String, Object>>();
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> query = new HashMap<String,Object>();
		if(a>b){
			query.put("START_ORDER", b);
			query.put("END_ORDER", a);
			List<Map<String, Object>> p_user_data = business.list_user(query);
			for(Map<String, Object> data:p_user_data){
				Map<String, Object> update_user_map = new HashMap<String, Object>();
				Integer s_order = null;
				if(data.get("ORDER_ID") instanceof BigDecimal){
					s_order = ((BigDecimal) data.get("ORDER_ID")).intValue();
				}else{
					s_order = (Integer) data.get("ORDER_ID");
				}
				update_user_map.put("USER_ID", data.get("USER_ID"));
				if(is_swith.equals("up")){
					if(s_order>=(b+0) && s_order<=(a-1)){
						s_order +=1;
						update_user_map.put("ORDER_ID", s_order);
					}else if(s_order==(a+0)){
						update_user_map.put("ORDER_ID", b);
					}
					update_user_data.add(update_user_map);
				}else if(is_swith.equals("down")){
					if(s_order>=(b+1) && s_order<=(a-1)){
						s_order +=1;
						update_user_map.put("ORDER_ID", s_order);
					}else if(s_order==(a+0)){
						update_user_map.put("ORDER_ID", b+1);
					}
					update_user_data.add(update_user_map);
				}else if(is_swith.equals("exchange")){
					if(s_order == (a+0)){
						update_user_map.put("ORDER_ID", b);
					}else if(s_order == (b+0)){
						update_user_map.put("ORDER_ID", a);
					}
					update_user_data.add(update_user_map);
				}
			}
			
		}else if(a<b){
			query.put("START_ORDER", a);
			query.put("END_ORDER", b);
			List<Map<String, Object>> p_user_data = business.list_user(query);
			for(Map<String, Object> data:p_user_data){
				Map<String, Object> update_user_map = new HashMap<String, Object>();
				Integer s_order = null;
				if(data.get("ORDER_ID") instanceof BigDecimal){
					s_order = ((BigDecimal) data.get("ORDER_ID")).intValue();
				}else{
					s_order = (Integer) data.get("ORDER_ID");
				}
				update_user_map.put("USER_ID", data.get("USER_ID"));
				if(is_swith.equals("up")){
					if(s_order>=(a+1) && s_order<=(b-1)){
						s_order -=1;
						update_user_map.put("ORDER_ID", s_order);
					}else if(s_order==(a+0)){
						update_user_map.put("ORDER_ID", b-1);
					}
					update_user_data.add(update_user_map);
				}else if(is_swith.equals("down")){
					if(s_order>=(a+1) && s_order<=(b+0)){
						s_order -=1;
						update_user_map.put("ORDER_ID", s_order);
					}else if(s_order==(a+0)){
						update_user_map.put("ORDER_ID", b);
					}
					update_user_data.add(update_user_map);
				}else if(is_swith.equals("exchange")){
					if(s_order == (a+0)){
						update_user_map.put("ORDER_ID", b);
					}else if(s_order == (b+0)){
						update_user_map.put("ORDER_ID", a);
					}
					update_user_data.add(update_user_map);
				}
			}
			
		}
		return update_user_data;
	}

	private class ThreadUtil extends Thread {

		private Map<String, Object> map = null;
		private Java_tool jt = new Java_tool();

		public ThreadUtil(Map<String, Object> map) {
			if (map == null)
				map = new HashMap<String, Object>();
			this.map = map;

		}

		private void pushData(Map<String, Object> data) {
			PushDataUtils pd = new PushDataUtils();
			String jsondata = pd.getPushUserData(data);
			//是否需要推送人员密码（0不推送，1推送）
			String passflag = PropUtil.getValue("passflag","quartz_service","0");
			if(passflag.equals("1")){
				//推送密码
				UserBusiness userBusiness = BusinessManager.getBusiness(UserBusiness.class);
				Map<String, Object> mapid = new HashMap<String, Object>();
				mapid.put("ID_NUMBER", data.get("ID_NUMBER"));
				Map<String, Object> mappass = userBusiness.listIdNumberUser(mapid);
				data.put("USER_PWD", Encipher.DecodePasswd(mappass.get("USER_PWD").toString()));
				jsondata = pd.getPushUserDataWithPass(data);
			}
			System.out.println("--------data"+data);
			//获取要推送人员数据的应用
			String loginuser_depart = AuthenticateUtil.getEndpoint("loginuser_depart");//提取所有应用系统的接口数据
			String pushdata_default = AuthenticateUtil.getEndpoint("pushdata_default");//人员和单位未选择要推送应用时是否全推1=全推0=不推
			SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
			Map<String, Object> query = new HashMap<String, Object>();
			query.put("ISPUSH", "1");
			query.put("EMDEPART", loginuser_depart);
			List<Map<String, Object>> s_user = business.listLoginServiceUserInfo(query);
			System.out.println("---------s_user"+s_user);
			//提取当前人员数据要推送的所有应用ID，如为空则提取是否全推的开关值，不为空则过滤s_user
			List<Map<String, Object>> s_user_choice = new ArrayList<Map<String, Object>>();
			
			//比对往s_user_choice加数据
			PushDataBusiness pushdata_business = BusinessManager.getBusiness(PushDataBusiness.class);
			Map<String, Object> query_use = new HashMap<String, Object>();
			query_use.put("PUSH_DATA_ID", data.get("USER_ID"));
			query_use.put("TYPE", "1");
			List<Map<String, Object>> s_user_use = pushdata_business.list_pushApp(query_use);
			if(s_user_use.size()>0){
			  for(Map<String, Object> n:s_user){
				int i = 0;
				for(Map<String, Object> m:s_user_use){
					if(StringUtils.equalsIgnoreCase((String)m.get("CLIENT_CODE"), (String)n.get("CODE"))){
						i=0;
						break;
					}else{
						i++;
					}
				}
				if(i == 0){
					s_user_choice.add(n);
				}
			  }
			}
			//
			
			if(s_user_choice.size()==0 && (pushdata_default!=null && pushdata_default.trim().equals("1"))){
				s_user_choice.addAll(s_user);
			}
			//
			for (Map<String, Object> s : s_user_choice) {
				if (s.get("PUSH_URL") == null
						|| s.get("PUSH_URL").toString().trim().length() == 0) {
					System.out.println("未注册人员推送地址!");
					continue;
				}
				//推送加密字段判断
				String jsondata1 = Native2AsciiUtils.native2Ascii(jsondata);
				if(s.get("PUSH_ENCRYPT") == null || s.get("PUSH_ENCRYPT").toString().equals("0")){
					//不加密
					jsondata1 = Native2AsciiUtils.native2Ascii(jsondata);
				}else if (s.get("PUSH_ENCRYPT").toString().equals("1")){
					//base64加密
					jsondata1 = new BASE64Encoder().encode(Native2AsciiUtils.native2Ascii(jsondata).getBytes());
				}else if (s.get("PUSH_ENCRYPT").toString().equals("2")){
					//特有加密
					try {
						jsondata1 = PbeEncrypt.encrypt(Native2AsciiUtils.native2Ascii(jsondata), s.get("EMID").toString());
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
				httpClientPostData myhttp = new httpClientPostData();
				String ret = myhttp
						.requestSystem((String) s.get("PUSH_LOGIN_URL"),
								(String) s.get("PUSH_NAME"), (String) s
										.get("PUSH_PASS"), jsondata1, (String) s
										.get("PUSH_URL"), (String) s
										.get("PUSH_ENCODE"));
				System.out.println(ret);
				Map<String, Object> m = null;
				if (ret != null && ret.trim().length() > 0) {
					m = jsonFormatMap.getMap(ret);
				}
				if (m != null && m.get("NAME") != null
						&& Integer.parseInt((String) m.get("NAME")) > 0) {
					System.out.println("用户[" + s.get("EMNAME") + "]推送成功!");
					Map<String, Object> pushData = new HashMap<String, Object>();
					pushData.put("PUSH_LOGIN_URL", s.get("PUSH_LOGIN_URL"));
					pushData.put("PUSH_NAME", s.get("PUSH_NAME"));
					pushData.put("PUSH_PASS", s.get("PUSH_PASS"));
					pushData.put("PUSH_URL", s.get("PUSH_URL"));
					pushData.put("ISFINISH", "1");
					pushData.put("PUSH_ENCODE", s.get("PUSH_ENCODE"));
					pushData.put("CLIENT_CODE", s.get("CODE"));
					pushData.put("PUSH_DATA_ID", data.get("USER_ID"));
					pushData.put("CREATOR_ID", loginuserCode);
					pushData.put("TYPE", "1");// 类型:1=人员 2=单位

					PushDataBusiness pushData_business = BusinessManager
							.getBusiness(PushDataBusiness.class);
					Map<String, Object> p_query = new HashMap<String, Object>();
					p_query.put("CLIENT_CODE", pushData.get("CLIENT_CODE"));
					p_query.put("PUSH_DATA_ID", pushData.get("PUSH_DATA_ID"));
					List<Map<String, Object>> p_query_data = pushData_business
							.list_pushData(p_query);
					if (p_query_data == null || p_query_data.size() == 0) {
						pushData_business.insert_pushData(pushData);
					} else {
						pushData.put("UUID", p_query_data.get(0).get("UUID"));
						pushData_business.update_pushData(pushData);
					}

				} else {
					System.out
							.println("用户["
									+ s.get("EMNAME")
									+ "]推送失败,失败的数据将提交给作业[RemotePushUserJob],在调度任务中作定时推送!");
					// 把数据存到推送失败的临时表里
					Map<String, Object> pushData = new HashMap<String, Object>();
					pushData.put("PUSH_LOGIN_URL", s.get("PUSH_LOGIN_URL"));
					pushData.put("PUSH_NAME", s.get("PUSH_NAME"));
					pushData.put("PUSH_PASS", s.get("PUSH_PASS"));
					pushData.put("PUSH_URL", s.get("PUSH_URL"));
					pushData.put("PUSH_ENCODE", s.get("PUSH_ENCODE"));
					pushData.put("CLIENT_CODE", s.get("CODE"));
					pushData.put("PUSH_DATA_ID", data.get("USER_ID"));
					pushData.put("CREATOR_ID", loginuserCode);
					pushData.put("TYPE", "1");// 类型:1=人员 2=单位

					PushDataBusiness pushData_business = BusinessManager
							.getBusiness(PushDataBusiness.class);
					Map<String, Object> p_query = new HashMap<String, Object>();
					p_query.put("CLIENT_CODE", pushData.get("CLIENT_CODE"));
					p_query.put("PUSH_DATA_ID", pushData.get("PUSH_DATA_ID"));
					List<Map<String, Object>> p_query_data = pushData_business
							.list_pushData(p_query);
					if (p_query_data == null || p_query_data.size() == 0) {
						pushData_business.insert_pushData(pushData);
					} else {
						pushData.put("UUID", p_query_data.get(0).get("UUID"));
						pushData_business.update_pushData(pushData);
					}

				}
			}
		}

		public void run() {
			System.out.println("同步人员开始,开始时间:" + jt.now_datetime());
			pushData(map);
			System.out.println("同步人员结束,结束时间:" + jt.now_datetime());
		}

	}
	//批量推送
	public String pushUserRow(){
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		String deletekey = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		for(String str : ListKey){
			Map<String, Object> p_user_query = new HashMap<String, Object>();
			p_user_query.put("USER_ID", str);
			List<Map<String, Object>> p_user = business.list_user(p_user_query);
			UnitBusiness unitBusiness = BusinessManager.getBusiness(UnitBusiness.class);
			List<Map<String, Object>> list = unitBusiness.list_unit_ldap();       
			for(Map<String, Object> data : p_user){
				Map<String, Object> map = unitBusiness.list_unit_ldap_ou((String)data.get("UNIT_ID"));
				String unitPath = TakeUnitsUtils.getp(list, (String)data.get("UNIT_ID"));
				String[] unituuid = unitPath.split(",");
				String unitPath1 = (String) map.get("UNIT_ID");
				for(int i = 0 ; i < unituuid.length - 1 ; i ++){
					System.out.println("--------unituuid"+unituuid[i]);
					Map<String, Object> listunit = unitBusiness.list_unit_ldap_ou(unituuid[i]);
					unitPath1 = unitPath1 + "," + listunit.get("UNIT_ID");
				}
				System.out.println("-------unitpah1"+ unitPath1);
				data.put("UNIT_PATH", unitPath1);
				ThreadUtil th = new ThreadUtil(data);
				th.start();
				}
		}
		return "json";
	}
	//批量推送新版
	public String pushUserU() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		System.out.println("推送开始......");
		String key = (String) entity.get("CODE");
		System.out.println("推送用户ID:" + key);
		List<String> ListKey = QueryParamUtil.StringToList(key);
		String cilentid = (String) entity.get("CLIENT_CODE");
		System.out.println("----------cilentid" + entity.get("CLIENT_CODE"));
		List<String> Listcilentid = QueryParamUtil.StringToList(cilentid);
		List<Map<String, Object>> listclient = new ArrayList<Map<String,Object>>();
		for(String strid : Listcilentid){
			PushDataBusiness business2 = BusinessManager.getBusiness(PushDataBusiness.class);
			listclient = business2.list_pushData_one(strid);
			for(String str : ListKey){
				Map<String, Object> p_user_query = new HashMap<String, Object>();
				p_user_query.put("USER_ID", str);
				List<Map<String, Object>> p_user = business.list_user(p_user_query);
				UnitBusiness unitBusiness = BusinessManager.getBusiness(UnitBusiness.class);
				List<Map<String, Object>> list = unitBusiness.list_unit_ldap();
				for(Map<String, Object> url : listclient){
					//System.out.println("--------push"+ url.get("PUSH_ENCRYPT"));
					for(Map<String, Object> data : p_user){
						Map<String, Object> map = unitBusiness.list_unit_ldap_ou((String)data.get("UNIT_ID"));
						String unitPath = TakeUnitsUtils.getp(list, (String)data.get("UNIT_ID"));
						String[] unituuid = unitPath.split(",");
						String unitPath1 = (String) map.get("UNIT_ID");
						for(int i = 0 ; i < unituuid.length - 1 ; i ++){
							Map<String, Object> listunit = unitBusiness.list_unit_ldap_ou(unituuid[i]);
							unitPath1 = unitPath1 + "," + listunit.get("UNIT_ID");
						}
						data.put("UNIT_PATH", unitPath1);
						/*ThreadUtil th = new ThreadUtil(data);
						System.out.println("------data"+ data);
						th.start();*/
						//操作日志
						SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
						sysbusiness.insert_logBusiness("pushUser", "" + data,
								"推送人员记录", (String)data.get("USER_ID"), (String) data.get("USER_NAME"),
								"JW_APPS_UICM_PUSH");
						PushDataUtils pd = new PushDataUtils();
						String jsondata = pd.getPushUserData(data);
						String passflag = PropUtil.getValue("passflag","quartz_service","0");
						if(passflag.equals("1")){
							//推送密码
							UserBusiness userBusiness = BusinessManager.getBusiness(UserBusiness.class);
							Map<String, Object> mapid = new HashMap<String, Object>();
							mapid.put("ID_NUMBER", data.get("ID_NUMBER"));
							Map<String, Object> mappass = userBusiness.listIdNumberUser(mapid);
							data.put("USER_PWD", Encipher.DecodePasswd(mappass.get("USER_PWD").toString()));
							jsondata = pd.getPushUserDataWithPass(data);
							System.out.println("-------data"+jsondata);
						}
						String jsondata1 = Native2AsciiUtils.native2Ascii(jsondata);
						//推送加密字段判断
						if(url.get("PUSH_ENCRYPT") == null || url.get("PUSH_ENCRYPT").toString().equals("0")){
							//不加密
							jsondata1 = Native2AsciiUtils.native2Ascii(jsondata);
						}else if (url.get("PUSH_ENCRYPT").toString().equals("1")){
							//base64加密
							jsondata1 = new BASE64Encoder().encode(Native2AsciiUtils.native2Ascii(jsondata).getBytes());
						}else if (url.get("PUSH_ENCRYPT").toString().equals("2")){
							//特有加密
							try {
								jsondata1 = PbeEncrypt.encrypt(Native2AsciiUtils.native2Ascii(jsondata), url.get("EMID").toString());
							} catch (Exception e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
						//String jsondata = pd.getPushUserData(data);
						httpClientPostData myhttp = new httpClientPostData();
						String ret = myhttp.requestSystem(
								(String)url.get("PUSH_LOGIN_URL"),
								(String)url.get("PUSH_NAME"),
								(String)url.get("PUSH_PASS"), jsondata1, 
								(String)url.get("PUSH_URL"), 
								(String)url.get("PUSH_ENCODE"));
						System.out.println("输出: 推送的url:"+url.get("PUSH_URL"));
						Map<String, Object> m = null;
						if (ret != null && ret.trim().length() > 0) {
							m = jsonFormatMap.getMap(ret);
						}
						if (m != null && m.get("NAME") != null && Integer.parseInt((String) m.get("NAME")) > 0) {
							System.out.println("用户[" + url.get("EMNAME") + "]推送成功!");
							// 将成功记录插入表
							Map<String, Object> pushData = new HashMap<String, Object>();
							pushData.put("PUSH_LOGIN_URL", url.get("PUSH_LOGIN_URL"));
							pushData.put("PUSH_NAME", url.get("PUSH_NAME"));
							pushData.put("PUSH_PASS", url.get("PUSH_PASS"));
							pushData.put("PUSH_URL", url.get("PUSH_URL"));
							pushData.put("PUSH_ENCODE", url.get("PUSH_ENCODE"));
							pushData.put("CLIENT_CODE", url.get("CODE"));
							pushData.put("PUSH_DATA_ID", data.get("USER_ID"));
							pushData.put("ISFINISH", "1");
							pushData.put("CREATOR_ID", loginuserCode);
							pushData.put("TYPE", "1");// 类型:1=人员 2=单位
                            System.out.println("-------pushdta" + pushData);
							PushDataBusiness pushData_business = BusinessManager.getBusiness(PushDataBusiness.class);
							Map<String, Object> p_query = new HashMap<String, Object>();
							p_query.put("CLIENT_CODE", pushData.get("CLIENT_CODE"));
							p_query.put("PUSH_DATA_ID", pushData.get("PUSH_DATA_ID"));
							List<Map<String, Object>> p_query_data = pushData_business.list_pushData(p_query);
							if (p_query_data == null || p_query_data.size() == 0) {
								pushData_business.insert_pushData(pushData);
							} else {
								pushData.put("UUID", p_query_data.get(0).get("UUID"));
								pushData_business.update_pushData(pushData);
							}
						} else {
							System.out.println("用户["
											+ url.get("EMNAME")
											+ "]推送失败,失败的数据将提交给作业[RemotePushUserJob],在调度任务中作定时推送!");
							// 把数据存到推送失败的临时表里
							Map<String, Object> pushData = new HashMap<String, Object>();
							pushData.put("PUSH_LOGIN_URL", url.get("PUSH_LOGIN_URL"));
							pushData.put("PUSH_NAME", url.get("PUSH_NAME"));
							pushData.put("PUSH_PASS", url.get("PUSH_PASS"));
							pushData.put("PUSH_URL", url.get("PUSH_URL"));
							pushData.put("PUSH_ENCODE", url.get("PUSH_ENCODE"));
							pushData.put("CLIENT_CODE", url.get("CODE"));
							pushData.put("PUSH_DATA_ID", data.get("USER_ID"));
							pushData.put("CREATOR_ID", loginuserCode);
							pushData.put("TYPE", "1");// 类型:1=人员 2=单位
							System.out.println("-------pushdta" + pushData);
							PushDataBusiness pushData_business = BusinessManager.getBusiness(PushDataBusiness.class);
							Map<String, Object> p_query = new HashMap<String, Object>();
							p_query.put("CLIENT_CODE", pushData.get("CLIENT_CODE"));
							p_query.put("PUSH_DATA_ID", pushData.get("PUSH_DATA_ID"));
							List<Map<String, Object>> p_query_data = pushData_business.list_pushData(p_query);
							if (p_query_data == null || p_query_data.size() == 0) {
								pushData_business.insert_pushData(pushData);
							} else {
								pushData.put("UUID", p_query_data.get(0).get("UUID"));
								pushData_business.update_pushData(pushData);
							}

						}
					}
				}
			}
			System.out.println("结束推送......");
			jsonObject.putAll(Status.getStatus(Status.PUSH_OK));
		}
		return "json";
	}
	//ldap全量同步
	public String insertOrUpdateLdapUser() throws BusinessException{
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		List<Map<String, Object>> list = business.list_user_ldap();
		Ldap ldap = Factory.createInstance();
		try {
			ldap.connect();
			System.out.println("ldap全量同步开始.....");
			for(Map<String, Object>map : list){
				System.out.println(map.get("UNIT_ID"));
        		//String searchFilter = "street="+ map.get("UNIT_ID");
				String searchFilter = "ou="+ map.get("UNIT_ID");//user的unit_id对应unit表的uuid
        		String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
        		System.out.println("---------------"+PropUtil.getValue("root","quartz_service","0000"));
        		String searchext = ldap.search(searchFilter, searchBase, null);
        		System.out.println("---------"+searchext);
        		String objectClass = "inetOrgPerson";
    			Attribute attr = new BasicAttribute("objectClass");
    			attr.add(objectClass);
    			Attributes attrs = new BasicAttributes();
    			attrs.put(attr);
    			//String rdn = "uid=" + map.get("USER_NAME")+"("+map.get("ID_NUMBER")+")"+ "," + searchext + "," +searchBase;
    			String rdn = "uid=" + map.get("USER_ID")+ "," + searchext + "," +searchBase;
    			//邮箱正则
    			String check = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    			//电话正则
    			String regex="1([\\d]{10})|((\\+[0-9]{2,4})?\\(?[0-9]+\\)?-?)?[0-9]{7,8}"; 
    			if(!(StringUtils.isEmpty(searchext))){
    				attrs.put("uid", map.get("USER_ID"));
    				attrs.put("description", map.get("USER_NAME"));
    				String pass = Sha1.SHA1(Encipher.DecodePasswd((String) map.get("USER_PWD")));
        			attrs.put("userPassword", pass);
        			if(StringUtils.isNotEmpty((String) map.get("USER_SEX"))){
        				if(map.get("USER_SEX").equals("1")){
            				attrs.put("usersex", "男");
            			}else if(map.get("USER_SEX").equals("2")){
            				attrs.put("usersex", "女");
            			}
        			}	
        			//attrs.put("usersex", map.get("USER_SEX"));
        			attrs.put("employeeNumber", map.get("ID_NUMBER"));
        			attrs.put("ou", map.get("UNIT_NAME"));
        			attrs.put("cn", map.get("USER_ID"));
        			attrs.put("sn", map.get("USER_ID"));
        			String splitst[] = searchext.split(",");
					String st = splitst[0].substring(3);
        			attrs.put("st", st);
        			if(!(map.get("MOBILE") == null)){
        				attrs.put("mobile", map.get("MOBILE"));
        			}
        			if(!(map.get("EMAIL") == null)){
        				if(((String) map.get("EMAIL")).matches(check)){
        					attrs.put("mail", map.get("EMAIL"));
        				}
        			}
        			if(!(map.get("CARD_ID") == null)){
        				attrs.put("idcard", map.get("CARD_ID"));
        			}
                    if(!(map.get("TELEPHONE") == null)){
                    	if(((String) map.get("TELEPHONE")).matches(regex)){
                    		attrs.put("telephoneNumber", map.get("TELEPHONE"));
                    	}	
        			}      
        			attrs.put(attr);
        			ldap.add(rdn, attrs);
    			}
    			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
    			System.out.println("ldap全量同步结束.....");
        	}
		} catch (NamingException e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		} catch (DigestException e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally {
			try {
				ldap.close();
			} catch (NamingException e) {
				jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
				e.printStackTrace();
			}
		}
		return "json";	
	}
	
	//LDAP批量同步
	public String addLdapUserRow() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		String deletekey = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Ldap ldap = Factory.createInstance();
		jsonObject = new JSONObject();
		try {
			ldap.connect();
			for(String useruid : ListKey){
				String searchFilter = "uid=" + useruid;
				String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
				List<Map<String, Object>> result = ldap.searchAll(searchFilter, searchBase, null);
				if(result.isEmpty()){
					//ldap没有存在，需要新增
					Map<String, Object> list = business.list_user_ldap_single(useruid);
					System.out.println("-------list"+list);
					String searchFilter1 = "ou=" + list.get("UNIT_ID");
					List<Map<String, Object>> result1 = ldap.searchAll(searchFilter1, searchBase, null);
					String rdn = "uid=" + useruid + "," + result1.get(0).get("rdn") + "," + searchBase;
					System.out.println("-------rdn"+rdn);
					String objectClass = "inetOrgPerson";
        			Attribute attr = new BasicAttribute("objectClass");
        			attr.add(objectClass);
        			Attributes attrs = new BasicAttributes();
        			attrs.put(attr);
        			attrs.put("uid", list.get("USER_ID"));
    				attrs.put("description", list.get("USER_NAME"));
    				String pass = Sha1.SHA1(Encipher.DecodePasswd((String) list.get("USER_PWD")));
        			attrs.put("userPassword", pass);
        			if(list.get("USER_SEX").equals("1")){
        				attrs.put("usersex", "男");
        			}else if(list.get("USER_SEX").equals("2")){
        				attrs.put("usersex", "女");
        			}
        			//attrs.put("usersex", map.get("USER_SEX"));
        			attrs.put("employeeNumber", list.get("ID_NUMBER"));
        			attrs.put("ou", list.get("UNIT_NAME"));
        			attrs.put("cn", list.get("USER_ID"));
        			attrs.put("sn", list.get("USER_ID"));
        			System.out.println("------st"+list.get("UNIT_ID"));
        			String st = (String)list.get("UNIT_ID");
        			attrs.put("st", st);
        			if(!(list.get("MOBILE") == null)){
        				attrs.put("mobile", list.get("MOBILE"));
        			}
        			if(!(list.get("EMAIL") == null)){
        				attrs.put("mail", list.get("EMAIL"));
        			}
        			if(!(list.get("CARD_ID") == null)){
        				attrs.put("idcard", list.get("CARD_ID"));
        			}
                    if(!(list.get("TELEPHONE") == null)){
                    	attrs.put("telephoneNumber", list.get("TELEPHONE"));	
        			}      
        			attrs.put(attr);
        			ldap.add(rdn, attrs);
        			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
				}else{
					//ldap里面存在人员信息，只需更新
					String rdn = result.get(0).get("rdn") + "," + searchBase;
					System.out.println("---------rdn"+rdn);
					Map<String, Object> list = business.list_user_ldap_single(useruid);
					Map<String, Object> mapuser = new HashMap<String, Object>();
					mapuser.put("description", list.get("USER_NAME"));
					String pass = Sha1.SHA1(Encipher.DecodePasswd((String) list.get("USER_PWD")));
					mapuser.put("userPassword", pass);
					if(list.get("USER_SEX").equals("1")){
						mapuser.put("usersex", "男");
        			}else if(list.get("USER_SEX").equals("2")){
        				mapuser.put("usersex", "女");
        			}
					mapuser.put("employeeNumber", list.get("ID_NUMBER"));
					mapuser.put("ou", list.get("UNIT_NAME"));
					String st = (String)list.get("UNIT_ID");
        			mapuser.put("st", st);
					if(!(list.get("MOBILE") == null)){
						mapuser.put("mobile", list.get("MOBILE"));
        			}
        			if(!(list.get("EMAIL") == null)){
        				mapuser.put("mail", list.get("EMAIL"));
        			}
        			if(!(list.get("CARD_ID") == null)){
        				mapuser.put("idcard", list.get("CARD_ID"));
        			}
                    if(!(list.get("TELEPHONE") == null)){
                    	mapuser.put("telephoneNumber", list.get("TELEPHONE"));	
        			}  
                    for(Map.Entry<String, Object> entry : mapuser.entrySet()){
						ldap.update(rdn, entry.getKey(), entry.getValue());
					}
					jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
				}
			}
		} catch (NamingException e) {
			// TODO Auto-generated catch block
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		} catch (DigestException e) {
			// TODO Auto-generated catch block
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}finally {
			try {
				ldap.close();
			} catch (NamingException e) {
				jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
				e.printStackTrace();
			}
		}
		return "json";	
	}
	//ldap单个删除
		public String deleteLdapUser() throws BusinessException{
			UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
			String deletekey = RequestUtils.getString(request, "deletekey");
			List<String> ListKey = QueryParamUtil.StringToList(deletekey);
			Ldap ldap = Factory.createInstance();
			jsonObject = new JSONObject();
			try {
				ldap.connect();
				for(String useruuid : ListKey) {
					String searchFilter = "uid=" + useruuid;
					String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
					List<Map<String, Object>> result = ldap.searchAll(searchFilter, searchBase, null);
					String rdn = result.get(0).get("rdn") + "," + searchBase;
					ldap.delete(rdn);		
				}
			} catch (NamingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}finally {
				try {
					ldap.close();
				} catch (NamingException e) {
					e.printStackTrace();
				}
			}
			return "json";
		}
		//账号导入
		public String ImpUser() throws BusinessException {
			UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
			SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String datastart = df.format(new Date());
			System.out.println("账号模板导入开始.....");
			Map<String, Object> file = RequestUtils.getUpdateFieldMap(request, "FILED_");
			if (file.get("FILE_PATH") != null && !file.get("FILE_PATH").toString().equals("")) {
				String filePath = file.get("FILE_PATH").toString();
				Workbook book = null;
				try {
					book = Workbook.getWorkbook(new File(filePath));
					int sheetCount = book.getNumberOfSheets();
					String data = "";
					System.out.println("-----------------共"+sheetCount+"页数据开始导入----------------------");
					// 获得第一个工作表对象(组织导入表)
					Sheet sheet = book.getSheet(0);
					int rows = sheet.getRows();
					// 遍历每行每列的单元格
					for (int i = 1; i < rows; i++) {
						Map<String, Object> userMap = new HashMap<String, Object>();
						Map<String, Object> userMapaccount = new HashMap<String, Object>();
						Map<String, Object> userMapext = new HashMap<String, Object>();
						// 判断是否要新增数据，要是0 1 2 3没有数据 则不更新数据
						int flag = 0;
						// 整列为空值
						int flag1 = 0;
						for (int j = 0; j < 9; j++) {
							if (sheet.getCell(j, i).getContents() == null
									|| sheet.getCell(j, i).getContents().equals(
											"null")
									|| sheet.getCell(j, i).getContents().equals(""))
								flag1++;
						}
						for (int j = 0; j < 9; j++) {
							Cell cell = sheet.getCell(j, i);
							String result = cell.getContents();
							if (result != null && !result.equals("null")
									&& !result.equals("")) {
								switch (j) {
								case 0:// 账号
									userMap.put("USER_ID", result);
									userMapaccount.put("USER_ID", result);
									userMapext.put("USER_ID", result);
									userMapaccount.put("ID_NUMBER", result);
									break;
								case 1:// 用户名
									userMap.put("USER_NAME", result);
									break;
								case 2:// 部门
									userMapaccount.put("UNIT_ID", result);
									break;
								case 3:// 密码
									if(result.equals("")){
										userMap.put("USER_PWD", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service","0000")));
									}else{
										userMap.put("USER_PWD", Encipher.EncodePasswd(result));
									}	
									break;	
								case 4:// 性别
									userMap.put("USER_SEX", result);
									break;
								case 5:// 序号
									userMapaccount.put("ORDER_ID", result);
									break;	
								case 6:// 姓名拼音
									userMap.put("USER_NAME_PINYIN", result);
									break;
								case 7:// 证件类型
									userMapext.put("CARD_TYPE", result);
									break;
								case 8:// 身份证
									userMapext.put("CARD_ID", result);
									break;
								case 9:// 国籍
									userMapext.put("NATIONALITY", result);
									break;
								case 10:// 籍贯
									userMapext.put("NATIVE_PLACE", result);
									break;
								case 11:// 名族
									userMapext.put("NATION", result);
									break;
								case 12:// 是否在编
									userMapext.put("IS_SFZB", result);
									break;
								case 13:// 在编类别
									userMapext.put("ZBLB", result);
									break;
								case 14:// 邮箱
									userMapext.put("EMAIL", result);
									break;
								case 15:// 手机
									userMapext.put("MOBILE", result);
									break;
								case 16:// 办公室电话
									userMapaccount.put("OFFICE_PHONE", result);
									break;
								default:
									break;
								}	
								//userMap.put("USER_PWD", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service","2222")));
								userMapaccount.put("IS_ACTIVE", "1");
								userMapaccount.put("LEAVE_FLAG", "0");
							} else {
								if (j == 0 || j == 1 || j == 2 ) {
									flag = 1;
									if (flag1 != 17)
										data = data + "第" + (i + 1) + "行,";
									break;
								}

							}
						}
						//unitMap.put("tableName", "UICM_UNIT");
						// 新增
						if (flag == 0) {
							int count = business.listCount_user(userMap);
							if (count > 0){
								business.update_user(userMap);
								business.update_user_account(userMapaccount);
								business.update_user_ext(userMapext);
							}	
							else{
								business.insert_user(userMap);
								business.insert_user_account(userMapaccount);
								business.insert_user_ext(userMapext);
								//新增账号授权
								operateGroup.insertGroup((String)userMap.get("USER_ID"));
							}
						}
					}
					if (data.equals(""))
						jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
					else {
						Map<String, Object> m = new HashMap<String, Object>();
						data = data.substring(0, data.length() - 1);
						data = data + "由于必填项未填写，未能导入到数据库，请重新填写后导入。";
						m.put("VALUE", data);
						jsonObject.putAll(m);
					}
				} catch (Exception e) {
					// TODO: handle exception
					e.printStackTrace();
					jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
				}
				String dataend = df.format(new Date());
				System.out.println("-----------------数据导入结束----------------------开始时间："+ datastart + ", 结束时间：" + dataend);
			}
			return "json";
		}
		//文件下载
		public String download() throws BusinessException{
			String ret_download ="";
	    	String uuid = request.getParameter("uuid");
			String uploadnew=request.getParameter("uploadnew");
			String uploadpath=request.getParameter("uploadpath");
			String uploadold=request.getParameter("uploadold");
			if(new File(uploadpath+File.separator+uploadnew).exists()==false){
				uploadpath = request.getSession().getServletContext().getRealPath(uploadpath);
				try {
//					uploadold = new String(uploadold.getBytes("iso8859-1"), "utf-8");
					uploadold = new String((uploadold).getBytes("gbk"),"iso8859-1");
				} catch (UnsupportedEncodingException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
				FileUtil fileUtil = new FileUtil();
				
				//文件存放目录
				FileObject baseDir = fileUtil.getFile(uploadpath);
				
				//获取下载文件
				FileObject file = null;
				try {
					file = baseDir.resolveFile(uploadnew);
				} catch (FileSystemException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				//设置response
				response.setContentType("application/octet-stream");
				response.addHeader("Content-Disposition", "attachment; filename=\""+uploadold+"\"");
				
				//下载，写入response
				fileUtil.download(file, response); 
				
				ret_download =  null;
			}else{
				ret_download = super.download();
			}
			return ret_download;	
		}
		
		//个人编辑页面
		public String editUser() throws BusinessException{
			UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
			Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
//			System.out.println("-------entity_user" + entity_user);
			Map<String, Object> query = new HashMap<String, Object>();
			query.put("USER_ID", SessionUtil.getCode());
//			System.out.println("------userid" + SessionUtil.getCode());
			//query.put("MOBILE", entity_user.get("MOBILE"));
			query.put("EMAIL", entity_user.get("EMAIL"));
			query.put("TELEPHONE", entity_user.get("TELEPHONE"));
			query.put("MOBILE", entity_user.get("MOBILE"));
			business.update_user_ext(query);
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
			return "json";
		}
		//已删人员库恢复
		public String retDelUser() throws BusinessException{
			UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
			Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			System.out.println("开始已删人员库恢复.....");
			System.out.println("需要恢复的人员编号："+ entity_user.get("USER_ID"));
			System.out.println("需要恢复的人员部门："+ entity_user.get("UNIT_ID"));
			UnitBusiness unitBusiness = BusinessManager.getBusiness(UnitBusiness.class);
			Map<String, Object> mapunit = new HashMap<String, Object>();
			mapunit.put("UUID", entity_user.get("UNIT_ID"));
			mapunit.put("DELETE_FLAG", "0");
			unitBusiness.update_unit(mapunit);
			Map<String, Object> query = new HashMap<String, Object>();
			query.put("USER_ID", entity_user.get("USER_ID"));
			query.put("DELETE_FLAG", "0");
			business.update_user_account(query);
			operateGroup.insertGroup((String)entity_user.get("USER_ID"));
			//ldap同步恢复
			String ldapflag = PropUtil.getValue("flag","quartz_service","0");
			if(ldapflag.equals("1")){
				Ldap ldap = Factory.createInstance();
				try {
					ldap.connect();
					String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
					Map<String, Object> list = business.list_user_ldap_single((String)entity_user.get("USER_ID"));
					System.out.println("-----user_id"+entity_user.get("USER_ID"));
					System.out.println("ldap已删人员恢复......");
					System.out.println("-------list"+list);
					System.out.println("-------unit_id"+list.get("UNIT_ID"));
					String searchFilter1 = "ou=" + list.get("UNIT_ID");
					List<Map<String, Object>> result = ldap.searchAll(searchFilter1, searchBase, null);
			        System.out.println("------result"+result.size());
			        if(result.size() == 0){
			        	//部门被删除（添加部门）
			        	System.out.println("----uuid"+list.get("UNIT_ID"));
			        	Map<String, Object> map2 = unitBusiness.list_unit_ldap_ou(list.get("UNIT_ID").toString());
			        	
						String o = PropUtil.getValue("root","quartz_service","0000").substring(2);
						if(map2.get("PARENT_ID").equals(o)){
							String rdn = "ou=" + map2.get("UUID") + "," + searchBase;
							System.out.println("-----rdn"+rdn);
							String objectClass = "organizationalUnit";
		        			Attribute attr = new BasicAttribute("objectClass");
		        			attr.add(objectClass);
		        			Attributes attrs = new BasicAttributes();
		        			attrs.put(attr);
		        			attrs.put("description", map2.get("NAME"));
		        			attrs.put("st", map2.get("PARENT_ID"));
		        			attrs.put("street", map2.get("UNIT_ID"));
		        			ldap.add(rdn, attrs);
						}else{
							String searchFilter2 = "ou=" + map2.get("PARENT_ID");
							List<Map<String, Object>> result1 = ldap.searchAll(searchFilter2, searchBase, null);
							System.out.println("------result1"+ result1);
							String rdn = "ou=" + list.get("UNIT_ID") + "," + result1.get(0).get("rdn") + "," + searchBase;
							String objectClass = "organizationalUnit";
		        			Attribute attr = new BasicAttribute("objectClass");
		        			attr.add(objectClass);
		        			Attributes attrs = new BasicAttributes();
		        			attrs.put(attr);
		        			attrs.put("description", map2.get("NAME"));
		        			attrs.put("st", map2.get("PARENT_ID"));
		        			attrs.put("street", map2.get("UNIT_ID"));
		        			ldap.add(rdn, attrs);
						}
						//部门没被删除
						String searchFilter3 = "ou=" + list.get("UNIT_ID");
						List<Map<String, Object>> result1 = ldap.searchAll(searchFilter3, searchBase, null);
						System.out.println("------rdn1"+result1.get(0).get("rdn"));
						String rdn = "uid=" + (String)entity_user.get("USER_ID") + "," + result1.get(0).get("rdn") + "," + searchBase;
						System.out.println("-------rdn"+rdn);
						String objectClass = "inetOrgPerson";
		    			Attribute attr = new BasicAttribute("objectClass");
		    			attr.add(objectClass);
		    			Attributes attrs = new BasicAttributes();
		    			attrs.put(attr);
		    			attrs.put("uid", list.get("USER_ID"));
						attrs.put("description", list.get("USER_NAME"));
						String pass = Sha1.SHA1(Encipher.DecodePasswd((String) list.get("USER_PWD")));
		    			attrs.put("userPassword", pass);
		    			if(null != list.get("USER_SEX")){
		    				if(list.get("USER_SEX").equals("1")){
			    				attrs.put("usersex", "男");
			    			}else if(list.get("USER_SEX").equals("2")){
			    				attrs.put("usersex", "女");
			    			}
		    			}
		    			//attrs.put("usersex", map.get("USER_SEX"));
		    			attrs.put("employeeNumber", list.get("ID_NUMBER"));
		    			attrs.put("ou", list.get("UNIT_NAME"));
		    			attrs.put("cn", list.get("USER_ID"));
		    			attrs.put("sn", list.get("USER_ID"));
		    			System.out.println("------st"+list.get("UNIT_ID"));
		    			String st = (String)list.get("UNIT_ID");
		    			attrs.put("st", st);
		    			if(!(list.get("MOBILE") == null)){
		    				attrs.put("mobile", list.get("MOBILE"));
		    			}
		    			if(!(list.get("EMAIL") == null)){
		    				attrs.put("mail", list.get("EMAIL"));
		    			}
		    			if(!(list.get("CARD_ID") == null)){
		    				attrs.put("idcard", list.get("CARD_ID"));
		    			}
		                if(!(list.get("TELEPHONE") == null)){
		                	attrs.put("telephoneNumber", list.get("TELEPHONE"));	
		    			}      
		    			attrs.put(attr);
		    			ldap.add(rdn, attrs);
			        }else{
			        	//部门没被删除
						String searchFilter3 = "ou=" + list.get("UNIT_ID");
						List<Map<String, Object>> result1 = ldap.searchAll(searchFilter3, searchBase, null);
						System.out.println("------rdn1"+result1.get(0).get("rdn"));
						String rdn = "uid=" + (String)entity_user.get("USER_ID") + "," + result1.get(0).get("rdn") + "," + searchBase;
						System.out.println("-------rdn"+rdn);
						String objectClass = "inetOrgPerson";
		    			Attribute attr = new BasicAttribute("objectClass");
		    			attr.add(objectClass);
		    			Attributes attrs = new BasicAttributes();
		    			attrs.put(attr);
		    			attrs.put("uid", list.get("USER_ID"));
						attrs.put("description", list.get("USER_NAME"));
						String pass = Sha1.SHA1(Encipher.DecodePasswd((String) list.get("USER_PWD")));
		    			attrs.put("userPassword", pass);
		    			if(null != list.get("USER_SEX")){
		    				if(list.get("USER_SEX").equals("1")){
			    				attrs.put("usersex", "男");
			    			}else if(list.get("USER_SEX").equals("2")){
			    				attrs.put("usersex", "女");
			    			}
		    			}
		    			//attrs.put("usersex", map.get("USER_SEX"));
		    			attrs.put("employeeNumber", list.get("ID_NUMBER"));
		    			attrs.put("ou", list.get("UNIT_NAME"));
		    			attrs.put("cn", list.get("USER_ID"));
		    			attrs.put("sn", list.get("USER_ID"));
		    			System.out.println("------st"+list.get("UNIT_ID"));
		    			String st = (String)list.get("UNIT_ID");
		    			attrs.put("st", st);
		    			if(!(list.get("MOBILE") == null)){
		    				attrs.put("mobile", list.get("MOBILE"));
		    			}
		    			if(!(list.get("EMAIL") == null)){
		    				attrs.put("mail", list.get("EMAIL"));
		    			}
		    			if(!(list.get("CARD_ID") == null)){
		    				attrs.put("idcard", list.get("CARD_ID"));
		    			}
		                if(!(list.get("TELEPHONE") == null)){
		                	attrs.put("telephoneNumber", list.get("TELEPHONE"));	
		    			}      
		    			attrs.put(attr);
		    			ldap.add(rdn, attrs);
			        }
				} catch (NamingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (DigestException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
			}
			System.out.println("已删人员库恢复结束......");
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
			return "json";
		}
		//离职人员库恢复
		public String retLeaveUser() throws BusinessException{
			UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
			Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			System.out.println("开始离职人员恢复......");
			System.out.println("需要恢复的人员编号："+ entity_user.get("USER_ID"));
			Map<String, Object> query = new HashMap<String, Object>();
			query.put("USER_ID", entity_user.get("USER_ID"));
			query.put("LEAVE_FLAG", "0");
			business.update_user_account(query);
			String ldapflag = PropUtil.getValue("flag","quartz_service","0");
			if(ldapflag.equals("1")){
				Ldap ldap = Factory.createInstance();
				try {
					ldap.connect();
					String searchBase = PropUtil.getValue("root","quartz_service","0000") + "," + PropUtil.getValue("rootrdn","quartz_service","0000");
					Map<String, Object> list = business.list_user_ldap_single((String)entity_user.get("USER_ID"));
					System.out.println("ldap离职恢复......");
					System.out.println("-------list"+list);
					String searchFilter1 = "ou=" + list.get("UNIT_ID");
					List<Map<String, Object>> result1 = ldap.searchAll(searchFilter1, searchBase, null);
					String rdn = "uid=" + (String)entity_user.get("USER_ID") + "," + result1.get(0).get("rdn") + "," + searchBase;
					System.out.println("-------rdn"+rdn);
					String objectClass = "inetOrgPerson";
	    			Attribute attr = new BasicAttribute("objectClass");
	    			attr.add(objectClass);
	    			Attributes attrs = new BasicAttributes();
	    			attrs.put(attr);
	    			attrs.put("uid", list.get("USER_ID"));
					attrs.put("description", list.get("USER_NAME"));
					String pass = Sha1.SHA1(Encipher.DecodePasswd((String) list.get("USER_PWD")));
	    			attrs.put("userPassword", pass);
	    			if(list.get("USER_SEX").equals("1")){
	    				attrs.put("usersex", "男");
	    			}else if(list.get("USER_SEX").equals("2")){
	    				attrs.put("usersex", "女");
	    			}
	    			//attrs.put("usersex", map.get("USER_SEX"));
	    			attrs.put("employeeNumber", list.get("ID_NUMBER"));
	    			attrs.put("ou", list.get("UNIT_NAME"));
	    			attrs.put("cn", list.get("USER_ID"));
	    			attrs.put("sn", list.get("USER_ID"));
	    			System.out.println("------st"+list.get("UNIT_ID"));
	    			String st = (String)list.get("UNIT_ID");
	    			attrs.put("st", st);
	    			if(!(list.get("MOBILE") == null)){
	    				attrs.put("mobile", list.get("MOBILE"));
	    			}
	    			if(!(list.get("EMAIL") == null)){
	    				attrs.put("mail", list.get("EMAIL"));
	    			}
	    			if(!(list.get("CARD_ID") == null)){
	    				attrs.put("idcard", list.get("CARD_ID"));
	    			}
	                if(!(list.get("TELEPHONE") == null)){
	                	attrs.put("telephoneNumber", list.get("TELEPHONE"));	
	    			}      
	    			attrs.put(attr);
	    			ldap.add(rdn, attrs);
				} catch (NamingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (DigestException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			System.out.println("离职人员恢复结束......");
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
			return "json";
		}
		
		//添加权限
		public String addGroup() throws BusinessException{
			SystemOpeBusiness sysBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			UserBusiness userBusiness = BusinessManager.getBusiness(UserBusiness.class);
			Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			System.out.println("开始添加权限......");
			Map<String, Object> map = new HashMap<String, Object>();
			String gid = (String) entity.get("G_ID");
			map.put("G_ID", gid);
			String [] str = entity.get("CODE").toString().split(",");
			List<Map<String, Object>> listuser = userBusiness.listGroupUser(map);
            for(int i = 0 ; i < str.length ; i++){
            	if(str[i].startsWith("2_")){
            		String strid = str[i].substring(2);
            		System.out.println("需要权限的用户："+ strid);
            		if(listuser.size() == 0){
            			map.put("U_ID", strid);
        				sysBusiness.insert_group_c_u(map);
            		}else{
            			for(Map<String, Object> mapuser : listuser){
                			if(strid.equals(mapuser.get("U_ID"))){
                				listuser.remove(mapuser);
                			}else{
                				map.put("U_ID", strid);
                				sysBusiness.insert_group_c_u(map);
                			}
                			break;
                		}
            		}
            	}
            }
            for(Map<String, Object> deluser : listuser){
            	sysBusiness.delete_group_c_u(deluser);
            }
            System.out.println("更新权限结束......");
            jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
			return "json";
		}
		/*//写入缓存
		public String updateCacheTable() throws BusinessException{
			UserBusiness userBusiness = BusinessManager.getBusiness(UserBusiness.class);
			Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			System.out.println("开始更新缓存.....");
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("tableName", entity.get("CODE"));
			userBusiness.updateCache(map);
			System.out.println("更新结束......");
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
			return "json";
		}*/
}
