package com.jw.app.user.action;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import org.apache.commons.lang.StringUtils;

import com.gaowj.business.StandardBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.UnitBusiness;
import com.jw.app.business.UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.common.EasyuiJsonUtils;
import com.jw.app.common.ZtreeJsonUtils;

public class dataAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6083279531948261141L;

	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
	private int page = 1;// 当前第几页
	private String dataReturn;
	// output属性
	private InputStream inputStream; // 这个名字和struts.xml中对应，不能写错

	public InputStream getInputStream() {
		return inputStream;
	}

	public void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public String getDataReturn() {
		return dataReturn;
	}

	public void setDataReturn(String dataReturn) {
		this.dataReturn = dataReturn;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}

	public String list() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);

		// 找出所有子级单位
		if (query.get("UNIT_ID_IS_PARENT") != null) {
			UnitBusiness businessUnit = BusinessManager
					.getBusiness(UnitBusiness.class);
			List<Map<String, Object>> listData = businessUnit.list_unit(null);
			List<String> list = EasyuiJsonUtils.getParentsData(listData,
					(String) query.get("UNIT_ID_IS_PARENT"));
			query.put("UNIT_ID_IS_PARENT", list);
		}
		//
		try {
			query = QueryParamUtil.StringToDate(query);
			query.put("DELETE_FLAG", "0");
			query.put("LEAVE_FLAG", "0");
			Page<Map<String, Object>> pageRows = business.list_user(pageNo,
					pageSize, query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
			Map<String, Object> data = new HashMap<String, Object>();
			data
					.put("rowSet", QueryParamUtil.DateToString(pageRows
							.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	public String listAll() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		// 找出所有子级单位
		if (query.get("UNIT_ID_IS_PARENT") != null) {
			UnitBusiness businessUnit = BusinessManager
					.getBusiness(UnitBusiness.class);
			List<Map<String, Object>> listData = businessUnit.list_unit(null);
			List<String> list = EasyuiJsonUtils.getParentsData(listData,
					(String) query.get("UNIT_ID_IS_PARENT"));
			query.put("UNIT_ID_IS_PARENT", list);
		}
		//
		try {
			query = QueryParamUtil.StringToDate(query);
			query.put("DELETE_FLAG", "0");
			query.put("LEAVE_FLAG", "0");
			List<Map<String, Object>> listData = business.list_user(query);
			int listDataCount = business.listCount_user(query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(listData));
			data.put("pageNo", 1);
			data.put("pageSize", listDataCount);
			data.put("pageCount", listDataCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	public String listMy() throws BusinessException {

		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		// 找出所有子级单位
		UnitBusiness businessUnit = BusinessManager
				.getBusiness(UnitBusiness.class);
		List<Map<String, Object>> listData = businessUnit.list_unit(null);
		if (query.get("TREE_CLICK") == null
				|| StringUtils.equals((String) query.get("UNIT_ID_IS_PARENT"),
						"A")) {

			listData = ZtreeJsonUtils.getUserGridJsonData(listData);
			List<String> list = new ArrayList<String>();
			for (Map<String, Object> m : listData) {
				list.add((String) m.get("UUID"));
			}
			query.put("UNIT_ID_IS_PARENT", list);
		} else {
			List<String> list = EasyuiJsonUtils.getParentsData(listData,
					(String) query.get("UNIT_ID_IS_PARENT"));
			query.put("UNIT_ID_IS_PARENT", list);
		}
		
		try {
			query = QueryParamUtil.StringToDate(query);
			query.put("DELETE_FLAG", "0");
			query.put("LEAVE_FLAG", "0");
			Page<Map<String, Object>> pageRows = business.list_user(pageNo,
					pageSize, query);
			setPageCount((pageRows.getCount() - 1) / pageSize + 1);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("rowSet", QueryParamUtil.DateToString(pageRows
							.getItems()));
			data.put("pageNo", pageNo);
			data.put("pageSize", pageSize);
			data.put("pageCount", pageCount);
			data.put("rows", data.get("rowSet"));
			data.put("total", pageRows.getCount());
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 接口： 宁海自动化办公系统
	 * 
	 * @return
	 * @throws BusinessException
	 *             参数：userId：用户系统名、userName 用户中文名、userMobile：手机号码 修改 2015/06/15
	 *             根据用户系统名 获取密码、手机号
	 */
	public String listUserInfo() throws BusinessException {
		response.setHeader("Access-Control-Allow-Origin", "*");
		jsonObject = new JSONObject();
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		// String username=request.getParameter("userName");
		String userId = request.getParameter("userId");
		// String mobile=request.getParameter("userMobile");
		Map<String, Object> query = new HashMap<String, Object>();
		query.put("ID_NUMBER", userId);
		List<Map<String, Object>> listData = business.listUserInfo(query);
		/*
		 * try { username=URLDecoder.decode(username, "gbk"); } catch
		 * (UnsupportedEncodingException e) { // TODO Auto-generated catch block
		 * e.printStackTrace(); }
		 */
		if (listData.size() > 0) {
			for (Map<String, Object> map : listData) {
				/*
				 * if(map.get("USER_NAME")==null||!username.equals(map.get("USER_NAME"
				 * ).toString())) { jsonObject.put("STATUS", 2);
				 * //jsonObject.put("VALUE", "该用户的中文名错误！"); } else {
				 * if(map.get("MOBILE"
				 * )==null||!mobile.equals(map.get("MOBILE").toString())) {
				 * jsonObject.put("STATUS", 3); //jsonObject.put("VALUE",
				 * "该用户的手机号错误！"); } else {
				 */
				jsonObject.put("STATUS", 1);
				jsonObject.put("VALUE", "success");
				map.remove("USER_NAME");
				map.remove("EMAIL");
				jsonObject.putAll(map);
				/*
				 * }
				 * 
				 * }
				 */
			}
		} else {
			jsonObject.put("STATUS", 0);
			jsonObject.put("VALUE", "The user does not exist");
		}
		return "json";
		/*
		 * 
		 * UserBusiness business =
		 * BusinessManager.getBusiness(UserBusiness.class); Map<String, Object>
		 * query = RequestUtils.getUpdateFieldMap(request,
		 * RequestUtils.UPDATEDATAFIELDPREFIX); List<Map<String, Object>>
		 * listData = business.listUserInfo(query); jsonObject = new
		 * JSONObject(); response.setHeader("Access-Control-Allow-Origin", "*");
		 * for (Map<String, Object> map : listData) { jsonObject.putAll(map); }
		 * jsonObject.putAll(query); if (listData.size() == 0) { Map<String,
		 * Object> dataMap = new HashMap<String, Object>(); dataMap.put("NAME",
		 * 1); dataMap.put("VALUE", "用户不存在"); jsonObject.putAll(dataMap); }
		 * String jsonp = request.getParameter("callback"); dataReturn = jsonp +
		 * "(" + jsonObject.toString() + ")"; dataReturn =
		 * dataReturn.replace('"', '\''); System.out.println(dataReturn); return
		 * "success";
		 */
	}

	/**
	 * 接口： 宁海自动化办公系统
	 * 
	 * @return
	 * @throws BusinessException
	 *             参数：userId：用户系统名、userName 用户中文名、userMobile：手机号码
	 */
	public String listUserInfo1() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		List<Map<String, Object>> listData = business.listUserInfo(query);
		jsonObject = new JSONObject();
		response.setHeader("Access-Control-Allow-Origin", "*");
		for (Map<String, Object> map : listData) {
			map.remove("USER_NAME");
			jsonObject.putAll(map);
		}
		jsonObject.putAll(query);
		if (listData.size() == 0) {
			Map<String, Object> dataMap = new HashMap<String, Object>();
			dataMap.put("NAME", 1);
			// dataMap.put("VALUE", "用户不存在");
			jsonObject.putAll(dataMap);
		}
		return "json";
	}
	public String userDetail() throws BusinessException {
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
					RequestUtils.UPDATEDATAFIELDPREFIX);
			if(query.get("USER_ID")!=	null){
				UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
				// 找出相应单位的详情
				List<Map<String, Object>> listData = business.list_user(query);
				jsonObject = new JSONObject();
				listData=QueryParamUtil.DateToString(listData);
				if(listData!=null&&listData.size()>0)
					jsonObject.putAll(listData.get(0));
			}
			else{
				jsonObject = new JSONObject();
				jsonObject.put("errCode", 1);
			}
		} catch (Exception e) {
			// TODO: handle exception
		}
		return "success";
	}
	
	
	public String listMaxOrder() throws BusinessException {
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		try {
			Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
			query = QueryParamUtil.StringToDate(query);
			int listDataCount = business.list_max_order(query);
			Map<String, Object> data = new HashMap<String, Object>();
			data.put("maxorder", listDataCount);
			jsonObject = new JSONObject();
			jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
	//个人编辑页面查询
	public String listUserEdit() throws BusinessException{
		UserBusiness business = BusinessManager.getBusiness(UserBusiness.class);
		Map<String, Object> query = new HashMap<String, Object>();
		query.put("USER_ID", SessionUtil.getCode());
	    List<Map<String, Object>> map = business.listUserInfo_userId(query);
	    Map<String, Object> data = new HashMap<String, Object>();
		data.put("rowSet", map);
		data.put("pageNo", pageNo);
		data.put("pageSize", pageSize);
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", 1);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		return "json";
	}
	
	//人员权限ZTREE查询
	public String listALLUserUnit() throws BusinessException {
		UserBusiness userBusiness = BusinessManager.getBusiness(UserBusiness.class);
		UnitBusiness unitBusiness = BusinessManager.getBusiness(UnitBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("g_id", (String)query.get("G_ID"));
		List<Map<String, Object>> listuser = userBusiness.listAllUser(map);
//		System.out.println("------list"+listuser);
		List<Map<String, Object>> listunit = unitBusiness.listAllUnit();
		List<Map<String, Object>> list = new ArrayList<Map<String,Object>>();
		list.addAll(listuser);
		list.addAll(listunit);
		Map<String, Object> data = new HashMap<String, Object>();
		data.put("rowSet", list);
		data.put("pageNo", pageNo);
		data.put("pageSize", pageSize);
		data.put("pageCount", pageCount);
		data.put("rows", data.get("rowSet"));
		data.put("total", 1);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		return "json";
	}
}
