package com.jw.app.user2user.action;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.service.client.remote.util.AuthenticateUtil;
import com.jw.app.business.User2UserBusiness;
import com.jw.app.business.UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;

public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 511364858145427161L;

	private JSONObject jsonObject = new JSONObject();

	private File leftFile;

	private File appFile;

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public File getLeftFile() {
		return leftFile;
	}

	public void setLeftFile(File leftFile) {
		this.leftFile = leftFile;
	}

	public File getAppFile() {
		return appFile;
	}

	public void setAppFile(File appFile) {
		this.appFile = appFile;
	}

	public String insertU2U() throws BusinessException {

		User2UserBusiness business = BusinessManager
				.getBusiness(User2UserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try {
			if (entity.get("USERID_1") != null) {
				String userid = (String) entity.get("USERID_1");
				String[] userids = userid.split("\\,");

				for (String managerid : userids) {
					// 判断管理员已存在
					Map<String, Object> entityM = new HashMap<String, Object>();
					entityM.put("USERID", managerid);
					entityM.put("TYPE", "1");
					int c = business.listUser2UserCount(entityM);
					if (c >= 1)
						continue;
					//
					Map<String, Object> entityuser = new HashMap<String, Object>();
					entityuser.put("USERID", managerid);
					entityuser.put("TYPE", "1");
					business.insertUser2User(entityuser);
					// 分配人员管理角色
					String gid = AuthenticateUtil.getEndpoint("groupid");
					SystemOpeBusiness systemOpeBusiness = BusinessManager
							.getBusiness(SystemOpeBusiness.class);
					Map<String, Object> gu_entity = new HashMap<String, Object>();
					gu_entity.put("G_ID", gid);
					gu_entity.put("U_ID", managerid);
					systemOpeBusiness.insert_group_c_u(gu_entity);
					// 操作日志
					UserBusiness userbusiness = BusinessManager
							.getBusiness(UserBusiness.class);
					Map<String, Object> query = new HashMap<String, Object>();
					query.put("USER_ID", entityuser.get("USERID"));
					List<Map<String, Object>> list = userbusiness
							.list_user(query);
					if (list.size() > 0)
						systemOpeBusiness.insert_logBusiness("insertUser", ""
								+ entityuser, "增加分级管理员记录", managerid, list.get(
								0).get("USER_NAME").toString(),
								"JW_APPS_UICM_USER_INFO");
					else
						systemOpeBusiness
								.insert_logBusiness("insertUser", ""
										+ entityuser, "增加分级管理员记录", managerid,
										entityuser.toString(),
										"JW_APPS_UICM_USER_INFO");
				}
			}

			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	// public String updateU2U() throws BusinessException{
	//		
	// User2UserBusiness business =
	// BusinessManager.getBusiness(User2UserBusiness.class);
	// Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request,
	// RequestUtils.UPDATEDATAFIELDPREFIX);
	// try{
	// entity = QueryParamUtil.StringToDate(entity);
	// business.updateUser2User(entity);
	// //操作日志
	// // SystemOpeBusiness sysbusiness =
	// BusinessManager.getBusiness(SystemOpeBusiness.class);
	// // sysbusiness.insert_logBusiness("updateUnit", "修改单位信息："+entity);
	// //
	// jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
	// }catch(Exception e){
	// jsonObject.putAll(Status.getStatus(Status.UPDATE_ERR));
	// e.printStackTrace();
	// }
	// return "json";
	// }

	public String deleteU2U() throws BusinessException {

		User2UserBusiness business = BusinessManager
				.getBusiness(User2UserBusiness.class);
		String deletekey = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		try {
			// 删除人员管理角色
			Map<String, Object> delQuery = new HashMap<String, Object>();
			delQuery.put("UUIDS", ListKey);
			List<Map<String, Object>> delU = business.listUser2User(delQuery);
			for (Map<String, Object> m : delU) {
				String managerid = (String) m.get("USERID");
				String gid = AuthenticateUtil.getEndpoint("groupid");
				SystemOpeBusiness systemOpeBusiness = BusinessManager
						.getBusiness(SystemOpeBusiness.class);
				Map<String, Object> gu_entity = new HashMap<String, Object>();
				gu_entity.put("G_ID", gid);
				gu_entity.put("U_ID", managerid);
				systemOpeBusiness.delete_group_c_u(gu_entity);
				// 删除分级管理员
				business.delete_User2User(ListKey);
				systemOpeBusiness.insert_logBusiness("deleteUser", "" + ListKey,
						"删除分级管理员记录", ListKey.toString(), (String) m.get("NAME"),
						"JW_APPS_UICM_USER_INFO");
			}

			//
			jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.DELETE_ERR));
			e.printStackTrace();
		}
		return "json";
	}
	
	public String insertUserChoiceUser() throws BusinessException {

		User2UserBusiness business = BusinessManager
				.getBusiness(User2UserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			if (entity.get("USERID_1") != null
					&& entity.get("USERID_2") != null) {
				String parentid = (String) entity.get("USERID_1");
				String userid = (String) entity.get("USERID_2");
				String[] userids = userid.split(",");
				Map<String, Object> entityDel = new HashMap<String, Object>();
				entityDel.put("PARENT_ID", parentid);
				business.deleteUser2User(entityDel);
				for (String childuserid : userids) {
					Map<String, Object> entityuser = new HashMap<String, Object>();
					entityuser.put("PARENT_ID", parentid);
					entityuser.put("USERID", childuserid);
					entityuser.put("TYPE", "0");
					business.insertUser2User(entityuser);
				}
			}
			// 操作日志
			// SystemOpeBusiness sysbusiness =
			// BusinessManager.getBusiness(SystemOpeBusiness.class);
			// Map<String,Object> entity = new HashMap<String,Object>();
			// entity.putAll(entity_user);entity.putAll(entity_account);entity.putAll(entity_ext);
			// sysbusiness.insert_logBusiness("insertUser", "插入人员信息："+entity);
			//
			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}

}
