package com.jw.app.user2user.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.User2UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.common.EasyuiJsonUtils;

public class dataAction extends BasicAction{
	/**
	 * 
	 */
	private static final long serialVersionUID = 6785649922437416652L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
    private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}
	
	
	public String listU2UTree() throws BusinessException{
		User2UserBusiness business = BusinessManager.getBusiness(User2UserBusiness.class);
		try {
		Map<String,Object> query = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		query = QueryParamUtil.StringToDate(query);
		List<Map<String, Object>> listData = business.listUser2User(query);
		int listDataCount = business.listUser2UserCount(query);
		Map<String,Object> data = new HashMap<String,Object>();
		data.put("rowSet", QueryParamUtil.DateToString(listData));
		data.put("pageNo", 1);
		data.put("pageSize",listDataCount );
		data.put("pageCount", listDataCount);
		data.put("rows", EasyuiJsonUtils.getTreeGridJsonData(QueryParamUtil.DateToString(listData)));
		data.put("total", listDataCount);
		jsonObject = new JSONObject();
		jsonObject.putAll(data);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

}
