package com.jw.app.usertest.action;

import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.Java_tool;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.service.client.remote.util.AuthenticateUtil;
import com.gaowj.service.client.utils.ThreadUtil;
import com.gaowj.service.client.utils.httpClientPostData;
import com.gaowj.service.client.utils.jsonFormatMap;
import com.jw.app.business.MoveBusiness;
import com.jw.app.business.PushDataBusiness;
import com.jw.app.business.UnitBusiness;
import com.jw.app.business.UserBusiness;
import com.jw.app.business.UserTestBusiness;
import com.jw.app.business.utils.QueryParamUtil;
import com.jw.app.business.utils.Status;
import com.jw.app.common.EasyuiJsonUtils;
import com.jw.app.pushData.util.PushDataUtils;


import net.sf.json.JSONObject;


public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6496396449440750926L;

	private JSONObject jsonObject = new JSONObject();

	private File leftFile;

	private File appFile;

	private String loginuserCode = SessionUtil.getCode();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public File getLeftFile() {
		return leftFile;
	}

	public void setLeftFile(File leftFile) {
		this.leftFile = leftFile;
	}

	public File getAppFile() {
		return appFile;
	}

	public void setAppFile(File appFile) {
		this.appFile = appFile;
	}

	public String insertUser() throws BusinessException {

		UserTestBusiness business = BusinessManager.getBusiness(UserTestBusiness.class);
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request, "USER0_");
		Map<String, Object> entity_account = RequestUtils.getUpdateFieldMap(request, "ACCOU_");
		Map<String, Object> entity_ext = RequestUtils.getUpdateFieldMap(request, "EXT00_");
		String flag = "";
		try {
			entity_user = QueryParamUtil.StringToDate(entity_user);
			entity_account = QueryParamUtil.StringToDate(entity_account);
			entity_ext = QueryParamUtil.StringToDate(entity_ext);
			String uuid = java.util.UUID.randomUUID().toString();
			entity_user.put("USER_ID", uuid);
			entity_account.put("USER_ID", uuid);
			entity_ext.put("USER_ID", uuid);
			if (entity_user.get("USER_PWD") == null) {
				entity_user.put("USER_PWD", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service","0000")));
			} else {
				entity_user.put("USER_PWD", Encipher.EncodePasswd((String) entity_user.get("USER_PWD")));
			}
			if (entity_user.get("USER_PWD_RESET") != null
					&& entity_user.get("USER_PWD_RESET").toString().equals("1")) {
				entity_user.put("USER_PWD", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service","0000")));
				entity_user.remove("USER_PWD_RESET");
			}
			
			//新增
			business.insert_user(entity_user);
			entity_account.remove("FLAG");
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager
					.getBusiness(SystemOpeBusiness.class);
			Map<String, Object> entity = new HashMap<String, Object>();
			entity.putAll(entity_user);
			entity.putAll(entity_account);
			entity.putAll(entity_ext);
			if (flag.equals(""))
				sysbusiness.insert_logBusiness("insertUser", "" + entity,
						"增加人员记录", uuid, (String) entity.get("USER_NAME"),
						"JW_APPS_UICM_USER_INFO");
			else {
				sysbusiness.insert_logBusiness("updateUser", "" + entity,
						"恢复人员记录", uuid, (String) entity.get("USER_NAME"),
						"JW_APPS_UICM_USER_INFO");
			}
			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String resetUserPass() throws BusinessException {

		UserTestBusiness business = BusinessManager.getBusiness(UserTestBusiness.class);
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(
				request, "USER0_");
		try {
			entity_user = QueryParamUtil.StringToDate(entity_user);
			if (entity_user.get("USER_PWD") != null) {
				entity_user.put("USER_PWD", Encipher
						.EncodePasswd((String) entity_user.get("USER_PWD")));
			}
			if (entity_user.get("USER_PWD_RESET") != null
					&& entity_user.get("USER_PWD_RESET").toString().equals("1")) {
				entity_user.put("USER_PWD", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service","0000")));
				entity_user.remove("USER_PWD_RESET");
			}

			String userids = (String) entity_user.get("USER_ID");
			String usernames = (String) entity_user.get("USER_NAME");
			String[] userid = userids.split("\\,");
			String[] username = usernames.split("\\,");
			int i = 0;
			for (String string : userid) {
				String name = username[i];
				Map<String, Object> userMap = new HashMap<String, Object>();
				userMap.put("USER_ID", string);
				userMap.put("USER_PWD", entity_user.get("USER_PWD").toString());
				userMap.put("USER_NAME", name);
				business.update_user(userMap);
				// 操作日志
				SystemOpeBusiness sysbusiness = BusinessManager
						.getBusiness(SystemOpeBusiness.class);
				Map<String, Object> entity = new HashMap<String, Object>();
				entity.putAll(userMap);
				sysbusiness.insert_logBusiness("resetUserPass", "" + entity,
						"重置人员密码", string, (String) entity.get("USER_NAME"),
						"JW_APPS_UICM_USER_INFO");
				i++;
			}
			//
			jsonObject.putAll(Status.getStatus(Status.PASS_OK));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.PASS_ERR));
			e.printStackTrace();
		}
		return "json";
	}

	public String updateUser() throws BusinessException {

		UserTestBusiness business = BusinessManager.getBusiness(UserTestBusiness.class);
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(
				request, "USER0_");
		try{
			entity_user = QueryParamUtil.StringToDate(entity_user);
			String userid = (String) entity_user.get("USER_ID");
			business.update_user(entity_user);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager
					.getBusiness(SystemOpeBusiness.class);
			Map<String, Object> entity = new HashMap<String, Object>();
			entity.putAll(entity_user);
			sysbusiness.insert_logBusiness("updateUser", "" + entity, "修改人员记录",
					userid, (String) entity.get("USER_NAME"),
					"JW_APPS_UICM_USER_INFO");
		}catch (Exception e) {
			jsonObject.putAll(Status.getStatus(Status.INSERT_ERR));
			e.printStackTrace();
		}
			jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
	 
		return "json";
	}

	public String deleteUser() throws BusinessException {
		UserTestBusiness business = BusinessManager.getBusiness(UserTestBusiness.class);
		String deletekey = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
	    business.delete_user(ListKey);
		jsonObject.putAll(Status.getStatus(Status.DELETE_OK));
		return "json";
	}
	
	//新增添加
	public String insertUserext() throws BusinessException{
		UserTestBusiness business = BusinessManager.getBusiness(UserTestBusiness.class);
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request, "USER0_");
		try {
			entity_user = QueryParamUtil.StringToDate(entity_user);
			business.insert_user(entity_user);
			jsonObject.putAll(Status.getStatus(Status.INSERT_OK));
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}
}
