package com.gaowj.service.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import net.sf.json.JSONArray;

import com.gaowj.business.aop.LogProxy;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.util.Java_tool;
import com.gaowj.business.util.Page;
import com.gaowj.service.UserInfoService;
import com.gaowj.service.common.ServiceException;
import com.gaowj.service.security.ServiceManager;
import com.jw.app.business.UnitBusiness;
import com.jw.app.business.UserBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class UserInfoServiceImpl implements UserInfoService {

	@Override
	public String listUnitInfo(String tokenId, int pageNo, int pageSize,String unitid, String parentId, String startTime, String endTime)throws ServiceException {
		JSONArray jsonArray = new JSONArray();
		try {
		// 激活该方法
	    ServiceManager.activeToken(tokenId, UserInfoService.class.getName()+ "_listUnitInfo", String.valueOf(pageSize));
	    // 调用相关数据获取接口获取数据
	    UnitBusiness business = (UnitBusiness) LogProxy.get(BusinessManager.getBusiness(UnitBusiness.class),UserInfoService.class.getName(), "listUnitInfo", tokenId,pageNo, pageSize);
		//增加查询参数
	    Java_tool jt = new Java_tool();
		Map<String,Object> query = new HashMap<String,Object>();
		if(StringUtils.isNotEmpty(startTime)){
			Date d_startTime = jt.String2date(startTime);
			query.put("START_UPDATE_TIME", d_startTime);
		}
		if(StringUtils.isNotEmpty(endTime)){
			Date d_endTime = jt.String2date(endTime);
			query.put("END_UPDATE_TIME", d_endTime);
		}

		query.put("UNIT_ID", unitid);
		query.put("PARENT_ID", parentId);
		Page<Map<String, Object>> pageRows = business.list_unit(pageNo, pageSize, query);
		List<Map<String, Object>> listData = new ArrayList<Map<String, Object>>();
		for(Map<String, Object> m:QueryParamUtil.DateToString(pageRows.getItems())){
			Map<String, Object> m_d = new HashMap<String,Object>();
			m_d.put("UUID", m.get("UUID"));m_d.put("UNIT_ID", m.get("UNIT_ID"));
			m_d.put("NAME", m.get("NAME"));m_d.put("PARENT_ID", m.get("PARENT_ID"));
			m_d.put("AREA_TYPE", m.get("AREA_TYPE"));m_d.put("ORDER_ID", m.get("ORDER_ID"));
			m_d.put("OFFICE_PHONE", m.get("OFFICE_PHONE"));m_d.put("TYPE", m.get("TYPE"));
			m_d.put("IS_ENTITY", m.get("IS_ENTITY"));m_d.put("OFFICE_ADRESS", m.get("OFFICE_ADRESS"));
			m_d.put("DESCP", m.get("DESCP"));m_d.put("REMARK", m.get("REMARK"));
			m_d.put("UPDATE_TIME", m.get("UPDATE_TIME"));
			m_d.put("DELETE_FLAG", m.get("DELETE_FLAG"));
			m_d.put("USER_ID", m.get("USER_ID"));
			listData.add(m_d);
		}
		jsonArray.addAll(listData);
		} catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(-5, "数据提取出错!");
        }
		// json数组转成文本传出去
		return jsonArray.toString();
	}

	@Override
	public int listUnitInfoCount(String tokenId, String unitid,String parentId, String startTime, String endTime)throws ServiceException {
		try {
		// 激活该方法
	    ServiceManager.activeToken(tokenId, UserInfoService.class.getName()+ "_listUnitInfoCount", "1");
	    // 调用相关数据获取接口获取数据
	    UnitBusiness business = (UnitBusiness) LogProxy.get(BusinessManager.getBusiness(UnitBusiness.class),UserInfoService.class.getName(), "listUnitInfo", tokenId);
		//增加查询参数
	    Java_tool jt = new Java_tool();
		Map<String,Object> query = new HashMap<String,Object>();
		if(StringUtils.isNotEmpty(startTime)){
			Date d_startTime = jt.String2date(startTime);
			query.put("START_UPDATE_TIME", d_startTime);
		}
		if(StringUtils.isNotEmpty(endTime)){
			Date d_endTime = jt.String2date(endTime);
			query.put("END_UPDATE_TIME", d_endTime);
		}

		query.put("UNIT_ID", unitid);
		query.put("PARENT_ID", parentId);
		int lCount = business.listCount_unit(query);
		return lCount;
        } catch (Exception e) {
            throw new ServiceException(-5, "数据提取出错!");
        }
	}

	@Override
	public String listUserInfo(String tokenId, int pageNo, int pageSize,String unitid, String startTime, String endTime)throws ServiceException {
		JSONArray jsonArray = new JSONArray();
		try {
		// 激活该方法
	    ServiceManager.activeToken(tokenId, UserInfoService.class.getName()+ "_listUserInfo", String.valueOf(pageSize));
	    // 调用相关数据获取接口获取数据
	    UserBusiness business = (UserBusiness) LogProxy.get(BusinessManager.getBusiness(UserBusiness.class),UserInfoService.class.getName(), "listUserInfo", tokenId,pageNo, pageSize);
		//增加查询参数
	    Java_tool jt = new Java_tool();
		Map<String,Object> query = new HashMap<String,Object>();
		if(StringUtils.isNotEmpty(startTime)){
			Date d_startTime = jt.String2date(startTime);
			query.put("START_UPDATE_TIME", d_startTime);
		}
		if(StringUtils.isNotEmpty(endTime)){
			Date d_endTime = jt.String2date(endTime);
			query.put("END_UPDATE_TIME", d_endTime);
		}

		query.put("USER_UNIT_ID", unitid);
		Page<Map<String, Object>> pageRows = business.list_user(pageNo, pageSize, query);
		List<Map<String, Object>> listData = new ArrayList<Map<String, Object>>();
		for(Map<String, Object> m:QueryParamUtil.DateToString(pageRows.getItems())){
			if(m.get("ID_NUMBER")!=null && "6666,Y001".indexOf((String)m.get("ID_NUMBER"))>-1)continue;
			Map<String, Object> m_d = new HashMap<String,Object>();
			m_d.put("ID_NUMBER", m.get("ID_NUMBER"));m_d.put("USER_NAME", m.get("USER_NAME"));
			m_d.put("UNIT_ID", m.get("UNIT_ID"));m_d.put("MOBILE", m.get("MOBILE"));
			m_d.put("USER_SEX", m.get("USER_SEX"));m_d.put("ORDER_ID", m.get("ORDER_ID"));
			m_d.put("EMAIL", m.get("EMAIL"));m_d.put("IP", m.get("IP"));
			m_d.put("TELEPHONE", m.get("TELEPHONE"));m_d.put("CARD_TYPE", m.get("CARD_TYPE"));
			m_d.put("CARD_ID", m.get("CARD_ID"));m_d.put("TECHNIC", m.get("TECHNIC"));
			m_d.put("IS_SFZB", m.get("IS_SFZB"));m_d.put("ZBLB", m.get("ZBLB"));
			m_d.put("POST", m.get("POST"));m_d.put("BEGIN_TIME", m.get("BEGIN_TIME"));
			m_d.put("IS_ACTIVE", m.get("IS_ACTIVE"));m_d.put("REMARK", m.get("REMARK"));
			m_d.put("UPDATE_TIME", m.get("UPDATE_TIME"));
			m_d.put("DELETE_FLAG", m.get("DELETE_FLAG"));
			listData.add(m_d);
		}
		jsonArray.addAll(listData);
		} catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(-5, "数据提取出错!");
        }
		// json数组转成文本传出去
		return jsonArray.toString();
	}

	@Override
	public int listUserInfoCount(String tokenId, String unitid,String startTime, String endTime) throws ServiceException {
		try {
		// 激活该方法
	    ServiceManager.activeToken(tokenId, UserInfoService.class.getName()+ "_listUserInfoCount", "1");
	    // 调用相关数据获取接口获取数据
	    UserBusiness business = (UserBusiness) LogProxy.get(BusinessManager.getBusiness(UserBusiness.class),UserInfoService.class.getName(), "listUserInfoCount", tokenId);
		//增加查询参数
	    Java_tool jt = new Java_tool();
		Map<String,Object> query = new HashMap<String,Object>();
		if(StringUtils.isNotEmpty(startTime)){
			Date d_startTime = jt.String2date(startTime);
			query.put("START_UPDATE_TIME", d_startTime);
		}
		if(StringUtils.isNotEmpty(endTime)){
			Date d_endTime = jt.String2date(endTime);
			query.put("END_UPDATE_TIME", d_endTime);
		}

		query.put("USER_UNIT_ID", unitid);
		int lCount = business.listCount_user(query);
		return lCount;
        } catch (Exception e) {
            throw new ServiceException(-5, "数据提取出错!");
        }
	}

}
