package com.gaowj.service.client.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;

import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;

public class FileDown {
	
	   static String IP="192.168.0.245:8081";
	   static String targetEndpoint="http://"+IP+"/gwykhzwserver/services/FileTransferService.FileTransferServiceHttpSoap12Endpoint/";
	   private static EndpointReference targetEPR = new EndpointReference(targetEndpoint);
	   
	   public static boolean download(String filePath, String fileName, String fileType,String downPath,String tokenId) {
	        try {
	             OMElement data = buildDownloadEnvelope(filePath, fileName, fileType,tokenId);
	             Options options = buildOptions();
	             ServiceClient sender = new ServiceClient();
	             sender.setOptions(options);
	             System.out.println("The data in method download: "+data);
	             OMElement ome = sender.sendReceive(data);
	             System.out.println("Convert the data to element in method download: "+ome);
	             OMText binaryNode = (OMText) ome.getFirstElement().getFirstElement().getFirstOMChild();
	             binaryNode.setOptimize(true); //必须加此句，否则会出现ContentID is null的异常!
	             DataHandler actualDH = (DataHandler) binaryNode.getDataHandler();
	             File dir = new File(downPath);
	     		 if (!dir.exists()) {
	     		    dir.mkdirs();
	     		 }
	             FileOutputStream imageOutStream = new FileOutputStream(downPath+"/"+fileName+"."+fileType);
	             InputStream is = actualDH.getInputStream();
	             imageOutStream.write(IOUtils.getStreamAsByteArray(is));
	             is.close();
	             imageOutStream.close();
	             return true;
	        }catch(Exception e){
	             e.printStackTrace();
	        }
	        return false;
	   }
	   
	   
	       /**
	        * 
	        * @param filePath 
	        * @param fileName
	        * @param fileType
	        * @param tokenId
	        * @return
	        */
		   public static OMElement buildDownloadEnvelope(String filePath, String fileName, String fileType,String tokenId){
		        
			   QName MY_QNAME = new javax.xml.namespace.QName(
		               "http://impl.service.gaowj.com",
		               "download",
		               "fd");
			   QName MY_QNAME1 = new javax.xml.namespace.QName(
		               "http://impl.service.gaowj.com",
		               "filePath",
		               "fd");
			   QName MY_QNAME2 = new javax.xml.namespace.QName(
		               "http://impl.service.gaowj.com",
		               "fileName",
		               "fd");
			   QName MY_QNAME3 = new javax.xml.namespace.QName(
		               "http://impl.service.gaowj.com",
		               "fileType",
		               "fd");
			   QName MY_QNAME4 = new javax.xml.namespace.QName(
		               "http://impl.service.gaowj.com",
		               "tokenId",
		               "fd");
			   
			   OMFactory fac = OMAbstractFactory.getOMFactory();
			   
			   OMElement data = fac.createOMElement("download", fac.createOMNamespace("http://impl.service.gaowj.com", "fd"));;
				 OMElement data1 = fac.createOMElement(MY_QNAME);
				   
				   OMElement _filePath = fac.createOMElement(MY_QNAME1);
			        _filePath.setText(filePath);
			        OMElement _fileName = fac.createOMElement(MY_QNAME2);
			        _fileName.setText(fileName);
			        OMElement _fileType=fac.createOMElement(MY_QNAME3);
			        _fileType.setText(fileType);
			        OMElement _tokenId=fac.createOMElement(MY_QNAME4);
			        _tokenId.setText(tokenId);
			        data.addChild(data1);
			        data1.addChild(_tokenId);
			        data1.addChild(_filePath);
			        data1.addChild(_fileName);
			        data1.addChild(_fileType);
			
			   
			  
		        return data;
		   }
		   
		   private static Options buildOptions() throws AxisFault {
			   Options options = new Options();
			   options.setSoapVersionURI(SOAP11Constants.SOAP_ENVELOPE_NAMESPACE_URI);
			   options.setTo(targetEPR);
			   // enabling MTOM in the client side
			   options.setProperty(Constants.Configuration.ENABLE_MTOM, Constants.VALUE_TRUE);
			   options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
			   return options;
			}

}
