package com.gaowj.service.client.utils;

import java.io.File;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAP11Constants;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;

public class FileUpload {
	
	   static String IP="192.168.0.245:8081";
	   static String targetEndpoint="http://"+IP+"/gwykhzwserver/services/FileTransferService.FileTransferServiceHttpSoap12Endpoint/";
	   private static EndpointReference targetEPR = new EndpointReference(targetEndpoint);
	   
	   public static String upload(String filePath,String fileName, File file, String fileType,String tokenId){ 
		      try {
		          OMElement data = buildUploadEnvelope(filePath,fileName, file, fileType,tokenId);
		          Options options = buildOptions();
		          ServiceClient sender = new ServiceClient();
		          sender.setOptions(options);
		          //System.out.println("The data in method upload: "+data);
		          OMElement ome = sender.sendReceive(data);
		          //System.out.println("Convert the data to element in method upload: "+ome);
		          String b = ome.getFirstElement().getFirstElement().getText();
		          //System.out.println(b);
		          //return Boolean.parseBoolean(b);
		          return b;
		      }catch(Exception e){
		          e.printStackTrace();  
		      }
		      return "upload error!";
		      
		   }
	   /**
	    * 
	    * @param filePath 服务器端保存路径
	    * @param fileName 本地上传文件名
	    * @param file     new File(file)文件内容
	    * @param fileType 本地上传文件扩展名
	    * @param tokenId
	    * @return
	    */
	   public static OMElement buildUploadEnvelope(String filePath,String fileName, File file, String fileType,String tokenId){
		   
		   QName MY_QNAME = new javax.xml.namespace.QName(
	               "http://impl.service.gaowj.com",
	               "upload",
	               "fd");
		   QName MY_QNAME1 = new javax.xml.namespace.QName(
	               "http://impl.service.gaowj.com",
	               "fileContent",
	               "fd");
		   QName MY_QNAME2 = new javax.xml.namespace.QName(
	               "http://impl.service.gaowj.com",
	               "fileName",
	               "fd");
		   QName MY_QNAME3 = new javax.xml.namespace.QName(
	               "http://impl.service.gaowj.com",
	               "fileType",
	               "fd");
		   QName MY_QNAME4 = new javax.xml.namespace.QName(
	               "http://impl.service.gaowj.com",
	               "filePath",
	               "fd");
		   QName MY_QNAME5 = new javax.xml.namespace.QName(
	               "http://impl.service.gaowj.com",
	               "tokenId",
	               "fd");
		   
		   OMFactory fac = OMAbstractFactory.getOMFactory();
		   
		   DataHandler expectedDH;
		   OMElement data = fac.createOMElement("upload", fac.createOMNamespace("http://impl.service.gaowj.com", "fd"));
			OMElement data1 = fac.createOMElement(MY_QNAME);
			   OMElement fileContent = fac.createOMElement(MY_QNAME1);
			   FileDataSource dataSource = new FileDataSource(file);
			   expectedDH = new DataHandler(dataSource);
			   OMText textData = fac.createOMText(expectedDH, true);
			   fileContent.addChild(textData);
			   OMElement _fileName = fac.createOMElement(MY_QNAME2);
			   _fileName.setText(fileName);
			   OMElement _fileType = fac.createOMElement(MY_QNAME3);
			   _fileType.setText(fileType);
			   OMElement _filePath = fac.createOMElement(MY_QNAME4);
			   _filePath.setText(filePath);
			   OMElement _tokenId = fac.createOMElement(MY_QNAME5);
			   _tokenId.setText(tokenId);
			   data.addChild(data1);
			   data1.addChild(_tokenId);
			   data1.addChild(_filePath);
			   data1.addChild(_fileName);
			   data1.addChild(_fileType);
			   data1.addChild(fileContent);
		
		   
		   return data;
		   }
	   
	   private static Options buildOptions() throws AxisFault {
		   Options options = new Options();
		   options.setSoapVersionURI(SOAP11Constants.SOAP_ENVELOPE_NAMESPACE_URI);
		   options.setTo(targetEPR);
		   // enabling MTOM in the client side
		   options.setProperty(Constants.Configuration.ENABLE_MTOM, Constants.VALUE_TRUE);
		   options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
		   return options;
		}
}
