package com.gaowj.service.client.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;

import oracle.sql.BLOB;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.comp.BusinessManager;
import com.gaowj.service.util.ServiceUtil;
import com.jw.app.business.UploadfileBusiness;


public class FileUtils {
	
	private static String tempFilePath = AuthenticateUtil.getEndpoint("tempFilePath");
	
	public static String getTempFilePath() {
		File dir = new File(tempFilePath);
		if (!dir.exists()) {
		    dir.mkdirs();
		}
		return tempFilePath;
	}

	public void setTempFilePath(String tempFilePath) {
		this.tempFilePath = tempFilePath;
	}

	public static String getFileString(File file){
		String ret="";
		FileDataSource dataSource = new FileDataSource(file);
		try {
			ret = IOUtils.toString(dataSource.getInputStream());
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return ret;
	}
	
	public static String getBlobToOEMtext(BLOB b,String Filename,boolean delTempFile)throws Exception{
		   
	    BufferedInputStream bis = new BufferedInputStream(b.getBinaryStream());
	    String tempFileName = getTempFilePath()+"/"+Filename;
	    File tempfile = new File(tempFileName);
		FileOutputStream fio =new FileOutputStream(tempfile);
		IOUtils.copy(bis, fio);
		IOUtils.closeQuietly(bis);
		IOUtils.closeQuietly(fio);
        FileDataSource dataSource = new FileDataSource(tempFileName);
	    DataHandler expectedDH = new DataHandler(dataSource);	
	    OMFactory fac = OMAbstractFactory.getOMFactory();
	    OMText textData = fac.createOMText(expectedDH, true);
	    String ret_s = textData.getText();
	    if(delTempFile){
	    	tempfile.delete();
	    }
	    return ret_s;
   }
	
	public static void BlobToFile(BLOB b,String FilePath,String Filename)throws Exception{	
		File dir = new File(FilePath);
		if (!dir.exists()) {
		    dir.mkdirs();
		}
	    BufferedInputStream bis = new BufferedInputStream(b.getBinaryStream());
	    String tempFileName = FilePath+"/"+Filename;
	    File tempfile = new File(tempFileName);
		FileOutputStream fio =new FileOutputStream(tempfile);
		IOUtils.copy(bis, fio);
		IOUtils.closeQuietly(bis);
		IOUtils.closeQuietly(fio);
   }
	
	public static String setFilepath(String sourcepath,boolean tf)throws Exception{
		String destpath = "";
		if(StringUtils.isEmpty(sourcepath)||StringUtils.equalsIgnoreCase(sourcepath, "UUID"))
			sourcepath = ServiceUtil.getServiceParam("default_Path",ServiceUtil.getProValue("serviceFilePath"));
		Calendar date=Calendar.getInstance();
		SimpleDateFormat format1=new SimpleDateFormat("yyyy"); 
		SimpleDateFormat format2=new SimpleDateFormat("MM");
		SimpleDateFormat format3=new SimpleDateFormat("dd");
		String name1=format1.format(date.getTime());
		String name2=format2.format(date.getTime());
		String name3=format3.format(date.getTime());
		destpath = sourcepath+name1+File.separator+name2+File.separator+name3;
		if(tf){
			File fileDir=new File(destpath);
			if(!fileDir.exists()){
				fileDir.mkdirs();
			}
		}
		return destpath;
	}
	
	public static void db2file(String uuid,String uploadpath,String uploadnew,boolean isDelete){
	    UploadfileBusiness business = BusinessManager.getBusiness(UploadfileBusiness.class);
	    Map<String, Object> mapquery = new HashMap<String, Object>();
        mapquery.put("UUID", uuid);
        List<Map<String, Object>> list = business.list_uploadfile(mapquery);
        byte[] b = (byte[]) list.get(0).get("BINARY_DATA");
	       
		try {
			BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(b));
			File dir = new File(uploadpath);
			if (!dir.exists()) {
			    dir.mkdirs();
			}
			File tempfile = new File(uploadpath+"/"+uploadnew);
			FileOutputStream fio =new FileOutputStream(tempfile);
			IOUtils.copy(bis, fio);
			IOUtils.closeQuietly(bis);
			IOUtils.closeQuietly(fio);
			if(isDelete)tempfile.delete();
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	

}
