package com.gaowj.service.client.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.gaowj.business.util.AssertUtil;

public class YgrxUtil {
	/**
	 * 取得阳光热线相关数据的方法
	 * 
	 * @return List<Map<String, Object>>
	 * @throws IOException
	 * @throws Exception
	 */
	public static List<Map<String, Object>> readContentFromGet(String url)
			throws IOException, Exception {

		URL getUrl = new URL(url);

		// 根据拼凑的URL，打开连接，URL.openConnection()函数会根据
		// URL的类型，返回不同的URLConnection子类的对象，在这里我们的URL是一个http，因此它实际上返回的是HttpURLConnection
		HttpURLConnection connection = (HttpURLConnection) getUrl
				.openConnection();

		// 建立与服务器的连接，并未发送数据
		connection.connect();

		// 发送数据到服务器并使用Reader读取返回的数据
		BufferedReader reader = new BufferedReader(new InputStreamReader(
				connection.getInputStream()));

		String lines;
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		while ((lines = reader.readLine()) != null) {
			// 截取标准的json字符
			lines = lines.substring(9, lines.length() - 1);
			printUtil.print(lines);
			if ("[]".equals(lines)) {
				return null;
			}
			// 将json字符串转换成集合
			list.addAll(AssertUtil.fromJsonString(lines));

		}
		reader.close();
		// 断开连接
		connection.disconnect();
		return list;
	}
}
