package com.gaowj.service.client.utils;

import java.io.InputStream;
import java.sql.Blob;
import java.util.Arrays;

import oracle.sql.CLOB;

public class codeUtil {
    public static String convertBlobToString(Blob blob, String code) throws Exception {

        // arraycopy(被复制的数组, 从第几个元素开始复制, 要复制到的数组, 从第几个元素开始粘贴,
        // 一共需要复制的元素个数);
        if (blob == null) {
            return "";
        }
        InputStream in = blob.getBinaryStream();
        String str = "";
        byte[] byteArray = new byte[1024];
        byte[] tempArray = new byte[] {};
        do {

            int len = in.read(byteArray, 0, 1024);
            if (len == -1) {
                return "";
            }
            int tempSize = tempArray.length;
            tempArray = Arrays.copyOf(tempArray, tempArray.length + len);
            System.arraycopy(byteArray, 0, tempArray, tempSize, len);
            if (len < 1024)
                break;
        } while (in.available() > 0);
        str = new String(tempArray, code);
        return str;
    }

    public static String convertClobToString(CLOB clob, String code) throws Exception {
        // arraycopy(被复制的数组, 从第几个元素开始复制, 要复制到的数组, 从第几个元素开始粘贴,
        // 一共需要复制的元素个数);
        if (clob == null) {
            return "";
        }
        InputStream in = clob.getAsciiStream();
        String str = "";
        byte[] byteArray = new byte[1024];
        byte[] tempArray = new byte[] {};
        do {

            int len = in.read(byteArray, 0, 1024);
            if (len == -1) {
                return "";
            }
            int tempSize = tempArray.length;
            tempArray = java.util.Arrays.copyOf(tempArray, tempArray.length + len);
            java.lang.System.arraycopy(byteArray, 0, tempArray, tempSize, len);
            if (len < 1024)
                break;
        } while (in.available() > 0);
        str = new String(tempArray, code);
        return str;
    }
}
