package com.gaowj.business.test0216;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.test0216Business;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

public class test0216BusinessImpl implements test0216Business {
	
	private test0216DAO test0216DAO;

	public test0216DAO getTest0216DAO() {
		return test0216DAO;
	}

	public void setTest0216DAO(test0216DAO test0216dao) {
		test0216DAO = test0216dao;
	}

	/**
	 * 
	 * 分页提取
	 */
	@Override
	public Page<Map<String, Object>> listData(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = test0216DAO.listData(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = items.size();
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);
  		return page;
	}
	
	/**
	 * 
	 * 提取记录总数
	 */
	@Override
	public int listDataCount(Map<String, Object> query) {
		return test0216DAO.listDataCount(query);
	}

	/**
	 * 
	 * 全部提取
	 */
	@Override
	public List<Map<String, Object>> listData(Map<String, Object> query)
			throws BusinessException {
		return test0216DAO.listData(query);
	}

	/**
	 * 
	 * 插入数据
	 */
	@Override
	public void insertData(Map<String, Object> entity) {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          test0216DAO.insertData(entity);
        }
	}

	/**
	 * 
	 * 更新数据
	 */
	@Override
	public void updateData(Map<String, Object> entity) {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    test0216DAO.updateData(entity);
		}

	}

	/**
	 * 
	 * 删除数据
	 */
	@Override
	public void deleteData(List<String> list) {
		test0216DAO.deleteData(list);

	}


}
