package com.gaowj.util;

import java.util.List;
import java.util.Map;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;

public interface Ldap {
	public void connect() throws NamingException;
	public String search(String searchFilter, String searchBase, String returnedAtts[]) throws NamingException;
	public void update(String rdn, String key, Object value) throws NamingException;
	//public void add(String objectClass, String rdn, Attributes attrs) throws NamingException;
	public void add(String rdn, Attributes attrs) throws NamingException;
	public void delete(String rdn) throws NamingException;
	public void close() throws NamingException;
	public List<Map<String, Object>> searchAll(String searchFilter, String searchBase, String returnedAtts[]) throws NamingException;
	void ldapAllSubContext(String name, String rootNode) throws NamingException;
}
