/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.interceptor.CookieProvider;

public class CookieProviderInterceptor
extends AbstractInterceptor
implements PreResultListener {
    private static final Logger LOG = LoggerFactory.getLogger(CookieProviderInterceptor.class);

    public String intercept(ActionInvocation invocation) throws Exception {
        invocation.addPreResultListener((PreResultListener)this);
        return invocation.invoke();
    }

    protected void addCookiesToResponse(CookieProvider action, HttpServletResponse response) {
        Set<Cookie> cookies = action.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending cookie [#0] with value [#1] for domain [#2]", new String[]{cookie.getName(), cookie.getValue(), cookie.getDomain() != null ? cookie.getDomain() : "no domain"});
                }
                response.addCookie(cookie);
            }
        }
    }

    public void beforeResult(ActionInvocation invocation, String resultCode) {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("beforeResult start", new String[0]);
            }
            ActionContext ac = invocation.getInvocationContext();
            if (invocation.getAction() instanceof CookieProvider) {
                HttpServletResponse response = (HttpServletResponse)ac.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
                this.addCookiesToResponse((CookieProvider)invocation.getAction(), response);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("beforeResult end", new String[0]);
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to setup cookies", (Throwable)ex, new String[0]);
        }
    }
}

