/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.RequestContext;
import org.apache.log4j.Logger;

public class FileUploadServlet
extends FileUpload {
    private static final Logger logger = Logger.getLogger(FileUploadServlet.class);
    private List<String> errors = new ArrayList<String>();

    public FileUploadServlet() {
    }

    public FileUploadServlet(FileItemFactory fileItemFactory) {
        super(fileItemFactory);
    }

    public List parseRequest(RequestContext ctx) throws FileUploadException {
        String charEncoding;
        if (ctx == null) {
            throw new NullPointerException("ctx parameter");
        }
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        String contentType = ctx.getContentType();
        if (contentType == null || !contentType.toLowerCase().startsWith("multipart/")) {
            throw new FileUploadBase.InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
        }
        int requestSize = ctx.getContentLength();
        if (requestSize == -1) {
            logger.error((Object)"the request was rejected because its size is unknown");
            this.errors.add("the request was rejected because its size is unknown");
        }
        if ((charEncoding = this.getHeaderEncoding()) == null) {
            charEncoding = ctx.getCharacterEncoding();
        }
        try {
            byte[] boundary = this.getBoundary(contentType);
            if (boundary == null) {
                logger.error((Object)"the request was rejected because no multipart boundary was found");
                this.errors.add("the request was rejected because no multipart boundary was found");
            }
            InputStream input = ctx.getInputStream();
            MultipartStream multi = new MultipartStream(input, boundary);
            multi.setHeaderEncoding(charEncoding);
            boolean nextPart = multi.skipPreamble();
            while (nextPart) {
                Map headers = this.parseHeaders(multi.readHeaders());
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    String subContentType = this.getHeader(headers, "Content-type");
                    if (subContentType != null && subContentType.toLowerCase().startsWith("multipart/mixed")) {
                        byte[] subBoundary = this.getBoundary(subContentType);
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            headers = this.parseHeaders(multi.readHeaders());
                            if (this.getFileName(headers) != null) {
                                FileItem item = this.createItem(headers, false);
                                OutputStream os = item.getOutputStream();
                                try {
                                    multi.readBodyData(os);
                                }
                                finally {
                                    os.close();
                                }
                                items.add(item);
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else {
                        FileItem item = this.createItem(headers, this.getFileName(headers) == null);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                        }
                        finally {
                            os.close();
                        }
                        items.add(item);
                    }
                } else {
                    multi.discardBodyData();
                }
                nextPart = multi.readBoundary();
            }
            if (requestSize > 1048576000) {
                logger.error((Object)("the request was rejected because its size (" + requestSize + ") exceeds the configured maximum (" + 1048576000 + ")"));
            }
        }
        catch (IOException e) {
            logger.error((Object)("Processing of multipart/form-data request failed. " + e.getMessage()));
            this.errors.add("Processing of multipart/form-data request failed. " + e.getMessage());
        }
        return items;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }
}

