$.extend({
	jfbrother:{
		/**
		 * loading层通用方法
		 * @returns {String}
		 */
		loadStyle:function(){
			return '<div style="text-align:center;"><img src="'+ctx+'/custom/images/loading.gif" style="width:315px;height:315px;margin:auto;"></div>';
		},
		/**
		 * 根据json的key,value对替换原text文本中的@{key}
		 * example:
		 * 	text='你好,@{name}';
		 * 	replaceByJson(text,{name:"小明"});
		 *  得到:你好,小明
		 * @param text
		 * @param json
		 * @returns
		 */
		replaceByJson:function(text,json){
			for(key in json){
				text = text.replace('@{'+key+'}',json[key]);
			}
			return text;
		},
		/**
		 * url地址,context存放rss的容器,回调函数
		 * @param _url
		 * @param context
		 * @param callback
		 * @returns
		 */
		readRSS:function(_url,context,callback){
			//使用雅虎在线查询处理器
			var YqlUrl='http://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20xml%20where%20url%3D"'+_url+'"&format=json&diagnostics=true&callback=?'  
			var rss;
			$.ajax({
				url:YqlUrl,
				async:false,
				dataType:'json',
				success:function(data){
					if(callback){
						callback(data.query.results,context);
					}
				}
			});
			return rss;
		},
		//阻止事件的冒泡,兼容了ie
		stopPropagation:function(){
			if (event.stopPropagation) {   
				// 针对 Mozilla 和 Opera   
				event.stopPropagation();   
			}   
			else if (window.event) {   
				// 针对 IE   
				window.event.cancelBubble = true;   
			}
		},
		//阻止默认行为
		preventDefualt:function(){
			var event = event || window.event;  
		    if (typeof event.preventDefault != 'undefined') {//w3c  
		    	event.preventDefault();  
		     } else{  
		    	event.returnValue = false;//ie  
		     }  
		},
		//返回屏幕分辨率的宽和高
		getViewSizeWithScrollbar:function(){//包含滚动条
			if (window.innerWidth) {
				return {
					width : window.innerWidth,
					height : window.innerHeight
				}
			} else if (document.documentElement.offsetWidth == document.documentElement.clientWidth) {
				return {
					width : document.documentElement.offsetWidth,
					height : document.documentElement.offsetHeight
				}
			} else {
				return {
					width : document.documentElement.clientWidth + getScrollWith(),
					height : document.documentElement.clientHeight + getScrollWith()
				}
			}
		},
		//判断ie浏览器
		IEVersion:function(){
			var userAgent = navigator.userAgent; //取得浏览器的userAgent字符串  
		    var isIE = userAgent.indexOf("compatible") > -1 && userAgent.indexOf("MSIE") > -1; //判断是否IE<11浏览器  
		    var isEdge = userAgent.indexOf("Edge") > -1 && !isIE; //判断是否IE的Edge浏览器  
		    var isIE11 = userAgent.indexOf('Trident') > -1 && userAgent.indexOf("rv:11.0") > -1;
		    if(isIE) {
		        var reIE = new RegExp("MSIE (\\d+\\.\\d+);");
		        reIE.test(userAgent);
		        var fIEVersion = parseFloat(RegExp["$1"]);
		        if(fIEVersion == 7) {
		            return 7;
		        } else if(fIEVersion == 8) {
		            return 8;
		        } else if(fIEVersion == 9) {
		            return 9;
		        } else if(fIEVersion == 10) {
		            return 10;
		        } else {
		            return 6;//IE版本<=7
		        }   
		    } else if(isEdge) {
		        return 'edge';//edge
		    } else if(isIE11) {
		        return 11; //IE11  
		    }else{
		        return -1;//不是ie浏览器
		    }
		},
		//获得浏览器滚动条的宽度
		getScrollbarWidth:function(){
		    var oP = document.createElement('p'), styles = {
		        width: '100px',
		        height: '100px',
		        overflowY: 'scroll',
		    }, i, scrollbarWidth;
		    for (i in styles){
		        oP.style[i] = styles[i];
		    }
		    document.body.appendChild(oP);
		    scrollbarWidth = oP.offsetWidth - oP.clientWidth;
		    oP.remove();
		    return scrollbarWidth;
		},
		//uuid
		uuid:function(){
			var s = [];
			var hexDigits = "0123456789abcdef";
			for (var i = 0; i < 36; i++) {
				s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
			}
			s[14] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
			s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
			s[8] = s[13] = s[18] = s[23] = "-";

			var uuid = s.join("");
			return uuid;
		},
		//当前时间格式化
		dateToStr : function(formatStr, date) {
			formatStr = arguments[0] || "yyyy-MM-dd HH:mm:ss";
			date = arguments[1] || new Date();
			var str = formatStr;
			var Week = [ '日', '一', '二', '三', '四', '五', '六' ];
			str = str.replace(/yyyy|YYYY/, date.getFullYear());
			str = str.replace(/yy|YY/, (date.getYear() % 100) > 9 ? (date.getYear() % 100).toString() : '0' + (date.getYear() % 100));
			str = str.replace(/MM/, date.getMonth() > 9 ? (date.getMonth() + 1) : '0' + (date.getMonth() + 1));
			str = str.replace(/M/g, date.getMonth());
			str = str.replace(/w|W/g, Week[date.getDay()]);
			str = str.replace(/dd|DD/, date.getDate() > 9 ? date.getDate().toString() : '0' + date.getDate());
			str = str.replace(/d|D/g, date.getDate());
			str = str.replace(/hh|HH/, date.getHours() > 9 ? date.getHours().toString() : '0' + date.getHours());
			str = str.replace(/h|H/g, date.getHours());
			str = str.replace(/mm/, date.getMinutes() > 9 ? date.getMinutes().toString() : '0' + date.getMinutes());
			str = str.replace(/m/g, date.getMinutes());
			str = str.replace(/ss|SS/, date.getSeconds() > 9 ? date.getSeconds().toString() : '0' + date.getSeconds());
			str = str.replace(/s|S/g, date.getSeconds());
			return str;
		},
		//文件的大小转为B,KB,MB,GB
		fileSizeToStr : function(limit){
			 var size = "";  
            if( limit < 0.1 * 1024 ){ //如果小于0.1KB转化成B  
                size = limit.toFixed(2) + "B";    
            }else if(limit < 0.1 * 1024 * 1024 ){//如果小于0.1MB转化成KB  
                size = (limit / 1024).toFixed(2) + "KB";              
            }else if(limit < 0.1 * 1024 * 1024 * 1024){ //如果小于0.1GB转化成MB  
                size = (limit / (1024 * 1024)).toFixed(2) + "MB";  
            }else{ //其他转化成GB  
                size = (limit / (1024 * 1024 * 1024)).toFixed(2) + "GB";  
            }  
              
            var sizestr = size + "";   
            var len = sizestr.indexOf("\.");  
            var dec = sizestr.substr(len + 1, 2);  
            if(dec == "00"){//当小数点后为00时 去掉小数部分  
                return sizestr.substring(0,len) + sizestr.substr(len + 3,2);  
            }  
            return sizestr;  
		 },
		 /*
		 ** randomWord 产生任意长度随机字母数字组合
		 ** randomFlag-是否任意长度 min-任意长度最小位[固定位数] max-任意长度最大位
		 ** xuanfeng 2014-08-28
		 */
		 randomWord : function(randomFlag, min, max){
		     var str = "",
		         range = min,
		         arr = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
		  
		     // 随机产生
		     if(randomFlag){
		         range = Math.round(Math.random() * (max-min)) + min;
		     }
		     for(var i=0; i<range; i++){
		         pos = Math.round(Math.random() * (arr.length-1));
		         str += arr[pos];
		     }
		     return str;
		 },
		/**
		 * 计算两个时间值的差值如2018-8-16 2018-8-17 相差一天
		 */
		 countTime:function(start,end){
			var start_list = start.split('-');
			var end_list = end.split('-');
			var date1=new Date(start_list[0],start_list[1],start_list[2]);
			var date2=new Date(end_list[0],end_list[1],end_list[2]);
			var date=(date2.getTime()-date1.getTime())/(1000*60*60*24);/*不用考虑闰年否*/
			return date;
		 },
		 /**树的搜索功能
		  * @param zTreeId ztree对象的id,不需要#
		  * @param searchField 输入框选择器
		  * @param isHighLight 是否高亮,默认高亮,传入false禁用
		  * @param isExpand 是否展开,默认合拢,传入true展开
		  * @param searchBtn 绑定要点击的那个按钮的选择器
		  */
		 fuzzySearch:function(zTreeId, searchField, isHighLight, isExpand,searchBtn){
			var zTreeObj = $.fn.zTree.getZTreeObj(zTreeId);//get the ztree object by ztree id
			if(!zTreeObj){
				alter("fail to get ztree object");
			}
			var nameKey = zTreeObj.setting.data.key.name; //get the key of the node name
			isHighLight = isHighLight===false?false:true;//default true, only use false to disable highlight
			isExpand = isExpand?true:false; // not to expand in default
			zTreeObj.setting.view.nameIsHTML = isHighLight; //allow use html in node name for highlight use
			
			var metaChar = '[\\[\\]\\\\\^\\$\\.\\|\\?\\*\\+\\(\\)]'; //js meta characters
			var rexMeta = new RegExp(metaChar, 'gi');//regular expression to match meta characters
			
			// keywords filter function 
			function ztreeFilter(zTreeObj,_keywords,callBackFunc) {
				if(!_keywords){
					_keywords =''; //default blank for _keywords 
				}
				
				// function to find the matching node
				function filterFunc(node) {
					if(node && node.oldname && node.oldname.length>0){
						node[nameKey] = node.oldname; //recover oldname of the node if exist
					}
					zTreeObj.updateNode(node); //update node to for modifications take effect
					if (_keywords.length == 0) {
						//return true to show all nodes if the keyword is blank
						zTreeObj.showNode(node);
						//zTreeObj.expandNode(node,isExpand);
						//如果没有输入值时,则显示所有的目录,并且折叠
						zTreeObj.expandNode(node,false);
						return true;
					}
					//transform node name and keywords to lowercase
					if (node[nameKey] && node[nameKey].toLowerCase().indexOf(_keywords.toLowerCase())!=-1) {
						if(isHighLight){ //highlight process
							//a new variable 'newKeywords' created to store the keywords information 
							//keep the parameter '_keywords' as initial and it will be used in next node
							//process the meta characters in _keywords thus the RegExp can be correctly used in str.replace
							var newKeywords = _keywords.replace(rexMeta,function(matchStr){
								//add escape character before meta characters
								return '\\' + matchStr;
							});
							node.oldname = node[nameKey]; //store the old name  
							var rexGlobal = new RegExp(newKeywords, 'gi');//'g' for global,'i' for ignore case
							//use replace(RegExp,replacement) since replace(/substr/g,replacement) cannot be used here
							node[nameKey] = node.oldname.replace(rexGlobal, function(originalText){
								//highlight the matching words in node name
								var highLightText =
									'<span style="margin-left:0;color: whitesmoke;background-color: darkred;">'
									+ originalText
									+'</span>';
								return 	highLightText;					
							});
							zTreeObj.updateNode(node); //update node for modifications take effect
						}
						zTreeObj.showNode(node);//show node with matching keywords
						return true; //return true and show this node
					}
					
					zTreeObj.hideNode(node); // hide node that not matched
					return false; //return false for node not matched
				}
				
				var nodesShow = zTreeObj.getNodesByFilter(filterFunc); //get all nodes that would be shown
				processShowNodes(nodesShow, _keywords);//nodes should be reprocessed to show correctly
			}
			
			/**
			 * reprocess of nodes before showing
			 */
			function processShowNodes(nodesShow,_keywords){
				if(nodesShow && nodesShow.length>0){
					//process the ancient nodes if _keywords is not blank
					if(_keywords.length>0){ 
						$.each(nodesShow, function(n,obj){
							var pathOfOne = obj.getPath();//get all the ancient nodes including current node
							if(pathOfOne && pathOfOne.length>0){ 
								//i < pathOfOne.length-1 process every node in path except self
								for(var i=0;i<pathOfOne.length-1;i++){
									zTreeObj.showNode(pathOfOne[i]); //show node 
									zTreeObj.expandNode(pathOfOne[i],true); //expand node
								}
							}
						});	
					}else{ //show all nodes when _keywords is blank and expand the root nodes
						var rootNodes = zTreeObj.getNodesByParam('level','0');//get all root nodes
						$.each(rootNodes,function(n,obj){
							zTreeObj.expandNode(obj,true); //expand all root nodes
						});
					}
				}
			}
			
			//listen to change in input element
			/*$(searchField).bind('input propertychange', function() {
				var _keywords = $(this).val();
				searchNodeLazy(_keywords); //call lazy load
			});

			var timeoutId = null;
			// excute lazy load once after input change, the last pending task will be cancled  
			function searchNodeLazy(_keywords) {
				if (timeoutId) { 
					//clear pending task
					clearTimeout(timeoutId);
				}
				timeoutId = setTimeout(function() {
					ztreeFilter(zTreeObj,_keywords); //lazy load ztreeFilter function 
					$(searchField).focus();//focus input field again after filtering
				}, 500);
			}*/
			
			//绑定要点击的那个按钮
			$(searchBtn).bind('click',function(){
				var _keywords = $(searchField).val();
				ztreeFilter(zTreeObj,_keywords);
			})
			//输入框的回车键操作
			$(searchField).bind("keydown",function(e){
			　　// 兼容FF和IE和Opera
			　　var theEvent = e || window.event;
			　　var code = theEvent.keyCode || theEvent.which || theEvent.charCode;
			　　 if (code == 13) {
					//回车执行查询
					var _keywords = $(searchField).val();
					ztreeFilter(zTreeObj,_keywords);
			　　}
			});
		 },
		 /**去掉Html标签代码
		  *  @param str 带有Html的字符串
		  */
		 removeHtml:function(str){
			str = str || "";//防止空指针
			str = str.replace(/<(?!\/?p\b)[^>]+>|(<p)\b[^>]*(>)/ig, "$1$2");
			str = str.replace(/\s+/g,"");
			str = str.replace(new RegExp("&nbsp;","gm"),"");
			return str;
		 }
		 //
	}
});