(function($){
	
	//文件状态码
	var fileStatus = {
		INITED : 'inited', // 初始状态
		QUEUED : 'queued', // 已经进入队列, 等待上传
		PROGRESS : 'progress', // 上传中
		ERROR : 'error', // 上传出错，可重试
		COMPLETE : 'complete', // 上传完成。
		CANCELLED : 'cancelled', // 上传取消。
		INTERRUPT : 'interrupt', // 上传中断，可续传。
		INVALID : 'invalid' // 文件不合格，不能重试上传。
	};

	//定义公共的参数(变量,方法)
	var defaults_options = {
			inputName:'',
			startBtn:{
				'class':'webupload_startBtn',
				'style':{
						'color':'white'
					},
				'container':''
			},
			stopBtn:{
				'class':'webupload_stopBtn',
				'style':'',
				'container':''
			},
			//文件名
			fileNameDiv:{
				'class':'webupload_info',
				'style':{
					'color':'red',
					'background':'#f3f3f3',
					'padding':'3px'
				}
			},
			//文件容器
			fileList:{
				'container':'',
				'class':'webupload_fileList',
				'style':''
			},
			//每个文件容器
			fileDiv:{
				'class':'webupload_fileDiv',
				'style':''
			},
			closeImg:{
				'class':'webupload_closeImg',
				'src':'images/demo_x.png',
				'style':''
			},
			progress:{
				show:false,
				container:'',
				type:'line',
				bottomBg:'orange',
				topBg:'skyblue',
				width:'',
				height:'',
				radius:'',
				bottomBorder:'',
				topBorder:'',
				bottomClass:'',
				font:{
					color:'red',
					size:'20px',
					family:'微软雅黑',
					style:'',
					weight:'',
					formatter:'',
					class:''
				},
				class:'webupload_progress',
				align:'center'
			},
			// swf文件路径
			swf : "${ctx}/custom/plug/webupload/js/Uploader.swf",
			// 文件接收服务端。
			server : 'attachment/upload',
			// 选择文件的按钮。可选。
			// 内部根据当前运行是创建，可能是input元素，也可能是flash.
			// 只允许选择图片文件。
			dnd : '' ,//指定Drag And Drop拖拽的容器，如果不指定，则不启动。
			accept : {
				title : 'Images',
				extensions : 'gif,jpg,jpeg,bmp,png',
				mimeTypes : 'image/*'
			/* title: 'intoTypes',
	            extensions: 'rar,zip,doc,xls,docx,xlsx,pdf,txt',
	            mimeTypes: '.rar,.zip,.doc,.xls,.docx,.xlsx,.pdf,.txt' */
			},
			pick : {
				name : "upload",
				multiple : false,  //是否开起同时选择多个文件能力。
				class:'',
				style:''
			},
			fileVal : "upload" ,//指明参数名称，后台也用这个参数接收文件
			// 选完文件后，是否自动上传。
			auto : true,
			// 只允许选择图片文件。
			paste : document.body, //此功能为通过粘贴来添加截屏的图片
			disableGlobalDnd : true, //是否禁掉整个页面的拖拽功能，如果不禁用，图片拖进来的时候会默认被浏览器打开。
			prepareNextFile : false, //是否允许在文件传输时提前把下一个文件准备好。 对于一个文件的准备工作比较耗时，比如图片压缩，md5序列化。 如果能提前在当前文件传输期处理，可以节省总体耗时。
			chunked : false,  //是否要分片处理大文件上传。
			chunkSize : 1024*200,  //如果要分片，分多大一片？ 默认大小为5M.
			fileNumLimit : 1,  //验证文件总数量, 超出则不允许加入队列。
			fileSingleSizeLimit : 1024 * 1024 * 250,   //验证单个文件大小是否超出限制, 超出则不允许加入队列。
			fileSizeLimit : 1024 * 1024 * 1024,  //验证文件总大小是否超出限制, 超出则不允许加入队列。
			thumb : {	
				width : 200,
				height : 200
			},
			sendAsBinary : false,  //是否已二进制的流的方式发送文件，这样整个上传内容php://input都为文件内容， 其他参数在$_GET数组中。
			duplicate : false,//是否可重复选择同一文件
			threads : '1', //如果是单文件上传就可以用多个并发,如果是多文件就只能用一个
			/*compress: false,//不启用压缩*/
		    resize: false//尺寸不改变
	}
	
	var defaults_options_str=JSON.stringify(defaults_options);
	
	$.webuploadutil={
			//下载
			getDownUrl:function(md5){
				return 'attachment/down?url='+md5;
			},
			//带名字的下载
			downFile:function(file){
				var fileName = encodeURI(file.fileName);
			 	return 'attachment/downByMd5?md5='+file.md5Id+'&fileName='+ fileName;
			},
			//根据表单id把数据填充进去
			loadAttachment:function(formId,data){
				for(var i = 0; i < data.length; i++ ){
					var listAttachment = data[i].listAttachment;
					var slaveKey = data[i].slaveKey;
					var $attachmentInput = $('<input type="hidden" name="attachment_'+ slaveKey +'"/>');
					for(var index in listAttachment){
						listAttachment[index].uuid = stringutil.uuid();
					}
					$attachmentInput.val(JSON.stringify(listAttachment));
					if($('#'+formId).find($attachmentInput).length==0){
						$('#'+formId).append($attachmentInput);
					}
				}
			}
	};
	
	$.fn.webupload = function(options){
		var defaults=JSON.parse(defaults_options_str);

		//webupload插件源句柄
		var webupload;
		
		defaults.pick.id='#'+$(this).attr('id');
		//$(this).css('clear','both');
		//配置
		if(options!=null){
			$.each(options, function(i, val) {
	          if (typeof val == 'object' && defaults[i]){
	        	  $.extend(true,defaults[i], val);
	          }
	          else {
	        	  defaults[i] = val;
	          }
	        });
		}
		
		//强制图片不压缩
		defaults.compress=false;
		
		//如果按钮中有name属性则填充好到inputName中
		if($(this).attr('name')!=null||$(this).attr('name')!=''){
			defaults.inputName = $(this).attr('name');
		}
		
		//如果js有传进来,则覆盖inputName中
		if(options.inputName){
			defaults.inputName = options.inputName;
		}
		
		//如果用户定义了makeFileList方法,则进行调用
		var listAttachmentInput = $('input[name=attachment_'+defaults.inputName+']').val();
		if(typeof options.makeFileList=='function' && !stringutil.isEmpty(listAttachmentInput)){
			options.makeFileList(JSON.parse(listAttachmentInput));
		}
		
		//添加上传参数
		defaults.formData ={
			chunkSize : defaults.chunkSize   //文件上传请求的参数表，每次发送都会发送此对象中的参数。
		}
		
		/*********************************/
		//原来的句柄
  		webupload = WebUploader.create(defaults);

		//当某个文件的分块在发送前触发，主要用来询问是否要添加附带参数，大文件在开起分片上传的前提下此事件可能会触发多次。
		webupload.on('uploadBeforeSend', function(obj, data, headers) {
			//每个碎片上传之前,获取该完整文件的md5值传输过去
			data.fileMd5=obj.file.fileMd5;
		});

		webupload.on( 'fileQueued', function( file ) {
			//调用用户自定义的fileQueued方法
  			if(options!=null && typeof options.fileQueued =='function'){
  				options.fileQueued(file);
  			}
		});
		
		webupload.on( 'filesQueued', function( files ) {
			//调用用户自定义的fileQueued方法
  			if(options!=null && typeof options.filesQueued =='function'){
  				options.filesQueued(files);
  			}
		});
		

  		//当文件被加入队列之前触发，此事件的handler返回值为false，则此文件不会被添加进入队列。
		webupload.on('beforeFileQueued', function(file){
			//调用用户自定义的beforeFileQueued方法
  			if(options!=null && typeof options.beforeFileQueued =='function'){
  				return options.beforeFileQueued(file);
  			}
		});
		
		/*//成功时的回调,如果用户有传进来,那就先执行传进来的再执行默认的
		webupload.on('uploadSuccess',function(file) {
  			
			//文件上传成功后, 在队列清除
			webupload.removeFile(file,true);
			//添加上传内容的影藏域
			addHiddenInput(webupload_handler,file,1);
  		
			//调用用户自定义的uploadSuccess方法
  			if(options!=null && typeof options.uploadSuccess =='function'){
  				options.uploadSuccess(file);
  			}
			
        	//webupload.upload();
	        	
  		})*/
  		
    	// 文件上传失败，显示上传出错。
  		webupload.on('uploadError',function(file) {
  			//提示用户上传错误,需补充
  			if(options!=null && typeof options.uploadError =='function'){
  				options.uploadError(file);
  			}
  			
  		});
  		
  		//当某个文件上传到服务端响应后，会派送此事件来询问服务端响应是否有效。如果此事件handler返回值为false, 则此文件将派送server类型的uploadError事件。
		webupload.on('uploadAccept',function(object,ret) {
			/*if(ret.code!='0000'){
				return false;
			}*/
			
			//把后台返回来的数据都返回到前台
			//调用用户自定义的uploadSuccess方法
  			if(options!=null && typeof options.uploadSuccess =='function'){
  				options.uploadSuccess(object.file,ret);
  			}
		});
		
		//上传开始前,判断是否需要秒传,如果是则跳过
		webupload.on('uploadProgress', function(file,percentage){
			if(file.quick){
				webupload.cancelFile(file);
			}
			addHiddenInput(webupload_handler,file,percentage);
		});
        
  		// 完成上传完了，成功或者失败，先删除进度条。
  		webupload.on('uploadComplete', function(file ) {
  			if(options!=null && typeof options.uploadComplete =='function'){
  				options.uploadComplete(file);
  			}
  			//$('#' + file.id).find('.progress').remove();
  		});
		
		webupload.on('error', function(type){
		});
		
		function addHiddenInput(webupload_handler,file,percentage){
			if(file.quick){
				//如果是秒传,进度条肯定是百分百
				percentage=1;
			}
			var webupload=webupload_handler.getWebuploadHandler();
			var inputName = webupload.option('inputName');
  			var fileNumLimit = webupload.option('fileNumLimit');
  			var container =  webupload.option('fileList').container;
  			var pickId = webupload.option('pick').id;
  			var options=webupload.option();
			//成功时添加一个隐藏域
			var $listAttachmentInput=$('input[name="attachment_'+ inputName +'"]');
  			if(webupload_handler.formContainer.find($listAttachmentInput).length==0 && inputName!=''){
  				$(pickId).before('<input type="hidden" name="attachment_'+ inputName +'" />');
  			}
  			
  			//获取原先存储的附件信息,如果为空,则新建数组
  			var listAttachment=$listAttachmentInput.val();
  			if(listAttachment==null){
  				listAttachment=[];
  			}else{
  				listAttachment=eval('('+listAttachment+')');
  			}
  			
  			//将本次上传成功的文件加入listAttachment
  			//如果是单文件上传时,清空数组
	  		if(fileNumLimit==1){
	  			listAttachment=[];
	  		}

  			var if_push=true;
  			for(var i=0;i<listAttachment.length;i++){
  				if(listAttachment[i].uuid==file.uuid){
  					if_push=false;
  					break;
  				}
  			}
  			if(if_push){
	  			listAttachment.push({
	  				md5Id:file.fileMd5,
	  				fileName:file.name,
	  				fileType:file.ext,
	  				size:file.size,
	  				//uuid:stringutil.uuid(),//每一行文件数据随机生成一个uuid,用作文件删除时候用
	  				uuid:file.uuid,
	  				fileId:file.id//队列中的文件id,删除时根据这个id去删除
	  			});
  			}
  			
  			$('input[name="attachment_'+ inputName +'"]').val(JSON.stringify(listAttachment));
  			
  			//如果用户定义了makeFileList方法,则进行调用
  			if(fileNumLimit==1&&percentage!=1){
	  			return;
	  		}
  			if(typeof options.makeFileList=='function'){
  				options.makeFileList(listAttachment);
  			}
		}
		
  		//创建缩略图
  		/**
  		 * (最大显示个数,文件)
  		 */
  		function webupload_createFileList(fileNumLimit,file){
  			//如果是自动上传时,则会做重传操作
  			if(defaults.auto){
  				webupload_upload();
  			}
  			if(defaults.fileList.container==''){
  				return;
  			}
  			$(defaults.fileList.container).css(defaults.fileList.style);
			$(defaults.fileList.container).addClass(defaults.fileList.class);
  			//重新加入时,如果队列中已经有文件在上传,那么该文件就准备重新上传
  			if(webupload.getFiles(fileStatus.INTERRUPT).length!=0||$(defaults.fileList.container).find('div').length==0){
  				//如果已经暂停的话就暂停掉
  				webupload.stop(true);
  			}
  			else if(webupload.isInProgress()){
  				if(webupload.getFiles(fileStatus.INTERRUPT).length>0){
  					//正在上传就重新上传
  	  				webupload.upload();
  				}
  			}	
  			var $li = $(
  					'<div id="' + file.id + '" class="">' +
  					'<img>' +
  					'<div class="'+ defaults.fileNameDiv.class +'">' + file.name + '</div>' +
  					'</div>'
  				),
			$img = $li.find('img');
  			// $list为容器jQuery实例
  			$(defaults.fileList.container).append($li);
  			$('.'+defaults.fileNameDiv.class).css(defaults.fileNameDiv.style);
			$('#'+file.id).css(defaults.fileDiv.style);
			$('#'+file.id).addClass(defaults.fileDiv.class);
  			// 创建缩略图
  			// 如果为非图片文件，可以不用调用此方法。
  			// thumbnailWidth x thumbnailHeight 为 100 x 100
  			webupload.makeThumb(file, function(error, src) {
  				if (error) {
  					$img.replaceWith('<span>无法预览</span>');
  					$(defaults.fileList.container).css('min-height',$li.height());
  					return;
  				}
  				$img.attr('src', src);
  				$(defaults.fileList.container).css('min-height',$li.find('.'+defaults.fileNameDiv.class).outerHeight()+defaults.thumb.height);
  			}  , defaults.thumb.width, defaults.thumb.height);
  			
  		}
  		
  		//上传
  		function webupload_upload(){
  			//重试上传，重试指定文件，或者从出错的文件开始重新上传。
			var interruptFiles=webupload.getFiles(fileStatus.INTERRUPT);
			//已经暂停的文件
			if(interruptFiles.length>0){
				interruptFiles.forEach(function(value, index, array){
					webupload.upload(value);
				});
			}else{
				webupload.upload();
			}
  		}
  		//处理进度条数据
  		/**
  		 * (已经上传上去的碎片百分比,文件)
  		 */
  		function webupload_createUploadProgress(response,file){
			webupload.on('uploadProgress', function(file, percentage) {
				if(percentage==1){
					response = '100';
				}
				response = response>Math.floor(percentage*100)?response:Math.floor(percentage * 100);
				webupload_createProgress(file,response);
			})
  		}
  		//创建进度条
  		function webupload_createProgress(file,response){
  			if(options!=null && typeof options.addProgress == 'function'){
				options.addProgress(file,response);
				return;
			}
  			var $li;
  			//先判断是否显示进度条
  			if(!defaults.progress.show){
  				return;
  			}
			//容器存在并是单文件时
			if(defaults.progress.container!=''&&defaults.fileNumLimit=="1"){
				//先清除原来的进度条
				$(defaults.progress.container).children().remove();
				$li = $(defaults.progress.container);
			}
			//是多文件时
			if(defaults.fileNumLimit!="1"){
				$li = $('#' + file.id).append($('<div></div>')).find('.'+defaults.fileNameDiv.class).next();
			}
			//没有容器的单文件时
			if(defaults.progress.container==''&&defaults.fileNumLimit=="1"){
				//先清除原来的进度条
				$('.'+defaults.progress.class).remove();
				$li = $(defaults.pick.id).after($('<div></div>')).next();
			}
			//类型是线性的时候
  			if(defaults.progress.type=='line'){
  				$percent = $li.find('span');
  				// 避免重复创建
  				if (!$percent.length) {
  					$percent = $('<div class="'+ defaults.progress.bottomClass +'" style="background:'+ defaults.progress.bottomBg +';border:'+ defaults.progress.bottomBorder +'"></div><p></p><span></span>')
  						.appendTo($li)
  						.parent().find('span');  					
  				}
  				$percent.parent().css({
  					//多文件的时候宽度设置为无效
  					width:defaults.fileNumLimit==1?defaults.progress.width:''
  				})
  				$percent.parent().addClass(defaults.progress.class);
  				$percent.parent().css({
  					height:defaults.progress.height
  				})
  				$percent.prev().css({
  					background:defaults.progress.topBg,
  					border:defaults.progress.topBorder,
  					width:response+'%',
  					height:defaults.progress.height,
  					borderRadius:defaults.progress.radius
  				})
  				$percent.prev().prev().css({
  					height:defaults.progress.height,
  					borderRadius:defaults.progress.radius
  				})
  				$percent.text(response+'%');
  				$percent.css({
  					fontSize:defaults.progress.font.size,
  					color:defaults.progress.font.color,
  					fontFamily:defaults.progress.font.family,
  					fontStyle:defaults.progress.font.style,
  					fontWeight:defaults.progress.font.weight,
  					lineHeight:defaults.progress.height,
  					textAlign:defaults.progress.align,
  					//多文件的时候宽度设置为无效
  					width:defaults.fileNumLimit==1?defaults.progress.width:''
  				});
  				$percent.addClass(defaults.progress.font.class);
  			}
			
  		}
		var webupload_handler={
			formContainer:$(this).parents("form"),
			getWebuploadHandler:function(){
				return webupload;
			},
			stop:function(file){
				if(file==null){
					file=true;
				}
				webupload.stop(file);
			},
			upload:function(){
				webupload_upload();
			},
			//获得某个状态的文件返回array
			getFiles:function(state){
			  var fileArray	= webupload.getFiles(state);
			  return fileArray;
			},
			//获得文件
			getFile:function(fileId){
				return webupload.getFile(fileId);
			},
			isInProgress:function(){
				return webupload.isInProgress();
			},
			removeFile:function(file,flag){
				if(flag){
					return webupload.removeFile(file,flag);
				}
				else{
					return webupload.removeFile(file);
				}
			},
			option:function(key,val){
				if(val==null){
					return webupload.option(key);
				}
				else{
					webupload.option(key,val);
				}
			},
			destroy:function(){
				webupload.destroy();
			},
			removeFileList:function(uuid){
				var listFile = JSON.parse($(this.formContainer.find('input[name=attachment_'+webupload.option("inputName")+']')).val());
				var newListFile=[];
				for(var i = 0;i<listFile.length;i++){
					if(listFile[i].uuid!=uuid){
						newListFile.push(listFile[i]);
					}
				}
				$(this.formContainer.find('input[name=attachment_'+webupload.option("inputName")+']')).val(JSON.stringify(newListFile));
				options.makeFileList(newListFile);
			}
		};
		
		//暂停按钮
		$(defaults.stopBtn.container).addClass(defaults.stopBtn.class)
		$(defaults.stopBtn.container).css(defaults.stopBtn.style);
		//开始按钮
		$(defaults.startBtn.container).addClass(defaults.startBtn.class)
		$(defaults.startBtn.container).css(defaults.startBtn.style);
		$(defaults.startBtn.container).on('click', function() {
			webupload_upload();
		});
		$(defaults.stopBtn.container).bind('click',function(){
			webupload.stop( true ); 
		})
		//选择文件按钮的样式
		$(this).find('.webuploader-pick').addClass(defaults.pick.class);
		$(this).find('.webuploader-pick').css(defaults.pick.style);
        return webupload_handler;
	}//$.fn
	
})(jQuery);